/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import com.box.boxjavalibv2.dao.BoxEvent;
import com.box.boxjavalibv2.dao.BoxFile;
import com.box.boxjavalibv2.dao.BoxFolder;
import com.box.boxjavalibv2.dao.BoxItem;
import com.box.boxjavalibv2.dao.BoxSharedLink;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.ConstraintException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.box.BoxAPI;
import org.exoplatform.clouddrive.box.BoxConnector;
import org.exoplatform.clouddrive.box.BoxException;
import org.exoplatform.clouddrive.box.BoxFormatException;
import org.exoplatform.clouddrive.box.BoxProvider;
import org.exoplatform.clouddrive.box.BoxUser;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class JCRLocalBoxDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    public static final long FULL_SYNC_PERIOD = 889032704L;

    protected JCRLocalBoxDrive(BoxUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected JCRLocalBoxDrive(BoxConnector.API apiBuilder, BoxProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws RepositoryException, CloudDriveException {
        super((CloudUser)JCRLocalBoxDrive.loadUser(apiBuilder, provider, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", "0");
    }

    protected static BoxUser loadUser(BoxConnector.API apiBuilder, BoxProvider provider, Node driveNode) throws RepositoryException, BoxException, CloudDriveException {
        String refreshToken;
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("box:oauth2AccessToken").getString();
        try {
            refreshToken = driveNode.getProperty("box:oauth2RefreshToken").getString();
        }
        catch (PathNotFoundException e) {
            refreshToken = null;
        }
        long expirationTime = driveNode.getProperty("box:oauth2TokenExpirationTime").getLong();
        BoxAPI driveAPI = apiBuilder.load(refreshToken, accessToken, expirationTime).build();
        return new BoxUser(userId, username, email, provider, driveAPI);
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("box:oauth2AccessToken", token.getAccessToken());
                driveNode.setProperty("box:oauth2RefreshToken", token.getRefreshToken());
                driveNode.setProperty("box:oauth2TokenExpirationTime", token.getExpirationTime());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        Calendar now = Calendar.getInstance();
        Calendar last = this.rootNode().getProperty("box:streamDate").getDate();
        if (now.getTimeInMillis() - last.getTimeInMillis() < 889032704L) {
            return new EventsSync();
        }
        return new FullSync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("box:streamPosition").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title());
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("box:streamPosition", id.longValue());
        driveNode.setProperty("box:streamDate", Calendar.getInstance());
    }

    public BoxUser getUser() {
        return (BoxUser)this.user;
    }

    public BoxState getState() throws DriveRemovedException, CloudProviderException, RepositoryException, RefreshAccessException {
        return new BoxState(this.getUser().api().getChangesLink());
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        this.getUser().api().updateToken(((BoxUser)newUser).api().getToken());
    }

    protected boolean initBoxItem(Node localNode, BoxItem item) throws RepositoryException, BoxException {
        boolean changed;
        block6: {
            changed = false;
            localNode.setProperty("box:etag", item.getEtag());
            try {
                Long prevSequenceId;
                String sequenceIdStr = item.getSequenceId();
                if (sequenceIdStr == null) break block6;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>> initBoxItem: " + localNode.getPath() + " = " + item.getId() + " " + item.getName() + " " + item.getSequenceId()));
                }
                try {
                    prevSequenceId = localNode.getProperty("box:sequenceId").getLong();
                }
                catch (PathNotFoundException e) {
                    prevSequenceId = null;
                }
                long sequenceId = Long.parseLong(sequenceIdStr);
                localNode.setProperty("box:sequenceId", sequenceId);
                changed = prevSequenceId != null ? sequenceId != prevSequenceId : true;
            }
            catch (NumberFormatException e) {
                throw new BoxException("Error parsing sequence_id of " + localNode.getPath(), e);
            }
        }
        localNode.setProperty("box:ownedBy", item.getOwnedBy().getLogin());
        localNode.setProperty("box:description", item.getDescription());
        BoxSharedLink shared = item.getSharedLink();
        if (shared != null) {
            localNode.setProperty("box:sharedAccess", shared.getAccess());
            localNode.setProperty("box:sharedCanDownload", shared.getPermissions().isCan_download().booleanValue());
        }
        return changed;
    }

    protected String findMimetype(String fileName) {
        String name = fileName.toUpperCase().toLowerCase();
        String ext = name.substring(name.lastIndexOf(".") + 1);
        if (ext.equals("webdoc")) {
            return "application/x-exo.box.webdoc";
        }
        if (ext.equals("boxnote")) {
            return "application/x-exo.box.note";
        }
        return this.mimeTypes.getMimeType(fileName);
    }

    protected JCRLocalCloudFile updateItem(BoxAPI api, BoxItem item, Node parent, Node node) throws RepositoryException, CloudDriveException {
        try {
            JCRLocalCloudFile file;
            String id = item.getId();
            String name = item.getName();
            boolean isFolder = item instanceof BoxFolder;
            String type = isFolder ? item.getType() : this.findMimetype(name);
            long sequenceId = this.getSequenceId(item);
            if (node == null) {
                node = isFolder ? this.openFolder(id, name, parent) : this.openFile(id, name, parent);
            }
            boolean changed = node.isNew() || sequenceId >= 0L && node.getProperty("box:sequenceId").getLong() < sequenceId || !node.getProperty("box:etag").getString().equals(item.getEtag());
            Calendar created = api.parseDate(item.getCreatedAt());
            Calendar modified = api.parseDate(item.getModifiedAt());
            String createdBy = item.getCreatedBy().getLogin();
            String modifiedBy = item.getModifiedBy().getLogin();
            if (isFolder) {
                String embedLink;
                String link = embedLink = api.getLink(item);
                String thumbnailLink = api.getThumbnailLink(item);
                if (changed) {
                    this.initFolder(node, id, name, type, link, createdBy, modifiedBy, created, modified);
                    this.initBoxItem(node, item);
                }
                file = new JCRLocalCloudFile(node.getPath(), id, name, link, type, modifiedBy, createdBy, created, modified, node, true);
            } else {
                String link = api.getLink(item);
                String embedLink = api.getEmbedLink(item);
                String thumbnailLink = api.getThumbnailLink(item);
                long size = Math.round(item.getSize());
                if (changed) {
                    this.initFile(node, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                    this.initBoxItem(node, item);
                }
                file = new JCRLocalCloudFile(node.getPath(), id, name, link, embedLink, thumbnailLink, type, null, createdBy, modifiedBy, created, modified, size, node, changed);
            }
            return file;
        }
        catch (ParseException e) {
            throw new BoxFormatException("Error parsing date of " + parent.getPath() + "/" + item.getName(), e);
        }
    }

    protected boolean notInRange(String path, Collection<String> range) {
        for (String p : range) {
            if (!path.startsWith(p)) continue;
            return false;
        }
        return true;
    }

    protected Long getSequenceId(BoxItem item) throws BoxFormatException {
        try {
            String sequenceIdStr = item.getSequenceId();
            if (sequenceIdStr != null) {
                return Long.parseLong(sequenceIdStr);
            }
            return -1L;
        }
        catch (NumberFormatException e) {
            throw new BoxFormatException("Error parsing sequence_id of " + item.getId() + " " + item.getName(), e);
        }
    }

    protected String previewLink(Node fileNode) throws RepositoryException {
        BoxUser user = this.getUser();
        String link = super.previewLink(fileNode);
        if (link != null && user.getProvider().isLoginSSO() && user.getEnterpriseId() != null) {
            try {
                link = URLEncoder.encode(link, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Cannot encode URL " + fileNode + ":" + e));
            }
            return String.format("https://app.box.com/login/auto_initiate_sso?enterprise_id=%s&redirect_url=%s", user.getEnterpriseId(), link);
        }
        return link;
    }

    public class BoxState
    implements CloudDrive.FilesState {
        final BoxAPI.ChangesLink link;

        protected BoxState(BoxAPI.ChangesLink link) {
            this.link = link;
        }

        public Collection<String> getUpdating() {
            return JCRLocalBoxDrive.this.state.getUpdating();
        }

        public boolean isUpdating(String fileIdOrPath) {
            return JCRLocalBoxDrive.this.state.isUpdating(fileIdOrPath);
        }

        public boolean isNew(String fileIdOrPath) {
            return JCRLocalBoxDrive.this.state.isNew(fileIdOrPath);
        }

        public String getType() {
            return this.link.getType();
        }

        public String getUrl() {
            return this.link.getUrl();
        }

        public long getTtl() {
            return this.link.getTtl();
        }

        public long getMaxRetries() {
            return this.link.getMaxRetries();
        }

        public long getRetryTimeout() {
            return this.link.getRetryTimeout();
        }

        public long getOutdatedTimeout() {
            return this.link.getOutdatedTimeout();
        }

        public long getCreated() {
            return this.link.getCreated();
        }

        public boolean isOutdated() {
            return this.link.isOutdated();
        }
    }

    protected class EventsSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final BoxAPI api;
        protected final Set<String> history;
        protected final Set<String> newHistory;
        protected final LinkedList<BoxEvent> postponed;
        protected final Map<String, JCRLocalCloudFile> applied;
        protected final Map<String, BoxItem> undeleted;
        protected final Set<String> removedIds;
        protected BoxAPI.EventsIterator events;
        protected BoxEvent nextEvent;
        protected BoxEvent lastPostponed;
        protected int prevPostponedNumber;
        protected int postponedNumber;
        protected int appliedCounter;
        protected int readCounter;

        protected EventsSync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalBoxDrive.this);
            this.history = new LinkedHashSet<String>();
            this.newHistory = new LinkedHashSet<String>();
            this.postponed = new LinkedList();
            this.applied = new LinkedHashMap<String, JCRLocalCloudFile>();
            this.undeleted = new LinkedHashMap<String, BoxItem>();
            this.removedIds = new LinkedHashSet<String>();
            this.appliedCounter = 0;
            this.readCounter = 0;
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void syncFiles() throws CloudDriveException, RepositoryException {
            long localStreamPosition = JCRLocalBoxDrive.this.getChangeId();
            this.events = this.api.getEvents(localStreamPosition);
            this.iterators.add(this.events);
            for (String es : this.rootNode.getProperty("box:streamHistory").getString().split(";")) {
                this.history.add(es);
            }
            while (this.hasNextEvent()) {
                BoxEvent event = this.nextEvent();
                BoxTypedObject source = event.getSource();
                if (source instanceof BoxItem) {
                    JCRLocalCloudFile local;
                    Node parent;
                    String parentId;
                    String name;
                    String id;
                    String eventType;
                    BoxItem item;
                    block48: {
                        BoxFolder itemParent;
                        item = (BoxItem)source;
                        eventType = event.getEventType();
                        id = item.getId();
                        name = item.getName();
                        String sequenceId = item.getSequenceId();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("> " + eventType + ": " + id + " " + name + " " + sequenceId));
                        }
                        if (eventType.equals("ITEM_TRASH")) {
                            if (JCRLocalBoxDrive.this.hasRemoved(id)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file removal " + id + " " + name));
                                }
                                JCRLocalBoxDrive.this.cleanRemoved(id);
                                continue;
                            }
                            itemParent = item.getParent();
                            if (itemParent != null) {
                                parentId = itemParent.getId();
                                break block48;
                            } else {
                                this.remove(id, null);
                                continue;
                            }
                        }
                        itemParent = item.getParent();
                        if (itemParent != null) {
                            parentId = itemParent.getId();
                        } else {
                            this.postpone(event);
                            continue;
                        }
                    }
                    if ("0".equals(parentId)) {
                        parent = this.rootNode;
                    } else {
                        local = this.applied(parentId);
                        if (local != null) {
                            parent = local.getNode();
                            parent.getParent().getNodes();
                        } else {
                            parent = JCRLocalBoxDrive.this.findNode(parentId);
                            if (parent == null) {
                                if (this.isRemoved(parentId) && eventType.equals("ITEM_TRASH")) continue;
                                this.postpone(event);
                                continue;
                            }
                        }
                    }
                    try {
                        Node sourceNode;
                        if (eventType.equals("ITEM_CREATE") || eventType.equals("ITEM_UPLOAD")) {
                            if (JCRLocalBoxDrive.this.hasUpdated(id)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file creation/modification " + id + " " + name));
                                }
                                JCRLocalBoxDrive.this.cleanUpdated(id);
                                continue;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">> File create/modify " + id + " " + name));
                            }
                            this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                            continue;
                        }
                        if (eventType.equals("ITEM_MOVE") || eventType.equals("ITEM_RENAME")) {
                            if (JCRLocalBoxDrive.this.hasUpdated(id)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file move/rename " + id + " " + name));
                                }
                                JCRLocalBoxDrive.this.cleanUpdated(id);
                                continue;
                            }
                            BoxItem undelete = this.undeleted(id);
                            if (undelete != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File undeleted " + id + " " + name));
                                }
                                this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                                continue;
                            }
                            JCRLocalCloudFile local2 = this.applied(id);
                            sourceNode = local2 != null ? local2.getNode() : JCRLocalBoxDrive.this.findNode(id);
                            if (sourceNode != null) {
                                if (JCRLocalBoxDrive.this.fileAPI.getTitle(sourceNode).equals(name) && JCRLocalBoxDrive.this.fileAPI.getParentId(sourceNode).equals(parentId)) continue;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File move/rename " + id + " " + name));
                                }
                                parent.getNodes();
                                Node destNode = JCRLocalBoxDrive.this.moveFile(id, name, sourceNode, parent);
                                this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, destNode));
                                continue;
                            }
                            this.postpone(event);
                            continue;
                        }
                        if (eventType.equals("ITEM_TRASH")) {
                            Node node = JCRLocalBoxDrive.this.readNode(parent, name, id);
                            if (node != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File removal " + id + " " + name));
                                }
                                String path = node.getPath();
                                node.remove();
                                this.remove(id, path);
                                continue;
                            }
                            this.postpone(event);
                            continue;
                        }
                        if (eventType.equals("ITEM_UNDELETE_VIA_TRASH")) {
                            if (JCRLocalBoxDrive.this.hasUpdated(id)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file untrash " + id + " " + name));
                                }
                                JCRLocalBoxDrive.this.cleanUpdated(id);
                                continue;
                            }
                            Node place = JCRLocalBoxDrive.this.readNode(parent, name, id);
                            if (place == null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> File untrash " + id + " " + name));
                                }
                                this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null));
                                continue;
                            }
                            if (JCRLocalBoxDrive.this.fileAPI.getTitle(place).equals(name) && JCRLocalBoxDrive.this.fileAPI.getParentId(place).equals(parentId)) continue;
                            this.undelete(item);
                            this.postpone(event);
                            continue;
                        }
                        if (eventType.equals("ITEM_COPY")) {
                            if (JCRLocalBoxDrive.this.hasUpdated(id)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(">> Returned file copy " + id + " " + name));
                                }
                                JCRLocalBoxDrive.this.cleanUpdated(id);
                                continue;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">> File copy " + id + " " + name));
                            }
                            if ((local = this.applied(id)) != null) {
                                sourceNode = local.getNode();
                                if (JCRLocalBoxDrive.this.fileAPI.getTitle(sourceNode).equals(name) && JCRLocalBoxDrive.this.fileAPI.getParentId(sourceNode).equals(parentId)) continue;
                                Node destNode = JCRLocalBoxDrive.this.copyNode(sourceNode, parent);
                                this.apply(JCRLocalBoxDrive.this.updateItem(this.api, item, parent, destNode));
                                continue;
                            }
                            local = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                            if (local.isFolder()) {
                                try {
                                    this.fetchChilds(local.getId(), local.getNode());
                                    this.apply(local);
                                }
                                catch (NotFoundException e) {
                                    local.getNode().remove();
                                    this.remove(id, local.getPath());
                                    if (!LOG.isDebugEnabled()) continue;
                                    LOG.debug((Object)("Copied node already removed in cloud - remove it locally. " + e.getMessage()));
                                }
                                continue;
                            }
                            this.apply(local);
                            continue;
                        }
                        LOG.warn((Object)("Skipped unexpected change from Box Event: " + eventType));
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        this.postpone(event);
                        break;
                    }
                }
                LOG.warn((Object)("Skipping non Item in Box events: " + source));
            }
            if (this.hasPostponed()) {
                LOG.warn((Object)"Not all events applied for Box sync. Running full sync.");
                JCRLocalBoxDrive.this.rollback(this.rootNode);
                FullSync fullSync = new FullSync();
                fullSync.execLocal();
                this.changed.clear();
                this.changed.addAll(fullSync.getFiles());
                this.removed.clear();
                this.removed.addAll(fullSync.getRemoved());
                return;
            }
            StringBuilder newHistoryData = new StringBuilder();
            Iterator<String> eriter = this.newHistory.iterator();
            while (true) {
                if (!eriter.hasNext()) {
                    this.rootNode.setProperty("box:streamHistory", newHistoryData.toString());
                    JCRLocalBoxDrive.this.setChangeId(this.events.getNextStreamPosition());
                    return;
                }
                newHistoryData.append(eriter.next());
                if (!eriter.hasNext()) continue;
                newHistoryData.append(';');
            }
        }

        protected BoxFolder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext()) {
                BoxItem item = (BoxItem)items.next();
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (!localItem.isChanged()) continue;
                this.apply(localItem);
                if (!localItem.isFolder()) continue;
                this.fetchChilds(localItem.getId(), localItem.getNode());
            }
            return items.parent;
        }

        protected BoxEvent readEvent() throws CloudDriveException {
            while (this.events.hasNext()) {
                BoxEvent next = (BoxEvent)this.events.next();
                this.newHistory.add(next.getId());
                if (this.history.contains(next.getId())) continue;
                ++this.readCounter;
                return next;
            }
            return null;
        }

        protected boolean hasNextEvent() throws CloudDriveException {
            if (this.nextEvent != null) {
                return true;
            }
            this.nextEvent = this.readEvent();
            if (this.nextEvent != null) {
                return true;
            }
            return this.postponed.size() > 0 && (this.lastPostponed == null || this.prevPostponedNumber > this.postponedNumber);
        }

        protected BoxEvent nextEvent() throws NoSuchElementException, CloudDriveException {
            BoxEvent event = null;
            if (this.nextEvent != null) {
                event = this.nextEvent;
                this.nextEvent = null;
            } else {
                event = this.readEvent();
            }
            if (event != null) {
                return event;
            }
            if (this.postponed.size() > 0) {
                BoxEvent firstPostponed;
                if (this.lastPostponed == null) {
                    this.lastPostponed = this.postponed.getLast();
                    this.postponedNumber = this.readCounter - this.appliedCounter;
                    this.prevPostponedNumber = Integer.MAX_VALUE;
                }
                if ((firstPostponed = this.postponed.poll()) == this.lastPostponed) {
                    this.prevPostponedNumber = this.postponedNumber;
                    this.postponedNumber = this.readCounter - this.appliedCounter;
                }
                return firstPostponed;
            }
            throw new NoSuchElementException("No more events.");
        }

        protected void postpone(BoxEvent event) {
            this.postponed.add(event);
        }

        protected boolean hasPostponed() {
            if (this.postponed.size() > 0 && LOG.isDebugEnabled()) {
                LOG.debug((Object)"Not resolved Box events >>>> ");
                for (BoxEvent e : this.postponed) {
                    BoxTypedObject source = e.getSource();
                    if (!(source instanceof BoxItem)) continue;
                    BoxItem item = (BoxItem)source;
                    LOG.debug((Object)(e.getEventType() + ": " + item.getId() + " " + item.getName() + " " + item.getSequenceId()));
                }
                LOG.debug((Object)"<<<<");
            }
            return this.postponed.size() > 0;
        }

        protected BoxItem undeleted(String itemId) {
            return this.undeleted.get(itemId);
        }

        protected void undelete(BoxItem item) {
            this.undeleted.put(item.getId(), item);
        }

        protected void apply(JCRLocalCloudFile local) {
            if (local.isChanged()) {
                this.applied.put(local.getId(), local);
                this.removed.remove(local.getPath());
                this.removedIds.remove(local.getId());
                this.changed.add(local);
                ++this.appliedCounter;
            }
        }

        protected JCRLocalCloudFile applied(String itemId) {
            return this.applied.get(itemId);
        }

        protected JCRLocalCloudFile remove(String itemId, String itemPath) {
            ++this.appliedCounter;
            if (itemPath != null) {
                this.removed.add(itemPath);
            }
            this.removedIds.add(itemId);
            return this.applied.remove(itemId);
        }

        protected boolean isRemoved(String itemId) {
            return this.removedIds.contains(itemId);
        }
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final BoxAPI api;

        FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalBoxDrive.this);
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            BoxFile file;
            block4: {
                String parentId = this.getParentId(fileNode);
                String title = this.getTitle(fileNode);
                try {
                    file = this.api.createFile(parentId, title, created, content);
                }
                catch (ConflictException e) {
                    BoxFile existing = null;
                    BoxAPI.ItemsIterator files = this.api.getFolderItems(parentId);
                    while (files.hasNext()) {
                        BoxItem item = (BoxItem)files.next();
                        if (!(item instanceof BoxFile) || !title.equals(item.getName())) continue;
                        existing = (BoxFile)item;
                        break;
                    }
                    if (existing == null) {
                        throw e;
                    }
                    file = existing;
                    if (!fileNode.hasNode("jcr:content")) break block4;
                    fileNode.getNode("jcr:content").setProperty("jcr:data", JCRLocalCloudDrive.DUMMY_DATA);
                }
            }
            String id = file.getId();
            String name = file.getName();
            String type = JCRLocalBoxDrive.this.findMimetype(name);
            String link = this.api.getLink((BoxItem)file);
            String embedLink = this.api.getEmbedLink((BoxItem)file);
            String thumbnailLink = this.api.getThumbnailLink((BoxItem)file);
            String createdBy = file.getCreatedBy().getLogin();
            String modifiedBy = file.getModifiedBy().getLogin();
            long size = Math.round(file.getSize());
            JCRLocalBoxDrive.this.initFile(fileNode, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
            JCRLocalBoxDrive.this.initBoxItem(fileNode, (BoxItem)file);
            return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalBoxDrive.this.previewLink(fileNode), thumbnailLink, type, null, modifiedBy, createdBy, created, modified, size, fileNode, true);
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            BoxFolder folder;
            String parentId = this.getParentId(folderNode);
            String title = this.getTitle(folderNode);
            try {
                folder = this.api.createFolder(this.getParentId(folderNode), this.getTitle(folderNode), created);
            }
            catch (ConflictException e) {
                BoxFolder existing = null;
                BoxAPI.ItemsIterator files = this.api.getFolderItems(parentId);
                while (files.hasNext()) {
                    BoxItem item = (BoxItem)files.next();
                    if (!(item instanceof BoxFolder) || !title.equals(item.getName())) continue;
                    existing = (BoxFolder)item;
                    break;
                }
                if (existing == null) {
                    throw e;
                }
                folder = existing;
            }
            String id = folder.getId();
            String name = folder.getName();
            String type = folder.getType();
            String link = this.api.getLink((BoxItem)folder);
            String createdBy = folder.getCreatedBy().getLogin();
            String modifiedBy = folder.getModifiedBy().getLogin();
            JCRLocalBoxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, created);
            JCRLocalBoxDrive.this.initBoxItem(folderNode, (BoxItem)folder);
            return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, created, folderNode, true);
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            BoxFile file = this.api.updateFile(this.getParentId(fileNode), this.getId(fileNode), this.getTitle(fileNode), modified);
            try {
                String id = file.getId();
                String name = file.getName();
                String type = JCRLocalBoxDrive.this.findMimetype(name);
                String link = this.api.getLink((BoxItem)file);
                String embedLink = this.api.getEmbedLink((BoxItem)file);
                String thumbnailLink = this.api.getThumbnailLink((BoxItem)file);
                String createdBy = file.getCreatedBy().getLogin();
                Calendar created = this.api.parseDate(file.getCreatedAt());
                modified = this.api.parseDate(file.getModifiedAt());
                String modifiedBy = file.getModifiedBy().getLogin();
                long size = Math.round(file.getSize());
                JCRLocalBoxDrive.this.initFile(fileNode, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                boolean changed = JCRLocalBoxDrive.this.initBoxItem(fileNode, (BoxItem)file);
                return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalBoxDrive.this.previewLink(fileNode), thumbnailLink, type, null, modifiedBy, createdBy, created, modified, size, fileNode, changed);
            }
            catch (ParseException e) {
                throw new BoxFormatException("Error parsing date of file " + fileNode.getPath(), e);
            }
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            BoxFolder folder = this.api.updateFolder(this.getParentId(folderNode), this.getId(folderNode), this.getTitle(folderNode), modified);
            try {
                String id = folder.getId();
                String name = folder.getName();
                String link = this.api.getLink((BoxItem)folder);
                String type = folder.getType();
                String createdBy = folder.getCreatedBy().getLogin();
                Calendar created = this.api.parseDate(folder.getCreatedAt());
                modified = this.api.parseDate(folder.getModifiedAt());
                String modifiedBy = folder.getModifiedBy().getLogin();
                JCRLocalBoxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
                boolean changed = JCRLocalBoxDrive.this.initBoxItem(folderNode, (BoxItem)folder);
                return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, modified, folderNode, changed);
            }
            catch (ParseException e) {
                throw new BoxFormatException("Error parsing date of folder " + folderNode.getPath(), e);
            }
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            BoxFile file = this.api.updateFileContent(this.getParentId(fileNode), this.getId(fileNode), this.getTitle(fileNode), modified, content);
            try {
                String id = file.getId();
                String name = file.getName();
                String type = JCRLocalBoxDrive.this.findMimetype(name);
                String link = this.api.getLink((BoxItem)file);
                String embedLink = this.api.getEmbedLink((BoxItem)file);
                String thumbnailLink = this.api.getThumbnailLink((BoxItem)file);
                String createdBy = file.getCreatedBy().getLogin();
                Calendar created = this.api.parseDate(file.getCreatedAt());
                modified = this.api.parseDate(file.getModifiedAt());
                String modifiedBy = file.getModifiedBy().getLogin();
                long size = Math.round(file.getSize());
                JCRLocalBoxDrive.this.initFile(fileNode, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                JCRLocalBoxDrive.this.initBoxItem(fileNode, (BoxItem)file);
                return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalBoxDrive.this.previewLink(fileNode), thumbnailLink, type, null, modifiedBy, createdBy, created, modified, size, fileNode, true);
            }
            catch (ParseException e) {
                throw new BoxFormatException("Error parsing date of file " + fileNode.getPath(), e);
            }
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            BoxFile file = this.api.copyFile(this.getId(srcFileNode), this.getParentId(destFileNode), this.getTitle(destFileNode));
            try {
                String id = file.getId();
                String name = file.getName();
                String type = JCRLocalBoxDrive.this.findMimetype(name);
                String link = this.api.getLink((BoxItem)file);
                String embedLink = this.api.getEmbedLink((BoxItem)file);
                String thumbnailLink = this.api.getThumbnailLink((BoxItem)file);
                String createdBy = file.getCreatedBy().getLogin();
                String modifiedBy = file.getModifiedBy().getLogin();
                Calendar created = this.api.parseDate(file.getCreatedAt());
                Calendar modified = this.api.parseDate(file.getModifiedAt());
                long size = Math.round(file.getSize());
                JCRLocalBoxDrive.this.initFile(destFileNode, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                JCRLocalBoxDrive.this.initBoxItem(destFileNode, (BoxItem)file);
                return new JCRLocalCloudFile(destFileNode.getPath(), id, name, link, JCRLocalBoxDrive.this.previewLink(destFileNode), thumbnailLink, type, null, modifiedBy, createdBy, created, modified, size, destFileNode, true);
            }
            catch (ParseException e) {
                throw new BoxFormatException("Error parsing date of file " + destFileNode.getPath(), e);
            }
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            BoxFolder folder = this.api.copyFolder(this.getId(srcFolderNode), this.getParentId(destFolderNode), this.getTitle(destFolderNode));
            try {
                String id = folder.getId();
                String name = folder.getName();
                String type = folder.getType();
                String link = this.api.getLink((BoxItem)folder);
                String createdBy = folder.getCreatedBy().getLogin();
                String modifiedBy = folder.getModifiedBy().getLogin();
                Calendar created = this.api.parseDate(folder.getCreatedAt());
                Calendar modified = this.api.parseDate(folder.getModifiedAt());
                JCRLocalBoxDrive.this.initFolder(destFolderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
                JCRLocalBoxDrive.this.initBoxItem(destFolderNode, (BoxItem)folder);
                return new JCRLocalCloudFile(destFolderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, modified, destFolderNode, true);
            }
            catch (ParseException e) {
                throw new BoxFormatException("Error parsing date of folder " + destFolderNode.getPath(), e);
            }
        }

        public boolean removeFile(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteFile(id);
            return true;
        }

        public boolean removeFolder(String id) throws CloudDriveException, RepositoryException {
            this.api.deleteFolder(id);
            return true;
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            BoxFile trashed = this.api.trashFile(id);
            return trashed.getItemStatus().equals("trashed");
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            BoxFolder trashed = this.api.trashFolder(id);
            return trashed.getItemStatus().equals("trashed");
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            String name;
            String id = JCRLocalBoxDrive.this.fileAPI.getId(fileNode);
            BoxFile file = this.api.untrashFile(id, name = JCRLocalBoxDrive.this.fileAPI.getTitle(fileNode));
            if (!file.getItemStatus().equals("trashed")) {
                try {
                    id = file.getId();
                    name = file.getName();
                    String type = JCRLocalBoxDrive.this.findMimetype(name);
                    String link = this.api.getLink((BoxItem)file);
                    String embedLink = this.api.getEmbedLink((BoxItem)file);
                    String thumbnailLink = this.api.getThumbnailLink((BoxItem)file);
                    String createdBy = file.getCreatedBy().getLogin();
                    Calendar created = this.api.parseDate(file.getCreatedAt());
                    Calendar modified = this.api.parseDate(file.getModifiedAt());
                    String modifiedBy = file.getModifiedBy().getLogin();
                    long size = Math.round(file.getSize());
                    JCRLocalBoxDrive.this.initFile(fileNode, id, name, type, link, embedLink, thumbnailLink, createdBy, modifiedBy, created, modified, size);
                    JCRLocalBoxDrive.this.initBoxItem(fileNode, (BoxItem)file);
                    return new JCRLocalCloudFile(fileNode.getPath(), id, name, link, JCRLocalBoxDrive.this.previewLink(fileNode), thumbnailLink, type, null, modifiedBy, createdBy, created, modified, size, fileNode, true);
                }
                catch (ParseException e) {
                    throw new BoxFormatException("Error parsing date of file " + fileNode.getPath(), e);
                }
            }
            throw new ConstraintException("File cannot be restored from Trash " + name + " (" + id + ")");
        }

        public CloudFile untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            String name;
            String id = JCRLocalBoxDrive.this.fileAPI.getId(folderNode);
            BoxFolder folder = this.api.untrashFolder(id, name = JCRLocalBoxDrive.this.fileAPI.getTitle(folderNode));
            if (!folder.getItemStatus().equals("trashed")) {
                try {
                    id = folder.getId();
                    name = folder.getName();
                    String link = this.api.getLink((BoxItem)folder);
                    String type = folder.getType();
                    String createdBy = folder.getCreatedBy().getLogin();
                    Calendar created = this.api.parseDate(folder.getCreatedAt());
                    Calendar modified = this.api.parseDate(folder.getModifiedAt());
                    String modifiedBy = folder.getModifiedBy().getLogin();
                    JCRLocalBoxDrive.this.initFolder(folderNode, id, name, type, link, createdBy, modifiedBy, created, modified);
                    JCRLocalBoxDrive.this.initBoxItem(folderNode, (BoxItem)folder);
                    return new JCRLocalCloudFile(folderNode.getPath(), id, name, link, type, modifiedBy, createdBy, created, modified, folderNode, true);
                }
                catch (ParseException e) {
                    throw new BoxFormatException("Error parsing date of folder " + folderNode.getPath(), e);
                }
            }
            throw new ConstraintException("Folder cannot be restored from Trash " + name + " (" + id + ")");
        }

        public boolean isTrashSupported() {
            return true;
        }

        public CloudFile restore(String id, String path) throws NotFoundException, CloudDriveException, RepositoryException {
            throw new SyncNotSupportedException("Restore not supported");
        }
    }

    protected class FullSync
    extends JCRLocalCloudDrive.SyncCommand {
        protected final BoxAPI api;

        protected FullSync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalBoxDrive.this);
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        protected void syncFiles() throws RepositoryException, CloudDriveException {
            this.readLocalNodes();
            BoxAPI.EventsIterator eventsInit = this.api.getEvents(-1L);
            BoxFolder boxRoot = this.syncChilds("0", this.rootNode);
            JCRLocalBoxDrive.this.initBoxItem(this.rootNode, (BoxItem)boxRoot);
            JCRLocalBoxDrive.this.setChangeId(eventsInit.getNextStreamPosition());
            this.rootNode.setProperty("box:streamHistory", "");
            this.nodes.remove("0");
            Iterator niter = this.nodes.values().iterator();
            while (niter.hasNext() && !Thread.currentThread().isInterrupted()) {
                List nls = (List)niter.next();
                niter.remove();
                for (Node n : nls) {
                    String npath = n.getPath();
                    if (!JCRLocalBoxDrive.this.notInRange(npath, this.removed)) continue;
                    this.removed.add(npath);
                    n.remove();
                }
            }
        }

        protected BoxFolder syncChilds(String folderId, Node parent) throws RepositoryException, CloudDriveException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(folderId);
            this.iterators.add(items);
            while (items.hasNext() && !Thread.currentThread().isInterrupted()) {
                List existing;
                BoxItem item = (BoxItem)items.next();
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.changed.add(localItem);
                }
                if ((existing = (List)this.nodes.remove(item.getId())) != null) {
                    String path = localItem.getPath();
                    Iterator eiter = existing.iterator();
                    while (eiter.hasNext()) {
                        Node enode = (Node)eiter.next();
                        String epath = enode.getPath();
                        if (epath.equals(path) || !JCRLocalBoxDrive.this.notInRange(epath, this.removed)) continue;
                        this.removed.add(epath);
                        enode.remove();
                        eiter.remove();
                    }
                }
                if (!localItem.isFolder()) continue;
                this.syncChilds(localItem.getId(), localItem.getNode());
            }
            return items.parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execLocal() throws CloudDriveException, RepositoryException {
            JCRLocalBoxDrive.this.commandEnv.configure((CloudDrive.Command)this);
            super.exec();
            JCRLocalBoxDrive.this.fileHistory.clear();
            try {
                JCRLocalBoxDrive.this.jcrListener.disable();
                String empty = "".intern();
                this.rootNode.setProperty("ecd:localHistory", empty);
                this.rootNode.setProperty("ecd:localChanges", empty);
                this.rootNode.save();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error cleaning local history in " + JCRLocalBoxDrive.this.title()), e);
            }
            finally {
                JCRLocalBoxDrive.this.jcrListener.enable();
            }
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand {
        protected final BoxAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalBoxDrive.this);
            this.api = JCRLocalBoxDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            BoxAPI.EventsIterator eventsInit = this.api.getEvents(-1L);
            BoxFolder boxRoot = this.fetchChilds("0", this.rootNode);
            JCRLocalBoxDrive.this.initBoxItem(this.rootNode, (BoxItem)boxRoot);
            this.rootNode.setProperty("ecd:url", this.api.getLink((BoxItem)boxRoot));
            JCRLocalBoxDrive.this.setChangeId(eventsInit.getNextStreamPosition());
            this.rootNode.setProperty("box:streamHistory", "");
        }

        protected BoxFolder fetchChilds(String fileId, Node parent) throws CloudDriveException, RepositoryException {
            BoxAPI.ItemsIterator items = this.api.getFolderItems(fileId);
            this.iterators.add(items);
            while (items.hasNext()) {
                BoxItem item = (BoxItem)items.next();
                JCRLocalCloudFile localItem = JCRLocalBoxDrive.this.updateItem(this.api, item, parent, null);
                if (localItem.isChanged()) {
                    this.changed.add(localItem);
                    if (!localItem.isFolder()) continue;
                    this.fetchChilds(localItem.getId(), localItem.getNode());
                    continue;
                }
                throw new BoxFormatException("Fetched item was not added to local drive storage");
            }
            return items.parent;
        }
    }
}

