/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.chemistry.opencmis.client.SessionParameterMap;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.CmisBindingFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.ConstraintException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.UnauthorizedException;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.CMISInvalidArgumentException;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.cmis.WrongCMISProviderException;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CMISAPI {
    protected static final Log LOG = ExoLogger.getLogger(CMISAPI.class);
    public static final String NO_STATE = "__no_state_set__";
    public static final int OBJECT_PAGE_SIZE = 1024;
    public static final int FOLDER_PAGE_SIZE = 10240;
    public static final String TOKEN_DATATIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String EMPTY_TOKEN = "".intern();
    protected static final Set<String> FILE_PROPERTY_SET = new LinkedHashSet<String>();
    protected static final Set<String> FOLDER_PROPERTY_SET;
    @Deprecated
    private static final Set<String> VERSION_PROPERTY_SET;
    private final Lock lock = new ReentrantLock();
    protected final AtomicReference<Session> session = new AtomicReference();
    protected final ChangeToken emptyToken = new ChangeToken(EMPTY_TOKEN);
    protected Map<String, String> parameters;
    protected String repositoryId;
    protected String repositoryName;
    protected String productName;
    protected String productVersion;
    protected String vendorName;
    protected String enterpriseId;
    protected String enterpriseName;
    protected String customDomain;
    protected OperationContext fileContext;
    protected OperationContext folderContext;

    protected CMISAPI(String serviceURL, String user, String password) throws CMISException, CloudDriveException {
        SessionParameterMap parameters = new SessionParameterMap();
        parameters.setUsernameTokenAuthentication(user, password, true);
        parameters.setAtomPubBindingUrl(serviceURL);
        parameters.setCompression(true);
        parameters.setClientCompression(false);
        parameters.setCookies(true);
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUser(Map<String, String> parameters) {
        try {
            this.lock.lock();
            this.parameters = new HashMap<String, String>(parameters);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getParamaters() {
        try {
            this.lock.lock();
            Map<String, String> map = Collections.unmodifiableMap(this.parameters);
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUser() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.user");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPassword() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.password");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceURL() {
        try {
            this.lock.lock();
            String string = this.parameters.get("org.apache.chemistry.opencmis.binding.atompub.url");
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void initRepository(String repositoryId) throws CMISException, RefreshAccessException {
        this.repositoryId = repositoryId;
        RepositoryInfo info = this.getRepositoryInfo();
        this.repositoryName = info.getName();
        this.productName = info.getProductName();
        this.productVersion = info.getProductVersion();
        this.vendorName = info.getVendorName();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryName() {
        return this.repositoryName != null ? this.repositoryName : this.repositoryId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getUserTitle() {
        return this.getUser();
    }

    protected List<Repository> getRepositories() throws CMISException, RefreshAccessException {
        return Collections.unmodifiableList(this.repositories());
    }

    protected Folder getRootFolder() throws CMISException, RefreshAccessException, UnauthorizedException {
        try {
            return this.session().getRootFolder();
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error getting root folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error getting root folder: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for getting root folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for getting root folder", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error getting root folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error getting root folder: " + e.getMessage(), e);
        }
    }

    protected CmisObject readObject(String id, Session session, OperationContext context) {
        return session.getObject(id, context);
    }

    protected CmisObject getObject(String objectId) throws CMISException, NotFoundException, CloudDriveAccessException, UnauthorizedException {
        Session session = this.session();
        try {
            CmisObject object = this.readObject(objectId, session, this.fileContext);
            return object;
        }
        catch (CmisObjectNotFoundException e) {
            Document doc = this.readDocumentVersionOrPWC(objectId);
            if (doc != null) {
                return doc;
            }
            throw new NotFoundException("Object not found: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error reading object: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            Document doc = this.readDocumentVersionOrPWC(objectId);
            if (doc != null) {
                return doc;
            }
            throw new CMISInvalidArgumentException("Error reading object: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for object reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for reading object", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error reading object: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading object: " + e.getMessage(), e);
        }
    }

    protected Document readDocumentVersionOrPWC(String id) throws CloudDriveAccessException, UnauthorizedException {
        block4: {
            try {
                return this.getLatestDocumentVersionOrPWC(id);
            }
            catch (CMISException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error reading document version " + id), (Throwable)((Object)e));
                }
            }
            catch (NotFoundException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)("Error reading document version" + id), (Throwable)e);
            }
        }
        return null;
    }

    protected Document getLatestDocumentVersionOrPWC(String id) throws CMISException, NotFoundException, CloudDriveAccessException, UnauthorizedException {
        Session session = this.session();
        try {
            Document document;
            block12: {
                String pwcid;
                document = session.getLatestDocumentVersion(id, this.fileContext);
                if (document.isVersionSeriesCheckedOut().booleanValue() && this.getUserTitle().equals(document.getVersionSeriesCheckedOutBy()) && (pwcid = document.getVersionSeriesCheckedOutId()) != null) {
                    try {
                        return (Document)this.readObject(pwcid, session, this.fileContext);
                    }
                    catch (CmisBaseException e) {
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug((Object)("Cannot read object of version " + pwcid + " " + document.getName() + ": " + e.getMessage() + ". Will use version document " + document.getId()));
                    }
                }
            }
            return document;
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Document not found: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error reading document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error reading document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for reading document", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error reading document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading document: " + e.getMessage(), e);
        }
    }

    protected List<Document> getAllVersion(Document document) throws CMISException, NotFoundException, CloudDriveAccessException, UnauthorizedException {
        try {
            return document.getAllVersions(this.fileContext);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Document not found: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error reading document versions: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error reading document versions: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document versions content reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document versions reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for reading document versions", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error reading document versions: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading document versions: " + e.getMessage(), e);
        }
    }

    protected Collection<Folder> getParents(CmisObject obj) throws CMISException, CloudDriveAccessException, UnauthorizedException {
        try {
            if (this.isFileable(obj)) {
                return ((FileableCmisObject)obj).getParents(this.folderContext);
            }
            return Collections.emptyList();
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error reading object parents: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error reading object parents (not a folder or root folder): " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for object parents reading: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for reading object parents", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error reading object parents: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading object parents: " + e.getMessage(), e);
        }
    }

    protected ChildrenIterator getFolderItems(String folderId) throws CloudDriveException {
        return new ChildrenIterator(folderId);
    }

    protected ChangesIterator getChanges(ChangeToken changeToken) throws CMISException, CloudDriveAccessException {
        return new ChangesIterator(changeToken);
    }

    protected String getLink(CmisObject file) throws CMISException, RefreshAccessException {
        LinkAccess link = (LinkAccess)this.session().getBinding().getObjectService();
        String linkContent = link.loadContentLink(this.repositoryId, file.getId());
        if (linkContent != null) {
            return linkContent;
        }
        return link.loadLink(this.repositoryId, file.getId(), "self", "application/atom+xml;type=entry");
    }

    protected String getLink(Folder file) throws CMISException, RefreshAccessException {
        LinkAccess link = (LinkAccess)this.session().getBinding().getObjectService();
        String linkSelfEntry = link.loadLink(this.repositoryId, file.getId(), "self", "application/atom+xml;type=entry");
        return linkSelfEntry;
    }

    protected Document createDocument(String parentId, String name, String mimeType, InputStream data) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            CmisRuntimeException unexpected;
            CmisObject obj = null;
            int i = 0;
            do {
                ++i;
                unexpected = null;
                try {
                    obj = this.readObject(parentId, session, this.folderContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
                }
                catch (CmisRuntimeException e) {
                    if (e.getMessage() != null || e.getErrorContent() != null) continue;
                    unexpected = e;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        LOG.warn((Object)("Error sleeping in createDocument " + e.getMessage()));
                    }
                }
            } while (obj == null && i <= 3);
            if (obj == null) {
                throw new CMISException("Cannot read parent object " + parentId + " of " + name, unexpected);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                ObjectType docType = session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
                VersioningState vstate = this.isVersionable(docType) ? VersioningState.MAJOR : VersioningState.NONE;
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", BaseTypeId.CMIS_DOCUMENT.value());
                properties.put("cmis:name", name);
                ContentStream contentStream = session.getObjectFactory().createContentStream(name, -1L, mimeType, data);
                return parent.createDocument(properties, contentStream, vstate, null, null, null, this.fileContext);
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Document update conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error creating document: " + (e.getMessage() != null ? e.getMessage() : "object not found"), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to create document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to create document '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content upload: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document creation: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for creating document " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error creating document: " + e.getMessage(), e);
        }
    }

    protected Folder createFolder(String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.folderContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
                properties.put("cmis:name", name);
                Folder parent = (Folder)obj;
                return parent.createFolder(properties, null, null, null, this.folderContext);
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error creating folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to create folder with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to create folder '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for folder creation: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for creating folder " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error creating folder: " + e.getMessage(), e);
        }
    }

    protected void deleteDocument(String id) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        String name = "";
        try {
            CmisObject obj = this.readObject(id, session, this.fileContext);
            name = obj.getName();
            obj.delete(true);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Document not found: " + id, (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Document removal conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to delete document '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document removal: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for deleting document", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error deleting document: " + e.getMessage(), e);
        }
    }

    protected void deleteFolder(String id) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        String name = "";
        try {
            CmisObject obj = this.readObject(id, session, this.fileContext);
            name = obj.getName();
            if (!this.isFolder(obj)) {
                throw new CMISException("Not a folder: " + id + ", " + name);
            }
            Folder folder = (Folder)obj;
            folder.deleteTree(true, UnfileObject.DELETE, false);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error deleting folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Folder removal conflict for '" + name + "'", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to delete folder '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for folder removal: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for deleting folder", (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error deleting folder: " + e.getMessage(), e);
        }
    }

    protected Document updateContent(String id, String name, InputStream data, String mimeType, JCRLocalCMISDrive.LocalFile local) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            Object obj;
            block24: {
                try {
                    obj = this.readObject(id, session, this.fileContext);
                }
                catch (CmisObjectNotFoundException e) {
                    String vid = local.findVersionSeriesId();
                    obj = vid != null ? this.readDocumentVersionOrPWC(vid) : null;
                    if (obj != null) break block24;
                    throw new NotFoundException("Object not found: " + id, (Throwable)e);
                }
            }
            if (this.isDocument((CmisObject)obj)) {
                Document document = (Document)obj;
                boolean checkin = false;
                Boolean isCO = document.isVersionSeriesCheckedOut();
                Boolean isPWC = document.isPrivateWorkingCopy();
                if (!(isCO != null && isCO.booleanValue() || isPWC != null && isPWC.booleanValue())) {
                    id = document.checkOut().getId();
                    document = (Document)this.readObject(id, session, this.fileContext);
                    obj = document;
                    checkin = this.shouldCheckinRename(document);
                }
                ContentStream contentStream = session.getObjectFactory().createContentStream(name, -1L, mimeType, data);
                if (checkin) {
                    String message;
                    if (!document.getName().equals(name)) {
                        document = (Document)this.rename(name, (CmisObject)obj, session);
                        message = "Content updated and renamed to " + name;
                    } else {
                        message = "Content updated";
                    }
                    id = document.checkIn(true, null, contentStream, message + " by " + this.getUserTitle()).getId();
                    try {
                        document = (Document)this.readObject(id, session, this.fileContext);
                    }
                    catch (CmisObjectNotFoundException e) {
                        throw new NotFoundException("Checked-in object not found: " + id + " " + name, (Throwable)e);
                    }
                } else {
                    Document updatedDocument;
                    if (!document.getName().equals(name)) {
                        document = (Document)this.rename(name, (CmisObject)obj, session);
                    }
                    document = (updatedDocument = document.setContentStream(contentStream, true)) != null ? updatedDocument : (Document)this.readObject(document.getId(), session, this.fileContext);
                }
                return document;
            }
            throw new CMISException("Object not a document: " + id + ", " + obj.getName());
        }
        catch (CmisContentAlreadyExistsException e) {
            throw new ConflictException("Document content already exists for '" + name + "' and overwrite not requested", (Throwable)e);
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Conflict of document updating for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error updating document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to update document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to update document '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error updating document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error updating document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content update: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document updating: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized to update document " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error updating document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error updating document: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CmisObject updateObject(String parentId, String id, String name, JCRLocalCMISDrive.LocalFile local) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            FileableCmisObject moved;
            Folder srcParent;
            CmisObject cmisObject;
            void var7_15;
            void var7_10;
            block31: {
                try {
                    CmisObject cmisObject2 = this.readObject(id, session, this.fileContext);
                }
                catch (CmisObjectNotFoundException e) {
                    void var7_9;
                    String vid = local.findVersionSeriesId();
                    if (vid != null) {
                        Document document = this.readDocumentVersionOrPWC(vid);
                    } else {
                        Object var7_8 = null;
                    }
                    if (var7_9 != null) break block31;
                    throw new NotFoundException("Object not found: " + id, (Throwable)e);
                }
            }
            if (!var7_10.getName().equals(name)) {
                void var7_12;
                CmisObject result;
                boolean checkin = false;
                Document document = null;
                if (this.isDocument((CmisObject)var7_10)) {
                    document = (Document)var7_10;
                    Boolean isCO = document.isVersionSeriesCheckedOut();
                    Boolean isPWC = document.isPrivateWorkingCopy();
                    if (!(isCO != null && isCO.booleanValue() || isPWC != null && isPWC.booleanValue())) {
                        id = document.checkOut().getId();
                        Document document2 = document = (Document)this.readObject(id, session, this.fileContext);
                        checkin = this.shouldCheckinRename(document);
                    }
                }
                CmisObject cmisObject3 = result = this.rename(name, (CmisObject)var7_12, session);
                if (checkin) {
                    id = document.checkIn(true, null, null, "Renamed to " + name + " by " + this.getUserTitle()).getId();
                    try {
                        CmisObject cmisObject4 = result = this.readObject(id, session, this.fileContext);
                    }
                    catch (CmisObjectNotFoundException e) {
                        throw new NotFoundException("Checked-in object not found: " + id + " " + name, (Throwable)e);
                    }
                }
            }
            if (!this.isFileable((CmisObject)var7_15)) throw new CMISException("Object not a document: " + id + ", " + var7_15.getName());
            FileableCmisObject fileable = (FileableCmisObject)var7_15;
            List parents = fileable.getParents(this.folderContext);
            boolean move = parents.size() > 0;
            HashSet<String> parentIds = new HashSet<String>();
            for (Folder p : parents) {
                String pid = p.getId();
                parentIds.add(pid);
                if (!pid.equals(parentId)) continue;
                move = false;
                break;
            }
            if (!move) {
                return var7_15;
            }
            try {
                cmisObject = this.readObject(parentId, session, this.fileContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (!this.isFolder(cmisObject)) throw new CMISException("Parent not a folder: " + parentId + ", " + cmisObject.getName());
            Folder parent = (Folder)cmisObject;
            if (parents.size() > 1) {
                CmisObject cmisObject5;
                String rpid = local.findRemoteParent(parentIds);
                if (rpid == null) {
                    if (session.getRepositoryInfo().getCapabilities().isMultifilingSupported() == false) throw new CMISException("Cannot move document without source folder and with disabled multi-filing: " + id + ", " + name);
                    fileable.addToFolder((ObjectId)parent, true);
                    return fileable;
                }
                try {
                    cmisObject5 = this.readObject(rpid, session, this.fileContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source parent not found: " + rpid, (Throwable)e);
                }
                if (!this.isFolder(cmisObject5)) throw new CMISException("Source parent not a folder: " + rpid + ", " + cmisObject5.getName());
                srcParent = (Folder)cmisObject5;
            } else {
                srcParent = (Folder)parents.get(0);
            }
            if ((moved = fileable.move((ObjectId)srcParent, (ObjectId)parent, this.fileContext)) != null) {
                return moved;
            }
            fileable.refresh();
            return fileable;
        }
        catch (CmisUpdateConflictException e) {
            throw new ConflictException("Conflict of object updating for '" + name + "'", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error updating object: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to update object with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to update object '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for object updating: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized to update object " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error updating object: " + e.getMessage(), e);
        }
    }

    protected CmisObject rename(String newName, CmisObject obj, Session session) {
        ObjectId objId = obj.rename(newName, true);
        if (objId != null && objId instanceof CmisObject) {
            obj = (CmisObject)objId;
        } else {
            obj.refresh();
        }
        return obj;
    }

    protected Document copyDocument(String id, String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.fileContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                try {
                    obj = this.readObject(id, session, this.fileContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + parentId, (Throwable)e);
                }
                if (this.isDocument(obj)) {
                    return this.copyDocument((Document)obj, parent, name);
                }
                throw new CMISException("Source not a document: " + id + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected Document copyDocument(Document source, Folder parent, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        try {
            Session session = this.session();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("cmis:baseTypeId", source.getBaseType().getId());
            properties.put("cmis:objectTypeId", source.getType().getId());
            properties.put("cmis:name", name);
            ObjectType docType = session.getTypeDefinition(source.getBaseType().getId());
            VersioningState vstate = this.isVersionable(docType) ? VersioningState.MAJOR : VersioningState.NONE;
            try {
                return parent.createDocumentFromSource((ObjectId)source, properties, vstate, null, null, null, this.fileContext);
            }
            catch (CmisNotSupportedException e) {
                LOG.warn((Object)("Cannot copy document " + source.getName() + " (" + source.getId() + ") to " + parent.getName() + "/" + name + ". Will try use actual content copying. " + e.getMessage()));
                ContentStream sourceContent = source.getContentStream();
                ContentStream destContent = session.getObjectFactory().createContentStream(name, sourceContent.getLength(), sourceContent.getMimeType(), sourceContent.getStream());
                for (Property p : source.getProperties()) {
                    if (properties.containsKey(p.getId())) continue;
                    if (p.isMultiValued()) {
                        properties.put(p.getId(), p.getValues());
                        continue;
                    }
                    properties.put(p.getId(), p.getValue());
                }
                return parent.createDocument(properties, destContent, vstate, null, null, null, this.fileContext);
            }
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error copying document: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to copy document with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to copy document '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for document content copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for document copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for copying document " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying document: " + e.getMessage(), e);
        }
    }

    protected Folder copyFolder(String id, String parentId, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        Session session = this.session();
        try {
            CmisObject obj;
            try {
                obj = this.readObject(parentId, session, this.fileContext);
            }
            catch (CmisObjectNotFoundException e) {
                throw new NotFoundException("Parent not found: " + parentId, (Throwable)e);
            }
            if (this.isFolder(obj)) {
                Folder parent = (Folder)obj;
                try {
                    obj = this.readObject(id, session, this.fileContext);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new NotFoundException("Source not found: " + parentId, (Throwable)e);
                }
                if (this.isFolder(obj)) {
                    Folder source = (Folder)obj;
                    return this.copyFolder(source, parent, name);
                }
                throw new CMISException("Source not a folder: " + id + ", " + obj.getName());
            }
            throw new CMISException("Parent not a folder: " + parentId + ", " + obj.getName());
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying folder: " + e.getMessage(), e);
        }
    }

    protected Folder copyFolder(Folder source, Folder parent, String name) throws CMISException, NotFoundException, ConflictException, CloudDriveAccessException, ConstraintException, UnauthorizedException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put("cmis:name", source.getName());
            properties.put("cmis:objectTypeId", source.getBaseTypeId().value());
            Folder copyFolder = parent.createFolder(properties, null, null, null, this.folderContext);
            for (CmisObject child : source.getChildren()) {
                if (this.isDocument(child)) {
                    this.copyDocument((Document)child, parent, child.getName());
                    continue;
                }
                if (!(child instanceof Folder)) continue;
                this.copyFolder((Folder)child, parent, child.getName());
            }
            return copyFolder;
        }
        catch (CmisObjectNotFoundException e) {
            throw new NotFoundException("Error copying folder: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisNameConstraintViolationException e) {
            throw new ConflictException("Unable to copy folder with name '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConstraintException e) {
            throw new ConstraintException("Unable to copy folder '" + name + "' due to repository constraints", (Throwable)e);
        }
        catch (CmisConnectionException e) {
            throw new CMISException("Error copying folder: " + e.getMessage(), e);
        }
        catch (CmisInvalidArgumentException e) {
            throw new CMISInvalidArgumentException("Error copying folder: " + e.getMessage(), e);
        }
        catch (CmisStreamNotSupportedException e) {
            throw new RefreshAccessException("Permission denied for folder content copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for folder copying: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisUnauthorizedException e) {
            throw new UnauthorizedException("Unauthorized for copying folder " + name, (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error copying folder: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error copying folder: " + e.getMessage(), e);
        }
    }

    protected RepositoryInfo getRepositoryInfo() throws CMISException, RefreshAccessException {
        try {
            return this.session(true).getRepositoryInfo();
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error getting repository info: " + e.getMessage(), e);
        }
    }

    protected boolean isFolder(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_FOLDER);
    }

    protected boolean isDocument(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT);
    }

    protected boolean isRelationship(CmisObject object) {
        return object.getBaseTypeId().equals((Object)BaseTypeId.CMIS_RELATIONSHIP);
    }

    protected boolean isFileable(CmisObject object) {
        return object instanceof FileableCmisObject;
    }

    protected List<Repository> repositories() throws CMISException, RefreshAccessException {
        try {
            this.lock.lock();
            SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
            List list = sessionFactory.getRepositories(this.parameters);
            return list;
        }
        catch (CmisConnectionException e) {
            throw new CMISException("CMIS server is unreachable", e);
        }
        catch (CmisUnauthorizedException e) {
            throw new RefreshAccessException("CMIS user rejected", (Throwable)e);
        }
        catch (CmisObjectNotFoundException e) {
            throw new WrongCMISProviderException("Error reading repositories list: " + e.getMessage(), e);
        }
        catch (CmisPermissionDeniedException e) {
            throw new RefreshAccessException("Permission denied for reading repositories list: " + e.getMessage(), (Throwable)e);
        }
        catch (CmisRuntimeException e) {
            throw new CMISException("Runtime error when reading CMIS repositories list", e);
        }
        catch (CmisBaseException e) {
            throw new CMISException("Error reading CMIS repositories list", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected CmisBinding binding() throws CMISException {
        CmisBindingFactory factory = CmisBindingFactory.newInstance();
        HashMap<String, String> sessionParameters = new HashMap<String, String>(this.parameters);
        if (this.repositoryId != null) {
            sessionParameters.put("org.apache.chemistry.opencmis.session.repository.id", this.repositoryId);
        }
        return factory.createCmisAtomPubBinding(this.parameters);
    }

    protected Session session() throws CMISException, RefreshAccessException {
        return this.session(false);
    }

    protected Session session(boolean forceNew) throws CMISException, RefreshAccessException {
        Session session = this.session.get();
        if (session != null && !forceNew) {
            return session;
        }
        for (Repository r : this.repositories()) {
            PropertyDefinition propDef;
            if (!r.getId().equals(this.repositoryId)) continue;
            session = r.createSession();
            OperationContext context = session.createOperationContext();
            context.setCacheEnabled(false);
            session.setDefaultContext(context);
            ObjectType type = session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            StringBuilder filter = new StringBuilder();
            for (String propId : FILE_PROPERTY_SET) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(propDef.getQueryName());
            }
            type = session.getTypeDefinition(BaseTypeId.CMIS_FOLDER.value());
            for (String propId : FILE_PROPERTY_SET) {
                String qname;
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null || filter.indexOf(qname = propDef.getQueryName()) >= 0) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(qname);
            }
            boolean includeAcls = !r.getCapabilities().getAclCapability().equals((Object)CapabilityAcl.NONE);
            Context fileContext = new Context(filter.toString(), includeAcls, true, true, IncludeRelationships.BOTH, "cmis:none", null, 1024);
            filter = new StringBuilder();
            for (String propId : FOLDER_PROPERTY_SET) {
                PropertyDefinition propDef2 = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef2 == null) continue;
                if (filter.length() > 0) {
                    filter.append(',');
                }
                filter.append(propDef2.getQueryName());
            }
            Context folderContext = new Context(filter.toString(), false, false, false, IncludeRelationships.NONE, "cmis:none", null, 10240);
            this.session.set(session);
            this.fileContext = fileContext;
            this.folderContext = folderContext;
            return session;
        }
        throw new CMISException("CMIS repository not found: " + this.repositoryId);
    }

    protected ChangeToken readToken(ChangeEvent event) throws CMISException {
        Object obj;
        List tl = (List)event.getProperties().get("ChangeToken");
        if (tl != null && tl.size() > 0 && (obj = tl.get(0)) != null && obj instanceof String) {
            return this.readToken((String)obj);
        }
        GregorianCalendar time = event.getChangeTime();
        if (time != null) {
            return new TimeChangeToken(time);
        }
        throw new CMISException("ChangeToken property not found, change time is null for " + event.getObjectId() + " " + event.getChangeType());
    }

    protected ChangeToken readToken(String tokenString) throws CMISException {
        return new ChangeToken(tokenString);
    }

    protected ChangeToken emptyToken() {
        return this.emptyToken;
    }

    protected boolean isVersionable(ObjectType type) {
        return type instanceof DocumentType ? ((DocumentType)type).isVersionable() : false;
    }

    protected boolean isSyncableChange(ChangeEvent change) throws RefreshAccessException, CMISException {
        boolean res = true;
        List objTypeIdList = (List)change.getProperties().get("cmis:objectTypeId");
        if (objTypeIdList != null) {
            res = false;
            for (Object tid : objTypeIdList) {
                if (!(tid instanceof String)) continue;
                try {
                    BaseTypeId btid = this.session().getTypeDefinition((String)tid, true).getBaseTypeId();
                    if (btid.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
                        res = true;
                        continue;
                    }
                    if (!btid.equals((Object)BaseTypeId.CMIS_FOLDER)) continue;
                    res = true;
                }
                catch (CmisRuntimeException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
                catch (CmisObjectNotFoundException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
                catch (CmisBaseException e) {
                    throw new CMISException("Error reading object type (" + tid + "): " + e.getMessage(), e);
                }
            }
        }
        return res;
    }

    protected boolean shouldCheckinRename(Document doc) {
        return true;
    }

    public static String formatTokenTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(TOKEN_DATATIME_FORMAT);
        return format.format(date);
    }

    static {
        FILE_PROPERTY_SET.add("cmis:objectId");
        FILE_PROPERTY_SET.add("cmis:parentId");
        FILE_PROPERTY_SET.add("cmis:baseTypeId");
        FILE_PROPERTY_SET.add("cmis:objectTypeId");
        FILE_PROPERTY_SET.add("cmis:name");
        FILE_PROPERTY_SET.add("cmis:isImmutable");
        FILE_PROPERTY_SET.add("cmis:contentStreamMimeType");
        FILE_PROPERTY_SET.add("cmis:contentStreamLength");
        FILE_PROPERTY_SET.add("cmis:contentStreamFileName");
        FILE_PROPERTY_SET.add("cmis:createdBy");
        FILE_PROPERTY_SET.add("cmis:creationDate");
        FILE_PROPERTY_SET.add("cmis:lastModifiedBy");
        FILE_PROPERTY_SET.add("cmis:lastModificationDate");
        FILE_PROPERTY_SET.add("cmis:changeToken");
        FILE_PROPERTY_SET.add("cmis:isLatestVersion");
        FILE_PROPERTY_SET.add("cmis:isMajorVersion");
        FILE_PROPERTY_SET.add("cmis:isLatestMajorVersion");
        FILE_PROPERTY_SET.add("cmis:isVersionSeriesCheckedOut");
        FILE_PROPERTY_SET.add("cmis:versionSeriesId");
        FILE_PROPERTY_SET.add("cmis:versionSeriesCheckedOutId");
        FILE_PROPERTY_SET.add("cmis:versionSeriesCheckedOutBy");
        FILE_PROPERTY_SET.add("cmis:versionLabel");
        FILE_PROPERTY_SET.add("cmis:checkinComment");
        FOLDER_PROPERTY_SET = new LinkedHashSet<String>();
        FOLDER_PROPERTY_SET.add("cmis:objectId");
        FOLDER_PROPERTY_SET.add("cmis:parentId");
        FOLDER_PROPERTY_SET.add("cmis:baseTypeId");
        FOLDER_PROPERTY_SET.add("cmis:objectTypeId");
        FOLDER_PROPERTY_SET.add("cmis:name");
        FOLDER_PROPERTY_SET.add("cmis:isImmutable");
        FOLDER_PROPERTY_SET.add("cmis:createdBy");
        FOLDER_PROPERTY_SET.add("cmis:creationDate");
        FOLDER_PROPERTY_SET.add("cmis:lastModifiedBy");
        FOLDER_PROPERTY_SET.add("cmis:lastModificationDate");
        FOLDER_PROPERTY_SET.add("cmis:changeToken");
        VERSION_PROPERTY_SET = new LinkedHashSet<String>();
        VERSION_PROPERTY_SET.add("cmis:objectId");
        VERSION_PROPERTY_SET.add("cmis:objectTypeId");
        VERSION_PROPERTY_SET.add("cmis:name");
        VERSION_PROPERTY_SET.add("cmis:versionLabel");
        VERSION_PROPERTY_SET.add("cmis:isLatestVersion");
        VERSION_PROPERTY_SET.add("cmis:isMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:isLatestMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:contentStreamMimeType");
        VERSION_PROPERTY_SET.add("cmis:contentStreamLength");
        VERSION_PROPERTY_SET.add("cmis:contentStreamFileName");
        VERSION_PROPERTY_SET.add("cmis:isVersionSeriesCheckedOut");
        VERSION_PROPERTY_SET.add("cmis:changeToken");
        VERSION_PROPERTY_SET.add("cmis:createdBy");
        VERSION_PROPERTY_SET.add("cmis:creationDate");
        VERSION_PROPERTY_SET.add("cmis:lastModifiedBy");
        VERSION_PROPERTY_SET.add("cmis:lastModificationDate");
        VERSION_PROPERTY_SET.add("cmis:versionSeriesCheckedOutId");
        VERSION_PROPERTY_SET.add("cmis:versionSeriesCheckedOutBy");
        VERSION_PROPERTY_SET.add("cmis:checkinComment");
    }

    protected class Context
    extends OperationContextImpl {
        private static final long serialVersionUID = 1L;

        protected Context(String filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, String renditionFilter, String orderBy, int maxItemsPerPage) {
            this.setFilterString(filter);
            this.setIncludeAcls(includeAcls);
            this.setIncludeAllowableActions(includeAllowableActions);
            this.setIncludePolicies(includePolicies);
            this.setIncludeRelationships(includeRelationships);
            this.setRenditionFilterString(renditionFilter);
            this.setOrderBy(orderBy);
            this.setMaxItemsPerPage(maxItemsPerPage);
            this.setIncludePathSegments(false);
            this.setCacheEnabled(false);
        }
    }

    protected class TimeChangeToken
    extends ChangeToken {
        protected final GregorianCalendar time;

        protected TimeChangeToken(GregorianCalendar time) {
            super(String.valueOf(time.getTimeInMillis()));
            this.time = time;
        }

        protected GregorianCalendar getTime() {
            return this.time;
        }

        @Override
        public boolean equals(ChangeToken other) {
            if (other instanceof TimeChangeToken) {
                return this.getTime().equals(((TimeChangeToken)other).getTime());
            }
            return false;
        }

        @Override
        public int compareTo(ChangeToken other) {
            if (other instanceof TimeChangeToken) {
                return this.getTime().compareTo(((TimeChangeToken)other).getTime());
            }
            return super.compareTo(other);
        }
    }

    protected class ChangeToken {
        protected final String token;
        protected final Long order;

        protected ChangeToken(String token) {
            if (token == null) {
                this.token = EMPTY_TOKEN;
                this.order = null;
            } else {
                Long order;
                this.token = token;
                try {
                    order = Long.parseLong(token);
                }
                catch (NumberFormatException e) {
                    order = null;
                }
                this.order = order;
            }
        }

        public boolean equals(ChangeToken other) {
            if (other != null && !this.isEmpty() && !other.isEmpty()) {
                return this.getString().equals(other.getString());
            }
            return false;
        }

        public boolean isAfter(ChangeToken other) {
            return !this.isEmpty() && this.compareTo(other) > 0;
        }

        public boolean isBefore(ChangeToken other) {
            return !this.isEmpty() && this.compareTo(other) < 0;
        }

        public boolean isEmpty() {
            return this.token.equals(EMPTY_TOKEN);
        }

        public String getString() {
            return this.token;
        }

        public String toString() {
            return this.getString();
        }

        protected int compareTo(ChangeToken other) {
            if (this.order != null && other.order != null) {
                return this.order.compareTo(other.order);
            }
            return this.getString().compareTo(other.getString());
        }
    }

    protected class ChangesIterator
    extends ChunkIterator<ChangeEvent> {
        protected ChangeToken changeToken;
        protected ChangeToken lastFetchedToken;
        protected ChangeToken latestChunkToken;
        protected List<ChangeEvent> changes;
        protected boolean firstRun = true;
        protected boolean hasMoreItems = true;
        protected boolean cleanNext = true;

        protected ChangesIterator(ChangeToken startChangeToken) throws CMISException, CloudDriveAccessException {
            this.changeToken = startChangeToken;
            this.lastFetchedToken = this.latestChunkToken = CMISAPI.this.emptyToken();
            this.iter = this.nextChunk();
            this.firstRun = false;
        }

        protected Iterator<ChangeEvent> nextChunk() throws CMISException, CloudDriveAccessException {
            if (!this.changeToken.isEmpty()) {
                try {
                    ChangeEvents events = CMISAPI.this.session().getContentChanges(this.changeToken.getString(), true, 10240L);
                    this.changes = events.getChangeEvents();
                    this.latestChunkToken = CMISAPI.this.readToken(events.getLatestChangeLogToken());
                    int changesLen = this.changes.size();
                    if (changesLen > 0) {
                        ChangeToken first = CMISAPI.this.readToken(this.changes.get(0));
                        if (first.equals(this.changeToken) || first.equals(this.lastFetchedToken)) {
                            this.changes.remove(0);
                            changesLen = this.changes.size();
                        }
                        if (events.getHasMoreItems() && changesLen > 0) {
                            ChangeToken nextToken = this.latestChunkToken.isEmpty() ? CMISAPI.this.readToken(this.changes.get(changesLen - 1)) : this.latestChunkToken;
                            this.hasMoreItems = this.lastFetchedToken.isEmpty() ? true : nextToken.isAfter(this.lastFetchedToken);
                            this.changeToken = this.hasMoreItems ? nextToken : null;
                        } else {
                            this.hasMoreItems = false;
                            this.changeToken = CMISAPI.this.emptyToken();
                        }
                    } else {
                        this.hasMoreItems = false;
                        this.changeToken = CMISAPI.this.emptyToken();
                    }
                    this.available(changesLen);
                    return this.changes.iterator();
                }
                catch (CmisConnectionException e) {
                    throw new CMISException("Error getting remote changes: " + e.getMessage(), e);
                }
                catch (CmisPermissionDeniedException e) {
                    throw new RefreshAccessException("Permission denied for getting folder items: " + e.getMessage(), (Throwable)e);
                }
                catch (CmisUnauthorizedException e) {
                    throw new CloudDriveAccessException("Unauthorized for getting remote changes: " + e.getMessage(), (Throwable)e);
                }
                catch (CmisConstraintException e) {
                    throw new CMISInvalidArgumentException("Error getting remote changes (event corresponding to provided change log token is no longer available): " + e.getMessage(), e);
                }
                catch (CmisInvalidArgumentException e) {
                    throw new CMISInvalidArgumentException("Error getting remote changes (event corresponding to provided change log token is no longer available): " + e.getMessage(), e);
                }
                catch (CmisRuntimeException e) {
                    throw new CMISException("Error getting remote changes: " + e.getMessage(), e);
                }
            }
            return new ArrayList().iterator();
        }

        protected boolean hasNextChunk() {
            return this.hasMoreItems;
        }

        public boolean hasNext() throws CloudDriveException {
            boolean hasNext = super.hasNext();
            if (hasNext && this.cleanNext) {
                this.lastFetchedToken = CMISAPI.this.readToken((ChangeEvent)this.next);
                if (!ChangeType.DELETED.equals((Object)((ChangeEvent)this.next).getChangeType())) {
                    for (ChangeEvent che : this.changes) {
                        if (!((ChangeEvent)this.next).getObjectId().equals(che.getObjectId()) || !ChangeType.DELETED.equals((Object)che.getChangeType())) continue;
                        try {
                            this.next();
                            hasNext = this.hasNext();
                        }
                        catch (NoSuchElementException e) {
                            hasNext = false;
                        }
                        break;
                    }
                }
                this.cleanNext = false;
            }
            return hasNext;
        }

        public ChangeEvent next() throws NoSuchElementException, CloudDriveException {
            ChangeEvent next = (ChangeEvent)super.next();
            this.cleanNext = true;
            return next;
        }

        protected ChangeToken getLastChangeToken() {
            return !this.lastFetchedToken.isEmpty() ? this.lastFetchedToken : (!this.latestChunkToken.isEmpty() ? this.latestChunkToken : this.changeToken);
        }
    }

    protected class ChildrenIterator
    extends ChunkIterator<CmisObject> {
        protected final String folderId;
        protected Folder parent;
        protected ItemIterable<CmisObject> children;

        protected ChildrenIterator(String folderId) throws CloudDriveException {
            this.folderId = folderId;
            this.iter = this.nextChunk();
        }

        protected Iterator<CmisObject> nextChunk() throws CloudDriveException {
            try {
                CmisObject obj = CMISAPI.this.readObject(this.folderId, CMISAPI.this.session(), CMISAPI.this.folderContext);
                if (CMISAPI.this.isFolder(obj)) {
                    this.parent = (Folder)obj;
                    this.children = this.parent.getChildren(CMISAPI.this.fileContext);
                    long total = this.children.getTotalNumItems();
                    if (total == -1L) {
                        total = this.children.getPageNumItems();
                    }
                    this.available(total);
                    return this.children.iterator();
                }
                return new ArrayList().iterator();
            }
            catch (CmisConnectionException e) {
                throw new CMISException("Error getting folder items: " + e.getMessage(), e);
            }
            catch (CmisInvalidArgumentException e) {
                throw new CMISInvalidArgumentException("Error getting folder items (parent not a folder): " + e.getMessage(), e);
            }
            catch (CmisPermissionDeniedException e) {
                throw new RefreshAccessException("Permission denied for getting folder items: " + e.getMessage(), (Throwable)e);
            }
            catch (CmisUnauthorizedException e) {
                throw new CloudDriveAccessException("Unauthorized for getting folder items: " + e.getMessage(), (Throwable)e);
            }
            catch (CmisRuntimeException e) {
                throw new CMISException("Error getting folder items: " + e.getMessage(), e);
            }
            catch (CmisBaseException e) {
                throw new CMISException("Error getting folder items: " + e.getMessage(), e);
            }
        }

        protected boolean hasNextChunk() {
            return false;
        }
    }
}

