/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.dropbox.DropboxConnector;
import org.exoplatform.services.jcr.RepositoryService;

public class DropboxProvider
extends CloudProvider {
    protected final DropboxConnector.API authBilder;
    protected final String redirectURL;
    protected final RepositoryService jcrService;

    public DropboxProvider(String id, String name, DropboxConnector.API authBilder, String redirectURL, RepositoryService jcrService) {
        super(id, name);
        this.authBilder = authBilder;
        this.redirectURL = redirectURL;
        this.jcrService = jcrService;
    }

    public String getAuthURL() throws CloudDriveException {
        String authState;
        if (this.jcrService != null) {
            try {
                authState = this.jcrService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                throw new CloudDriveException((Throwable)e);
            }
        } else {
            authState = "__no_state_set__";
        }
        String authURL = this.authBilder.authLink(authState);
        return authURL;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public boolean retryOnProviderError() {
        return true;
    }

    public String getErrorMessage(String error, String errorDescription) {
        return error;
    }
}

