/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.services.drive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.exoplatform.shaded.google.api.client.googleapis.GoogleUtils;
import org.exoplatform.shaded.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import org.exoplatform.shaded.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import org.exoplatform.shaded.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import org.exoplatform.shaded.google.api.client.http.AbstractInputStreamContent;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.json.JsonFactory;
import org.exoplatform.shaded.google.api.client.util.Data;
import org.exoplatform.shaded.google.api.client.util.Key;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.services.drive.DriveRequest;
import org.exoplatform.shaded.google.api.services.drive.DriveRequestInitializer;
import org.exoplatform.shaded.google.api.services.drive.model.App;
import org.exoplatform.shaded.google.api.services.drive.model.AppList;
import org.exoplatform.shaded.google.api.services.drive.model.Change;
import org.exoplatform.shaded.google.api.services.drive.model.ChangeList;
import org.exoplatform.shaded.google.api.services.drive.model.Channel;
import org.exoplatform.shaded.google.api.services.drive.model.ChildList;
import org.exoplatform.shaded.google.api.services.drive.model.ChildReference;
import org.exoplatform.shaded.google.api.services.drive.model.Comment;
import org.exoplatform.shaded.google.api.services.drive.model.CommentList;
import org.exoplatform.shaded.google.api.services.drive.model.CommentReply;
import org.exoplatform.shaded.google.api.services.drive.model.CommentReplyList;
import org.exoplatform.shaded.google.api.services.drive.model.File;
import org.exoplatform.shaded.google.api.services.drive.model.FileList;
import org.exoplatform.shaded.google.api.services.drive.model.ParentList;
import org.exoplatform.shaded.google.api.services.drive.model.ParentReference;
import org.exoplatform.shaded.google.api.services.drive.model.Permission;
import org.exoplatform.shaded.google.api.services.drive.model.PermissionId;
import org.exoplatform.shaded.google.api.services.drive.model.PermissionList;
import org.exoplatform.shaded.google.api.services.drive.model.Property;
import org.exoplatform.shaded.google.api.services.drive.model.PropertyList;
import org.exoplatform.shaded.google.api.services.drive.model.Revision;
import org.exoplatform.shaded.google.api.services.drive.model.RevisionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Drive
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "drive/v2/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/drive/v2/";

    public Drive(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Drive(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public About about() {
        return new About();
    }

    public Apps apps() {
        return new Apps();
    }

    public Changes changes() {
        return new Changes();
    }

    public Channels channels() {
        return new Channels();
    }

    public Children children() {
        return new Children();
    }

    public Comments comments() {
        return new Comments();
    }

    public Files files() {
        return new Files();
    }

    public Parents parents() {
        return new Parents();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Properties properties() {
        return new Properties();
    }

    public Realtime realtime() {
        return new Realtime();
    }

    public Replies replies() {
        return new Replies();
    }

    public Revisions revisions() {
        return new Revisions();
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15, "You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Drive API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Drive.DEFAULT_ROOT_URL, Drive.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Drive build() {
            return new Drive(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDriveRequestInitializer(DriveRequestInitializer driveRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(driveRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Revisions {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, String string2, Revision revision) throws IOException {
            Patch patch = new Patch(string, string2, revision);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, String string2, Revision revision) throws IOException {
            Update update = new Update(string, string2, revision);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Update(String string, String string2, Revision revision) {
                super(Drive.this, "PUT", REST_PATH, (Object)revision, Revision.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.revisionId = Preconditions.checkNotNull(string2, "Required parameter revisionId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Update setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Patch(String string, String string2, Revision revision) {
                super(Drive.this, "PATCH", REST_PATH, (Object)revision, Revision.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.revisionId = Preconditions.checkNotNull(string2, "Required parameter revisionId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Patch setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<RevisionList> {
            private static final String REST_PATH = "files/{fileId}/revisions";
            @Key
            private String fileId;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, RevisionList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Revision> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Revision.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.revisionId = Preconditions.checkNotNull(string2, "Required parameter revisionId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";
            @Key
            private String fileId;
            @Key
            private String revisionId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.revisionId = Preconditions.checkNotNull(string2, "Required parameter revisionId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Delete setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Replies {
        public Delete delete(String string, String string2, String string3) throws IOException {
            Delete delete = new Delete(string, string2, string3);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2, String string3) throws IOException {
            Get get = new Get(string, string2, string3);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(String string, String string2, CommentReply commentReply) throws IOException {
            Insert insert = new Insert(string, string2, commentReply);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, String string2, String string3, CommentReply commentReply) throws IOException {
            Patch patch = new Patch(string, string2, string3, commentReply);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, String string2, String string3, CommentReply commentReply) throws IOException {
            Update update = new Update(string, string2, string3, commentReply);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Update(String string, String string2, String string3, CommentReply commentReply) {
                super(Drive.this, "PUT", REST_PATH, (Object)commentReply, CommentReply.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
                this.replyId = Preconditions.checkNotNull(string3, "Required parameter replyId must be specified.");
                this.checkRequiredParameter(commentReply, "content");
                this.checkRequiredParameter(commentReply.getContent(), "CommentReply.getContent()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Update setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Patch(String string, String string2, String string3, CommentReply commentReply) {
                super(Drive.this, "PATCH", REST_PATH, (Object)commentReply, CommentReply.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
                this.replyId = Preconditions.checkNotNull(string3, "Required parameter replyId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Patch setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Patch setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<CommentReplyList> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String pageToken;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;

            protected List(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, CommentReplyList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public List setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Insert(String string, String string2, CommentReply commentReply) {
                super(Drive.this, "POST", REST_PATH, (Object)commentReply, CommentReply.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Insert setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<CommentReply> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;
            @Key
            private Boolean includeDeleted;

            protected Get(String string, String string2, String string3) {
                super(Drive.this, "GET", REST_PATH, (Object)null, CommentReply.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
                this.replyId = Preconditions.checkNotNull(string3, "Required parameter replyId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Get setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private String replyId;

            protected Delete(String string, String string2, String string3) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
                this.replyId = Preconditions.checkNotNull(string3, "Required parameter replyId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public String getReplyId() {
                return this.replyId;
            }

            public Delete setReplyId(String string) {
                this.replyId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Realtime {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize(get);
            return get;
        }

        public Update update(String string) throws IOException {
            Update update = new Update(string);
            Drive.this.initialize(update);
            return update;
        }

        public Update update(String string, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, abstractInputStreamContent);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/realtime";
            @Key
            private String fileId;
            @Key
            private String baseRevision;

            protected Update(String string) {
                super(Drive.this, "PUT", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            protected Update(String string, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "PUT", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getBaseRevision() {
                return this.baseRevision;
            }

            public Update setBaseRevision(String string) {
                this.baseRevision = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/realtime";
            @Key
            private String fileId;
            @Key
            private Integer revision;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            @Override
            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            @Override
            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            @Override
            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Integer getRevision() {
                return this.revision;
            }

            public Get setRevision(Integer n) {
                this.revision = n;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Properties {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(String string, Property property) throws IOException {
            Insert insert = new Insert(string, property);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, String string2, Property property) throws IOException {
            Patch patch = new Patch(string, string2, property);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, String string2, Property property) throws IOException {
            Update update = new Update(string, string2, property);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Update(String string, String string2, Property property) {
                super(Drive.this, "PUT", REST_PATH, (Object)property, Property.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.propertyKey = Preconditions.checkNotNull(string2, "Required parameter propertyKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Update setPropertyKey(String string) {
                this.propertyKey = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Update setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Patch(String string, String string2, Property property) {
                super(Drive.this, "PATCH", REST_PATH, (Object)property, Property.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.propertyKey = Preconditions.checkNotNull(string2, "Required parameter propertyKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Patch setPropertyKey(String string) {
                this.propertyKey = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Patch setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<PropertyList> {
            private static final String REST_PATH = "files/{fileId}/properties";
            @Key
            private String fileId;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, PropertyList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties";
            @Key
            private String fileId;

            protected Insert(String string, Property property) {
                super(Drive.this, "POST", REST_PATH, (Object)property, Property.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Property> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Property.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.propertyKey = Preconditions.checkNotNull(string2, "Required parameter propertyKey must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Get setPropertyKey(String string) {
                this.propertyKey = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Get setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/properties/{propertyKey}";
            @Key
            private String fileId;
            @Key
            private String propertyKey;
            @Key
            private String visibility;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.propertyKey = Preconditions.checkNotNull(string2, "Required parameter propertyKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPropertyKey() {
                return this.propertyKey;
            }

            public Delete setPropertyKey(String string) {
                this.propertyKey = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Delete setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Permissions {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public GetIdForEmail getIdForEmail(String string) throws IOException {
            GetIdForEmail getIdForEmail = new GetIdForEmail(string);
            Drive.this.initialize(getIdForEmail);
            return getIdForEmail;
        }

        public Insert insert(String string, Permission permission) throws IOException {
            Insert insert = new Insert(string, permission);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, String string2, Permission permission) throws IOException {
            Patch patch = new Patch(string, string2, permission);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, String string2, Permission permission) throws IOException {
            Update update = new Update(string, string2, permission);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean transferOwnership;

            protected Update(String string, String string2, Permission permission) {
                super(Drive.this, "PUT", REST_PATH, (Object)permission, Permission.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.permissionId = Preconditions.checkNotNull(string2, "Required parameter permissionId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Update setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Update setTransferOwnership(Boolean bl) {
                this.transferOwnership = bl;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;
            @Key
            private Boolean transferOwnership;

            protected Patch(String string, String string2, Permission permission) {
                super(Drive.this, "PATCH", REST_PATH, (Object)permission, Permission.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.permissionId = Preconditions.checkNotNull(string2, "Required parameter permissionId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Patch setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            public Boolean getTransferOwnership() {
                return this.transferOwnership;
            }

            public Patch setTransferOwnership(Boolean bl) {
                this.transferOwnership = bl;
                return this;
            }

            public boolean isTransferOwnership() {
                if (this.transferOwnership == null || this.transferOwnership == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.transferOwnership;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<PermissionList> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, PermissionList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions";
            @Key
            private String fileId;
            @Key
            private String emailMessage;
            @Key
            private Boolean sendNotificationEmails;

            protected Insert(String string, Permission permission) {
                super(Drive.this, "POST", REST_PATH, (Object)permission, Permission.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.checkRequiredParameter(permission, "content");
                this.checkRequiredParameter(permission.getRole(), "Permission.getRole()");
                this.checkRequiredParameter(permission, "content");
                this.checkRequiredParameter(permission.getType(), "Permission.getType()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getEmailMessage() {
                return this.emailMessage;
            }

            public Insert setEmailMessage(String string) {
                this.emailMessage = string;
                return this;
            }

            public Boolean getSendNotificationEmails() {
                return this.sendNotificationEmails;
            }

            public Insert setSendNotificationEmails(Boolean bl) {
                this.sendNotificationEmails = bl;
                return this;
            }

            public boolean isSendNotificationEmails() {
                if (this.sendNotificationEmails == null || this.sendNotificationEmails == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.sendNotificationEmails;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIdForEmail
        extends DriveRequest<PermissionId> {
            private static final String REST_PATH = "permissionIds/{email}";
            @Key
            private String email;

            protected GetIdForEmail(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, PermissionId.class);
                this.email = Preconditions.checkNotNull(string, "Required parameter email must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIdForEmail setAlt(String string) {
                return (GetIdForEmail)super.setAlt(string);
            }

            public GetIdForEmail setFields(String string) {
                return (GetIdForEmail)super.setFields(string);
            }

            public GetIdForEmail setKey(String string) {
                return (GetIdForEmail)super.setKey(string);
            }

            public GetIdForEmail setOauthToken(String string) {
                return (GetIdForEmail)super.setOauthToken(string);
            }

            public GetIdForEmail setPrettyPrint(Boolean bl) {
                return (GetIdForEmail)super.setPrettyPrint(bl);
            }

            public GetIdForEmail setQuotaUser(String string) {
                return (GetIdForEmail)super.setQuotaUser(string);
            }

            public GetIdForEmail setUserIp(String string) {
                return (GetIdForEmail)super.setUserIp(string);
            }

            public String getEmail() {
                return this.email;
            }

            public GetIdForEmail setEmail(String string) {
                this.email = string;
                return this;
            }

            @Override
            public GetIdForEmail set(String string, Object object) {
                return (GetIdForEmail)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Permission> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Permission.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.permissionId = Preconditions.checkNotNull(string2, "Required parameter permissionId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Get setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";
            @Key
            private String fileId;
            @Key
            private String permissionId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.permissionId = Preconditions.checkNotNull(string2, "Required parameter permissionId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPermissionId() {
                return this.permissionId;
            }

            public Delete setPermissionId(String string) {
                this.permissionId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Parents {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(String string, ParentReference parentReference) throws IOException {
            Insert insert = new Insert(string, parentReference);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<ParentList> {
            private static final String REST_PATH = "files/{fileId}/parents";
            @Key
            private String fileId;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, ParentList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<ParentReference> {
            private static final String REST_PATH = "files/{fileId}/parents";
            @Key
            private String fileId;

            protected Insert(String string, ParentReference parentReference) {
                super(Drive.this, "POST", REST_PATH, (Object)parentReference, ParentReference.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.checkRequiredParameter(parentReference, "content");
                this.checkRequiredParameter(parentReference.getId(), "ParentReference.getId()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<ParentReference> {
            private static final String REST_PATH = "files/{fileId}/parents/{parentId}";
            @Key
            private String fileId;
            @Key
            private String parentId;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, ParentReference.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.parentId = Preconditions.checkNotNull(string2, "Required parameter parentId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getParentId() {
                return this.parentId;
            }

            public Get setParentId(String string) {
                this.parentId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/parents/{parentId}";
            @Key
            private String fileId;
            @Key
            private String parentId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.parentId = Preconditions.checkNotNull(string2, "Required parameter parentId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getParentId() {
                return this.parentId;
            }

            public Delete setParentId(String string) {
                this.parentId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Files {
        public Copy copy(String string, File file) throws IOException {
            Copy copy = new Copy(string, file);
            Drive.this.initialize(copy);
            return copy;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Drive.this.initialize(delete);
            return delete;
        }

        public EmptyTrash emptyTrash() throws IOException {
            EmptyTrash emptyTrash = new EmptyTrash();
            Drive.this.initialize(emptyTrash);
            return emptyTrash;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(File file) throws IOException {
            Insert insert = new Insert(file);
            Drive.this.initialize(insert);
            return insert;
        }

        public Insert insert(File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(file, abstractInputStreamContent);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, File file) throws IOException {
            Patch patch = new Patch(string, file);
            Drive.this.initialize(patch);
            return patch;
        }

        public Touch touch(String string) throws IOException {
            Touch touch = new Touch(string);
            Drive.this.initialize(touch);
            return touch;
        }

        public Trash trash(String string) throws IOException {
            Trash trash = new Trash(string);
            Drive.this.initialize(trash);
            return trash;
        }

        public Untrash untrash(String string) throws IOException {
            Untrash untrash = new Untrash(string);
            Drive.this.initialize(untrash);
            return untrash;
        }

        public Update update(String string, File file) throws IOException {
            Update update = new Update(string, file);
            Drive.this.initialize(update);
            return update;
        }

        public Update update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Update update = new Update(string, file, abstractInputStreamContent);
            Drive.this.initialize(update);
            return update;
        }

        public Watch watch(String string, Channel channel) throws IOException {
            Watch watch = new Watch(string, channel);
            Drive.this.initialize(watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "files/{fileId}/watch";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String revisionId;
            @Key
            private String projection;

            protected Watch(String string, Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            @Override
            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            @Override
            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            @Override
            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Watch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Watch setAcknowledgeAbuse(Boolean bl) {
                this.acknowledgeAbuse = bl;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Watch setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateViewedDate;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Watch setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Watch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String removeParents;
            @Key
            private Boolean setModifiedDate;
            @Key
            private Boolean convert;
            @Key
            private Boolean useContentAsIndexableText;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private Boolean newRevision;
            @Key
            private Boolean ocr;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;

            protected Update(String string, File file) {
                super(Drive.this, "PUT", REST_PATH, (Object)file, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            protected Update(String string, File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "PUT", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Update setAddParents(String string) {
                this.addParents = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Update setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Update setRemoveParents(String string) {
                this.removeParents = string;
                return this;
            }

            public Boolean getSetModifiedDate() {
                return this.setModifiedDate;
            }

            public Update setSetModifiedDate(Boolean bl) {
                this.setModifiedDate = bl;
                return this;
            }

            public boolean isSetModifiedDate() {
                if (this.setModifiedDate == null || this.setModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.setModifiedDate;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Update setConvert(Boolean bl) {
                this.convert = bl;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Update setUseContentAsIndexableText(Boolean bl) {
                this.useContentAsIndexableText = bl;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Update setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Update setPinned(Boolean bl) {
                this.pinned = bl;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Update setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Update setOcr(Boolean bl) {
                this.ocr = bl;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Update setTimedTextLanguage(String string) {
                this.timedTextLanguage = string;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Update setTimedTextTrackName(String string) {
                this.timedTextTrackName = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Untrash
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/untrash";
            @Key
            private String fileId;

            protected Untrash(String string) {
                super(Drive.this, "POST", REST_PATH, (Object)null, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Untrash setAlt(String string) {
                return (Untrash)super.setAlt(string);
            }

            public Untrash setFields(String string) {
                return (Untrash)super.setFields(string);
            }

            public Untrash setKey(String string) {
                return (Untrash)super.setKey(string);
            }

            public Untrash setOauthToken(String string) {
                return (Untrash)super.setOauthToken(string);
            }

            public Untrash setPrettyPrint(Boolean bl) {
                return (Untrash)super.setPrettyPrint(bl);
            }

            public Untrash setQuotaUser(String string) {
                return (Untrash)super.setQuotaUser(string);
            }

            public Untrash setUserIp(String string) {
                return (Untrash)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Untrash setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Untrash set(String string, Object object) {
                return (Untrash)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Trash
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/trash";
            @Key
            private String fileId;

            protected Trash(String string) {
                super(Drive.this, "POST", REST_PATH, (Object)null, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Trash setAlt(String string) {
                return (Trash)super.setAlt(string);
            }

            public Trash setFields(String string) {
                return (Trash)super.setFields(string);
            }

            public Trash setKey(String string) {
                return (Trash)super.setKey(string);
            }

            public Trash setOauthToken(String string) {
                return (Trash)super.setOauthToken(string);
            }

            public Trash setPrettyPrint(Boolean bl) {
                return (Trash)super.setPrettyPrint(bl);
            }

            public Trash setQuotaUser(String string) {
                return (Trash)super.setQuotaUser(string);
            }

            public Trash setUserIp(String string) {
                return (Trash)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Trash setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Trash set(String string, Object object) {
                return (Trash)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Touch
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/touch";
            @Key
            private String fileId;

            protected Touch(String string) {
                super(Drive.this, "POST", REST_PATH, (Object)null, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Touch setAlt(String string) {
                return (Touch)super.setAlt(string);
            }

            public Touch setFields(String string) {
                return (Touch)super.setFields(string);
            }

            public Touch setKey(String string) {
                return (Touch)super.setKey(string);
            }

            public Touch setOauthToken(String string) {
                return (Touch)super.setOauthToken(string);
            }

            public Touch setPrettyPrint(Boolean bl) {
                return (Touch)super.setPrettyPrint(bl);
            }

            public Touch setQuotaUser(String string) {
                return (Touch)super.setQuotaUser(string);
            }

            public Touch setUserIp(String string) {
                return (Touch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Touch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Touch set(String string, Object object) {
                return (Touch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private String addParents;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String removeParents;
            @Key
            private Boolean setModifiedDate;
            @Key
            private Boolean convert;
            @Key
            private Boolean useContentAsIndexableText;
            @Key
            private String ocrLanguage;
            @Key
            private Boolean pinned;
            @Key
            private Boolean newRevision;
            @Key
            private Boolean ocr;
            @Key
            private String timedTextLanguage;
            @Key
            private String timedTextTrackName;

            protected Patch(String string, File file) {
                super(Drive.this, "PATCH", REST_PATH, (Object)file, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getAddParents() {
                return this.addParents;
            }

            public Patch setAddParents(String string) {
                this.addParents = string;
                return this;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Patch setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.updateViewedDate;
            }

            public String getRemoveParents() {
                return this.removeParents;
            }

            public Patch setRemoveParents(String string) {
                this.removeParents = string;
                return this;
            }

            public Boolean getSetModifiedDate() {
                return this.setModifiedDate;
            }

            public Patch setSetModifiedDate(Boolean bl) {
                this.setModifiedDate = bl;
                return this;
            }

            public boolean isSetModifiedDate() {
                if (this.setModifiedDate == null || this.setModifiedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.setModifiedDate;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Patch setConvert(Boolean bl) {
                this.convert = bl;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Patch setUseContentAsIndexableText(Boolean bl) {
                this.useContentAsIndexableText = bl;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Patch setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Patch setPinned(Boolean bl) {
                this.pinned = bl;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getNewRevision() {
                return this.newRevision;
            }

            public Patch setNewRevision(Boolean bl) {
                this.newRevision = bl;
                return this;
            }

            public boolean isNewRevision() {
                if (this.newRevision == null || this.newRevision == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.newRevision;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Patch setOcr(Boolean bl) {
                this.ocr = bl;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Patch setTimedTextLanguage(String string) {
                this.timedTextLanguage = string;
                return this;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Patch setTimedTextTrackName(String string) {
                this.timedTextTrackName = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<FileList> {
            private static final String REST_PATH = "files";
            @Key
            private String projection;
            @Key
            private Integer maxResults;
            @Key
            private String q;
            @Key
            private String pageToken;
            @Key
            private String spaces;
            @Key
            private String corpus;

            protected List() {
                super(Drive.this, "GET", REST_PATH, (Object)null, FileList.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String string) {
                this.q = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public String getCorpus() {
                return this.corpus;
            }

            public List setCorpus(String string) {
                this.corpus = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<File> {
            private static final String REST_PATH = "files";
            @Key
            private Boolean convert;
            @Key
            private Boolean useContentAsIndexableText;
            @Key
            private String ocrLanguage;
            @Key
            private String visibility;
            @Key
            private Boolean pinned;
            @Key
            private Boolean ocr;
            @Key
            private String timedTextTrackName;
            @Key
            private String timedTextLanguage;

            protected Insert(File file) {
                super(Drive.this, "POST", REST_PATH, (Object)file, File.class);
            }

            protected Insert(File file, AbstractInputStreamContent abstractInputStreamContent) {
                super(Drive.this, "POST", "/upload/" + Drive.this.getServicePath() + REST_PATH, (Object)file, File.class);
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Insert setConvert(Boolean bl) {
                this.convert = bl;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public Boolean getUseContentAsIndexableText() {
                return this.useContentAsIndexableText;
            }

            public Insert setUseContentAsIndexableText(Boolean bl) {
                this.useContentAsIndexableText = bl;
                return this;
            }

            public boolean isUseContentAsIndexableText() {
                if (this.useContentAsIndexableText == null || this.useContentAsIndexableText == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.useContentAsIndexableText;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Insert setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Insert setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Insert setPinned(Boolean bl) {
                this.pinned = bl;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Insert setOcr(Boolean bl) {
                this.ocr = bl;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Insert setTimedTextTrackName(String string) {
                this.timedTextTrackName = string;
                return this;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Insert setTimedTextLanguage(String string) {
                this.timedTextLanguage = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;
            @Key
            private Boolean acknowledgeAbuse;
            @Key
            private Boolean updateViewedDate;
            @Key
            private String revisionId;
            @Key
            private String projection;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.initializeMediaDownload();
            }

            @Override
            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            @Override
            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            @Override
            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getAcknowledgeAbuse() {
                return this.acknowledgeAbuse;
            }

            public Get setAcknowledgeAbuse(Boolean bl) {
                this.acknowledgeAbuse = bl;
                return this;
            }

            public boolean isAcknowledgeAbuse() {
                if (this.acknowledgeAbuse == null || this.acknowledgeAbuse == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.acknowledgeAbuse;
            }

            public Boolean getUpdateViewedDate() {
                return this.updateViewedDate;
            }

            public Get setUpdateViewedDate(Boolean bl) {
                this.updateViewedDate = bl;
                return this;
            }

            public boolean isUpdateViewedDate() {
                if (this.updateViewedDate == null || this.updateViewedDate == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.updateViewedDate;
            }

            public String getRevisionId() {
                return this.revisionId;
            }

            public Get setRevisionId(String string) {
                this.revisionId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class EmptyTrash
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/trash";

            protected EmptyTrash() {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
            }

            public EmptyTrash setAlt(String string) {
                return (EmptyTrash)super.setAlt(string);
            }

            public EmptyTrash setFields(String string) {
                return (EmptyTrash)super.setFields(string);
            }

            public EmptyTrash setKey(String string) {
                return (EmptyTrash)super.setKey(string);
            }

            public EmptyTrash setOauthToken(String string) {
                return (EmptyTrash)super.setOauthToken(string);
            }

            public EmptyTrash setPrettyPrint(Boolean bl) {
                return (EmptyTrash)super.setPrettyPrint(bl);
            }

            public EmptyTrash setQuotaUser(String string) {
                return (EmptyTrash)super.setQuotaUser(string);
            }

            public EmptyTrash setUserIp(String string) {
                return (EmptyTrash)super.setUserIp(string);
            }

            @Override
            public EmptyTrash set(String string, Object object) {
                return (EmptyTrash)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}";
            @Key
            private String fileId;

            protected Delete(String string) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Copy
        extends DriveRequest<File> {
            private static final String REST_PATH = "files/{fileId}/copy";
            @Key
            private String fileId;
            @Key
            private Boolean convert;
            @Key
            private String ocrLanguage;
            @Key
            private String visibility;
            @Key
            private Boolean pinned;
            @Key
            private Boolean ocr;
            @Key
            private String timedTextTrackName;
            @Key
            private String timedTextLanguage;

            protected Copy(String string, File file) {
                super(Drive.this, "POST", REST_PATH, (Object)file, File.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            public Copy setAlt(String string) {
                return (Copy)super.setAlt(string);
            }

            public Copy setFields(String string) {
                return (Copy)super.setFields(string);
            }

            public Copy setKey(String string) {
                return (Copy)super.setKey(string);
            }

            public Copy setOauthToken(String string) {
                return (Copy)super.setOauthToken(string);
            }

            public Copy setPrettyPrint(Boolean bl) {
                return (Copy)super.setPrettyPrint(bl);
            }

            public Copy setQuotaUser(String string) {
                return (Copy)super.setQuotaUser(string);
            }

            public Copy setUserIp(String string) {
                return (Copy)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Copy setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public Boolean getConvert() {
                return this.convert;
            }

            public Copy setConvert(Boolean bl) {
                this.convert = bl;
                return this;
            }

            public boolean isConvert() {
                if (this.convert == null || this.convert == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.convert;
            }

            public String getOcrLanguage() {
                return this.ocrLanguage;
            }

            public Copy setOcrLanguage(String string) {
                this.ocrLanguage = string;
                return this;
            }

            public String getVisibility() {
                return this.visibility;
            }

            public Copy setVisibility(String string) {
                this.visibility = string;
                return this;
            }

            public Boolean getPinned() {
                return this.pinned;
            }

            public Copy setPinned(Boolean bl) {
                this.pinned = bl;
                return this;
            }

            public boolean isPinned() {
                if (this.pinned == null || this.pinned == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.pinned;
            }

            public Boolean getOcr() {
                return this.ocr;
            }

            public Copy setOcr(Boolean bl) {
                this.ocr = bl;
                return this;
            }

            public boolean isOcr() {
                if (this.ocr == null || this.ocr == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.ocr;
            }

            public String getTimedTextTrackName() {
                return this.timedTextTrackName;
            }

            public Copy setTimedTextTrackName(String string) {
                this.timedTextTrackName = string;
                return this;
            }

            public String getTimedTextLanguage() {
                return this.timedTextLanguage;
            }

            public Copy setTimedTextLanguage(String string) {
                this.timedTextLanguage = string;
                return this;
            }

            @Override
            public Copy set(String string, Object object) {
                return (Copy)super.set(string, object);
            }
        }
    }

    public class Comments {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(String string, Comment comment) throws IOException {
            Insert insert = new Insert(string, comment);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        public Patch patch(String string, String string2, Comment comment) throws IOException {
            Patch patch = new Patch(string, string2, comment);
            Drive.this.initialize(patch);
            return patch;
        }

        public Update update(String string, String string2, Comment comment) throws IOException {
            Update update = new Update(string, string2, comment);
            Drive.this.initialize(update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Update(String string, String string2, Comment comment) {
                super(Drive.this, "PUT", REST_PATH, (Object)comment, Comment.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
                this.checkRequiredParameter(comment, "content");
                this.checkRequiredParameter(comment.getContent(), "Comment.getContent()");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Update setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Update setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Patch(String string, String string2, Comment comment) {
                super(Drive.this, "PATCH", REST_PATH, (Object)comment, Comment.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Patch setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Patch setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<CommentList> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;
            @Key
            private String pageToken;
            @Key
            private String updatedMin;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, CommentList.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public List setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String string) {
                this.updatedMin = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments";
            @Key
            private String fileId;

            protected Insert(String string, Comment comment) {
                super(Drive.this, "POST", REST_PATH, (Object)comment, Comment.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.checkRequiredParameter(comment, "content");
                this.checkRequiredParameter(comment.getContent(), "Comment.getContent()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Insert setFileId(String string) {
                this.fileId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Comment> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;
            @Key
            private Boolean includeDeleted;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Comment.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Get setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Get setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Get setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.includeDeleted;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{fileId}/comments/{commentId}";
            @Key
            private String fileId;
            @Key
            private String commentId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.fileId = Preconditions.checkNotNull(string, "Required parameter fileId must be specified.");
                this.commentId = Preconditions.checkNotNull(string2, "Required parameter commentId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFileId() {
                return this.fileId;
            }

            public Delete setFileId(String string) {
                this.fileId = string;
                return this;
            }

            public String getCommentId() {
                return this.commentId;
            }

            public Delete setCommentId(String string) {
                this.commentId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Children {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Drive.this.initialize(delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Drive.this.initialize(get);
            return get;
        }

        public Insert insert(String string, ChildReference childReference) throws IOException {
            Insert insert = new Insert(string, childReference);
            Drive.this.initialize(insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Drive.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<ChildList> {
            private static final String REST_PATH = "files/{folderId}/children";
            @Key
            private String folderId;
            @Key
            private String q;
            @Key
            private String pageToken;
            @Key
            private Integer maxResults;

            protected List(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, ChildList.class);
                this.folderId = Preconditions.checkNotNull(string, "Required parameter folderId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public List setFolderId(String string) {
                this.folderId = string;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String string) {
                this.q = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DriveRequest<ChildReference> {
            private static final String REST_PATH = "files/{folderId}/children";
            @Key
            private String folderId;

            protected Insert(String string, ChildReference childReference) {
                super(Drive.this, "POST", REST_PATH, (Object)childReference, ChildReference.class);
                this.folderId = Preconditions.checkNotNull(string, "Required parameter folderId must be specified.");
                this.checkRequiredParameter(childReference, "content");
                this.checkRequiredParameter(childReference.getId(), "ChildReference.getId()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Insert setFolderId(String string) {
                this.folderId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<ChildReference> {
            private static final String REST_PATH = "files/{folderId}/children/{childId}";
            @Key
            private String folderId;
            @Key
            private String childId;

            protected Get(String string, String string2) {
                super(Drive.this, "GET", REST_PATH, (Object)null, ChildReference.class);
                this.folderId = Preconditions.checkNotNull(string, "Required parameter folderId must be specified.");
                this.childId = Preconditions.checkNotNull(string2, "Required parameter childId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Get setFolderId(String string) {
                this.folderId = string;
                return this;
            }

            public String getChildId() {
                return this.childId;
            }

            public Get setChildId(String string) {
                this.childId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DriveRequest<Void> {
            private static final String REST_PATH = "files/{folderId}/children/{childId}";
            @Key
            private String folderId;
            @Key
            private String childId;

            protected Delete(String string, String string2) {
                super(Drive.this, "DELETE", REST_PATH, (Object)null, Void.class);
                this.folderId = Preconditions.checkNotNull(string, "Required parameter folderId must be specified.");
                this.childId = Preconditions.checkNotNull(string2, "Required parameter childId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getFolderId() {
                return this.folderId;
            }

            public Delete setFolderId(String string) {
                this.folderId = string;
                return this;
            }

            public String getChildId() {
                return this.childId;
            }

            public Delete setChildId(String string) {
                this.childId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Drive.this.initialize(stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends DriveRequest<Void> {
            private static final String REST_PATH = "channels/stop";

            protected Stop(Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Changes {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize(get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Drive.this.initialize(list);
            return list;
        }

        public Watch watch(Channel channel) throws IOException {
            Watch watch = new Watch(channel);
            Drive.this.initialize(watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends DriveRequest<Channel> {
            private static final String REST_PATH = "changes/watch";
            @Key
            private Boolean includeSubscribed;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String spaces;
            @Key
            private Long startChangeId;

            protected Watch(Channel channel) {
                super(Drive.this, "POST", REST_PATH, (Object)channel, Channel.class);
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public Watch setIncludeSubscribed(Boolean bl) {
                this.includeSubscribed = bl;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public Watch setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public Watch setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public Watch setStartChangeId(Long l) {
                this.startChangeId = l;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<ChangeList> {
            private static final String REST_PATH = "changes";
            @Key
            private Boolean includeSubscribed;
            @Key
            private Boolean includeDeleted;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String spaces;
            @Key
            private Long startChangeId;

            protected List() {
                super(Drive.this, "GET", REST_PATH, (Object)null, ChangeList.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public List setIncludeSubscribed(Boolean bl) {
                this.includeSubscribed = bl;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Boolean getIncludeDeleted() {
                return this.includeDeleted;
            }

            public List setIncludeDeleted(Boolean bl) {
                this.includeDeleted = bl;
                return this;
            }

            public boolean isIncludeDeleted() {
                if (this.includeDeleted == null || this.includeDeleted == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeDeleted;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSpaces() {
                return this.spaces;
            }

            public List setSpaces(String string) {
                this.spaces = string;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public List setStartChangeId(Long l) {
                this.startChangeId = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<Change> {
            private static final String REST_PATH = "changes/{changeId}";
            @Key
            private String changeId;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, Change.class);
                this.changeId = Preconditions.checkNotNull(string, "Required parameter changeId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getChangeId() {
                return this.changeId;
            }

            public Get setChangeId(String string) {
                this.changeId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Apps {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Drive.this.initialize(get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Drive.this.initialize(list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DriveRequest<AppList> {
            private static final String REST_PATH = "apps";
            @Key
            private String languageCode;
            @Key
            private String appFilterExtensions;
            @Key
            private String appFilterMimeTypes;

            protected List() {
                super(Drive.this, "GET", REST_PATH, (Object)null, AppList.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String string) {
                this.languageCode = string;
                return this;
            }

            public String getAppFilterExtensions() {
                return this.appFilterExtensions;
            }

            public List setAppFilterExtensions(String string) {
                this.appFilterExtensions = string;
                return this;
            }

            public String getAppFilterMimeTypes() {
                return this.appFilterMimeTypes;
            }

            public List setAppFilterMimeTypes(String string) {
                this.appFilterMimeTypes = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<App> {
            private static final String REST_PATH = "apps/{appId}";
            @Key
            private String appId;

            protected Get(String string) {
                super(Drive.this, "GET", REST_PATH, (Object)null, App.class);
                this.appId = Preconditions.checkNotNull(string, "Required parameter appId must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getAppId() {
                return this.appId;
            }

            public Get setAppId(String string) {
                this.appId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class About {
        public Get get() throws IOException {
            Get get = new Get();
            Drive.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DriveRequest<org.exoplatform.shaded.google.api.services.drive.model.About> {
            private static final String REST_PATH = "about";
            @Key
            private Boolean includeSubscribed;
            @Key
            private Long maxChangeIdCount;
            @Key
            private Long startChangeId;

            protected Get() {
                super(Drive.this, "GET", REST_PATH, (Object)null, org.exoplatform.shaded.google.api.services.drive.model.About.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public Boolean getIncludeSubscribed() {
                return this.includeSubscribed;
            }

            public Get setIncludeSubscribed(Boolean bl) {
                this.includeSubscribed = bl;
                return this;
            }

            public boolean isIncludeSubscribed() {
                if (this.includeSubscribed == null || this.includeSubscribed == Data.NULL_BOOLEAN) {
                    return true;
                }
                return this.includeSubscribed;
            }

            public Long getMaxChangeIdCount() {
                return this.maxChangeIdCount;
            }

            public Get setMaxChangeIdCount(Long l) {
                this.maxChangeIdCount = l;
                return this;
            }

            public Long getStartChangeId() {
                return this.startChangeId;
            }

            public Get setStartChangeId(Long l) {
                this.startChangeId = l;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

