/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.services;

import java.io.IOException;
import java.util.logging.Logger;
import org.exoplatform.shaded.google.api.client.googleapis.batch.BatchRequest;
import org.exoplatform.shaded.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import org.exoplatform.shaded.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.GenericUrl;
import org.exoplatform.shaded.google.api.client.http.HttpRequestFactory;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.util.ObjectParser;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.client.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGoogleClient {
    static final Logger logger = Logger.getLogger(AbstractGoogleClient.class.getName());
    private final HttpRequestFactory requestFactory;
    private final GoogleClientRequestInitializer googleClientRequestInitializer;
    private final String rootUrl;
    private final String servicePath;
    private final String batchPath;
    private final String applicationName;
    private final ObjectParser objectParser;
    private final boolean suppressPatternChecks;
    private final boolean suppressRequiredParameterChecks;

    protected AbstractGoogleClient(Builder builder) {
        this.googleClientRequestInitializer = builder.googleClientRequestInitializer;
        this.rootUrl = AbstractGoogleClient.normalizeRootUrl(builder.rootUrl);
        this.servicePath = AbstractGoogleClient.normalizeServicePath(builder.servicePath);
        this.batchPath = builder.batchPath;
        if (Strings.isNullOrEmpty(builder.applicationName)) {
            logger.warning("Application name is not set. Call Builder#setApplicationName.");
        }
        this.applicationName = builder.applicationName;
        this.requestFactory = builder.httpRequestInitializer == null ? builder.transport.createRequestFactory() : builder.transport.createRequestFactory(builder.httpRequestInitializer);
        this.objectParser = builder.objectParser;
        this.suppressPatternChecks = builder.suppressPatternChecks;
        this.suppressRequiredParameterChecks = builder.suppressRequiredParameterChecks;
    }

    public final String getRootUrl() {
        return this.rootUrl;
    }

    public final String getServicePath() {
        return this.servicePath;
    }

    public final String getBaseUrl() {
        String string = String.valueOf(this.rootUrl);
        String string2 = String.valueOf(this.servicePath);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
        return this.googleClientRequestInitializer;
    }

    public ObjectParser getObjectParser() {
        return this.objectParser;
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        if (this.getGoogleClientRequestInitializer() != null) {
            this.getGoogleClientRequestInitializer().initialize(httpClientRequest);
        }
    }

    public final BatchRequest batch() {
        return this.batch(null);
    }

    public final BatchRequest batch(HttpRequestInitializer httpRequestInitializer) {
        BatchRequest batch = new BatchRequest(this.getRequestFactory().getTransport(), httpRequestInitializer);
        String string = String.valueOf(this.getRootUrl());
        String string2 = String.valueOf(this.batchPath);
        batch.setBatchUrl(new GenericUrl(string2.length() != 0 ? string.concat(string2) : new String(string)));
        return batch;
    }

    public final boolean getSuppressPatternChecks() {
        return this.suppressPatternChecks;
    }

    public final boolean getSuppressRequiredParameterChecks() {
        return this.suppressRequiredParameterChecks;
    }

    static String normalizeRootUrl(String rootUrl) {
        Preconditions.checkNotNull(rootUrl, "root URL cannot be null.");
        if (!rootUrl.endsWith("/")) {
            rootUrl = String.valueOf(rootUrl).concat("/");
        }
        return rootUrl;
    }

    static String normalizeServicePath(String servicePath) {
        Preconditions.checkNotNull(servicePath, "service path cannot be null");
        if (servicePath.length() == 1) {
            Preconditions.checkArgument("/".equals(servicePath), "service path must equal \"/\" if it is of length 1.");
            servicePath = "";
        } else if (servicePath.length() > 0) {
            if (!servicePath.endsWith("/")) {
                servicePath = String.valueOf(servicePath).concat("/");
            }
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
        }
        return servicePath;
    }

    public static abstract class Builder {
        final HttpTransport transport;
        GoogleClientRequestInitializer googleClientRequestInitializer;
        HttpRequestInitializer httpRequestInitializer;
        final ObjectParser objectParser;
        String rootUrl;
        String servicePath;
        String batchPath;
        String applicationName;
        boolean suppressPatternChecks;
        boolean suppressRequiredParameterChecks;

        protected Builder(HttpTransport transport, String rootUrl, String servicePath, ObjectParser objectParser, HttpRequestInitializer httpRequestInitializer) {
            this.transport = Preconditions.checkNotNull(transport);
            this.objectParser = objectParser;
            this.setRootUrl(rootUrl);
            this.setServicePath(servicePath);
            this.httpRequestInitializer = httpRequestInitializer;
        }

        public abstract AbstractGoogleClient build();

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public ObjectParser getObjectParser() {
            return this.objectParser;
        }

        public final String getRootUrl() {
            return this.rootUrl;
        }

        public Builder setRootUrl(String rootUrl) {
            this.rootUrl = AbstractGoogleClient.normalizeRootUrl(rootUrl);
            return this;
        }

        public final String getServicePath() {
            return this.servicePath;
        }

        public Builder setServicePath(String servicePath) {
            this.servicePath = AbstractGoogleClient.normalizeServicePath(servicePath);
            return this;
        }

        public Builder setBatchPath(String batchPath) {
            this.batchPath = batchPath;
            return this;
        }

        public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
            return this.googleClientRequestInitializer;
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            this.googleClientRequestInitializer = googleClientRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final boolean getSuppressPatternChecks() {
            return this.suppressPatternChecks;
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            this.suppressPatternChecks = suppressPatternChecks;
            return this;
        }

        public final boolean getSuppressRequiredParameterChecks() {
            return this.suppressRequiredParameterChecks;
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            this.suppressRequiredParameterChecks = suppressRequiredParameterChecks;
            return this;
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return this.setSuppressPatternChecks(true).setSuppressRequiredParameterChecks(true);
        }
    }
}

