/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.ecms.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileFilter.class);

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        NodeFinder finder;
        Node actualNode;
        CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        CloudDrive drive = driveService.findDrive(actualNode = (Node)(finder = (NodeFinder)WCMCoreUtils.getService(NodeFinder.class)).getItem(node.getSession(), node.getPath(), true));
        if (drive != null) {
            try {
                if (drive.hasFile(actualNode.getPath())) {
                    WebuiRequestContext.getCurrentInstance().setAttribute(CloudDrive.class, (Object)drive);
                    return true;
                }
            }
            catch (DriveRemovedException e) {
                // empty catch block
            }
        }
        return false;
    }

    @Deprecated
    protected boolean isCloudFile(Node node) throws RepositoryException {
        Node parent;
        if (node.isNodeType("ecd:cloudFile")) {
            return true;
        }
        return node.isNodeType("ecd:cloudFileResource") && (parent = node.getParent()).isNodeType("ecd:cloudFile");
    }
}

