/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import com.ibm.icu.text.Transliterator;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public abstract class JCRLocalCloudDrive
extends CloudDrive {
    public static final String ECD_CLOUDDRIVE = "ecd:cloudDrive";
    public static final String ECD_CLOUDFILE = "ecd:cloudFile";
    public static final String ECD_CLOUDFOLDER = "ecd:cloudFolder";
    public static final String ECD_CLOUDFILERESOURCE = "ecd:cloudFileResource";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFY = "exo:modify";
    public static final String EXO_TRASHFOLDER = "exo:trashFolder";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String DUMMY_DATA = "";
    public static final String USER_WORKSPACE = "user.workspace";
    public static final String USER_NODEPATH = "user.nodePath";
    public static final String USER_SESSIONPROVIDER = "user.sessionProvider";
    protected static final CloudDrive.Command ALREADY_DONE = new AlreadyDone();
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss");
    protected static final ThreadLocal<CloudDrive> actionDrive = new ThreadLocal();
    protected final Transliterator accentsConverter;
    protected final String rootWorkspace;
    protected final ManageableRepository repository;
    protected final SessionProviderService sessionProviders;
    protected final CloudUser user;
    protected final String rootUUID;
    protected final ThreadLocal<SoftReference<Node>> rootNodeHolder;
    protected final NodeRemoveHandler handler;
    private String titleCached;

    protected JCRLocalCloudDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders) throws CloudDriveException, RepositoryException {
        this.user = user;
        this.sessionProviders = sessionProviders;
        this.accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        Session session = driveNode.getSession();
        this.repository = (ManageableRepository)session.getRepository();
        this.rootWorkspace = session.getWorkspace().getName();
        if (driveNode.isNodeType(ECD_CLOUDDRIVE)) {
            if (driveNode.hasProperty("exo:title")) {
                this.titleCached = driveNode.getProperty("exo:title").getString();
            }
        } else {
            try {
                this.initDrive(driveNode);
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(driveNode);
                throw e;
            }
        }
        this.rootUUID = driveNode.getUUID();
        this.rootNodeHolder = new ThreadLocal();
        this.rootNodeHolder.set(new SoftReference<Node>(driveNode));
        this.handler = this.addJCRListener(driveNode);
    }

    @Override
    public String getTitle() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("exo:title").getString();
    }

    @Override
    public String getLink() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:url").getString();
    }

    @Override
    public String getId() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:id").getString();
    }

    @Override
    public String getLocalUser() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:localUserName").getString();
    }

    @Override
    public Calendar getInitDate() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:initDate").getDate();
    }

    @Override
    public String getPath() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getPath();
    }

    @Override
    public Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException {
        if (this.isConnected()) {
            return this.rootNode().getProperty("ecd:connectDate").getDate();
        }
        throw new NotConnectedException("Drive '" + this.title() + "' not connected.");
    }

    @Override
    public CloudFile getFile(String path) throws DriveRemovedException, NotCloudFileException, RepositoryException {
        Node driveNode = this.rootNode();
        if (path.startsWith(driveNode.getPath())) {
            Item item = driveNode.getSession().getItem(path);
            if (item.isNode()) {
                Node fileNode = this.fileNode((Node)item);
                if (fileNode == null) {
                    throw new NotCloudFileException("Node '" + path + "' is not a Cloud Drive file.");
                }
                return this.readFile(fileNode);
            }
            throw new NotCloudFileException("Item at path '" + path + "' is Property and cannot be read as Cloud Drive file.");
        }
        throw new NotCloudFileException("Item at path '" + path + "' does not belong to Cloud Drive '" + this.title() + "'");
    }

    @Override
    public boolean hasFile(String path) throws DriveRemovedException, RepositoryException {
        Item item;
        Node driveNode = this.rootNode();
        if (path.startsWith(driveNode.getPath()) && (item = driveNode.getSession().getItem(path)).isNode()) {
            return this.fileNode((Node)item) != null;
        }
        return false;
    }

    @Override
    public List<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.listFiles(this.rootNode());
    }

    @Override
    public List<CloudFile> listFiles(CloudFile parent) throws DriveRemovedException, NotCloudFileException, RepositoryException {
        Node driveNode;
        String parentPath = parent.getPath();
        if (parentPath.startsWith((driveNode = this.rootNode()).getPath())) {
            Item item = driveNode.getSession().getItem(parentPath);
            if (item.isNode()) {
                return this.listFiles((Node)item);
            }
            throw new NotCloudFileException("Item at path '" + parentPath + "' is Property and cannot be read as Cloud Drive file.");
        }
        throw new NotCloudFileException("File '" + parentPath + "' does not belong to '" + this.title() + "' Cloud Drive.");
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        Session session = driveNode.getSession();
        driveNode.addMixin(ECD_CLOUDDRIVE);
        if (!driveNode.hasProperty("exo:title")) {
            this.titleCached = this.getUser().getProvider().getName() + " - " + this.getUser().getEmail();
            driveNode.setProperty("exo:title", this.titleCached);
        } else {
            this.titleCached = driveNode.getProperty("exo:title").getString();
        }
        driveNode.setProperty("ecd:connected", false);
        driveNode.setProperty("ecd:localUserName", session.getUserID());
        driveNode.setProperty("ecd:initDate", Calendar.getInstance());
        driveNode.setProperty("ecd:provider", this.getUser().getProvider().getId());
    }

    protected List<CloudFile> listFiles(Node parentNode) throws RepositoryException {
        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
        NodeIterator fileNodes = parentNode.getNodes();
        while (fileNodes.hasNext()) {
            Node fileNode = fileNodes.nextNode();
            if (!fileNode.isNodeType(ECD_CLOUDFILE)) continue;
            JCRLocalCloudFile local = this.readFile(fileNode);
            files.add(local);
            if (!local.isFolder()) continue;
            files.addAll(this.listFiles(fileNode));
        }
        return files;
    }

    @Override
    public CloudDrive.Command connect(boolean async) throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            return ALREADY_DONE;
        }
        ConnectCommand connect = this.getConnectCommand();
        if (async) {
            connect.execAsync();
        } else {
            connect.exec();
        }
        return connect;
    }

    @Override
    public synchronized CloudDrive.Command connect() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.connect(false);
    }

    protected abstract ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException;

    protected abstract SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    protected abstract SyncFileCommand getSyncFileCommand(Node var1) throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    @Override
    protected synchronized void disconnect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            try {
                Node rootNode = this.rootNode();
                try {
                    rootNode.setProperty("ecd:connected", false);
                    NodeIterator niter = rootNode.getNodes();
                    while (niter.hasNext()) {
                        Node existing = niter.nextNode();
                        if (existing.isNodeType(ECD_CLOUDFILE)) {
                            existing.remove();
                            continue;
                        }
                        LOG.warn((Object)("Not a cloud file detected " + existing.getPath() + ". Such files should not be in cloud drive: " + rootNode.getPath() + "."));
                    }
                    rootNode.save();
                    this.listeners.fireOnDisconnect(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootNode.getPath()));
                }
                catch (RepositoryException e) {
                    this.rollback(rootNode);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.rollback(rootNode);
                    throw e;
                }
            }
            catch (ItemNotFoundException e) {
                throw new DriveRemovedException("Drive '" + this.title() + "' was removed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudDrive.Command synchronize(boolean async) throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, CloudDriveAccessException, RepositoryException {
        if (this.isConnected()) {
            this.checkAccess();
            try {
                JCRLocalCloudDrive.startAction(this);
                SyncCommand sync = this.getSyncCommand();
                if (async) {
                    sync.execAsync();
                } else {
                    sync.exec();
                }
                SyncCommand syncCommand = sync;
                return syncCommand;
            }
            finally {
                JCRLocalCloudDrive.doneAction();
            }
        }
        throw new NotConnectedException("Cloud drive '" + this.title() + "' not connected.");
    }

    @Override
    public synchronized CloudDrive.Command synchronize() throws SyncNotSupportedException, CloudDriveException, RepositoryException {
        return this.synchronize(false);
    }

    @Override
    public synchronized CloudDrive.Command synchronize(Node file) throws SyncNotSupportedException, NotConnectedException, CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            String rootPath;
            String filePath = file.getPath();
            if (filePath.equals(rootPath = this.rootNode().getPath())) {
                return this.synchronize();
            }
            if (filePath.startsWith(rootPath)) {
                SyncFileCommand sync = this.getSyncFileCommand(file);
                sync.exec();
                return sync;
            }
            throw new SyncNotSupportedException("Synchronization not supported for not cloud drive file: " + file.getPath());
        }
        throw new NotConnectedException("Cloud drive not connected. Cannot synchronize " + file.getPath());
    }

    @Override
    public boolean isConnected() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:connected").getBoolean();
    }

    @Override
    protected boolean isDrive(Node node, boolean includeFiles) throws DriveRemovedException, RepositoryException {
        Node driveNode = this.rootNode();
        return driveNode.getProperty("ecd:connected").getBoolean() && (driveNode.isSame((Item)node) || includeFiles && node.getPath().startsWith(driveNode.getPath()) && this.fileNode(node) != null);
    }

    protected Node fileNode(Node node) throws RepositoryException {
        Node parent;
        if (node.isNodeType(ECD_CLOUDFILE)) {
            return node;
        }
        if (node.isNodeType(ECD_CLOUDFILERESOURCE) && (parent = node.getParent()).isNodeType(ECD_CLOUDFILE)) {
            return parent;
        }
        return null;
    }

    protected Session session() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        if (sp != null) {
            return sp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Node rootNode() throws DriveRemovedException, RepositoryException {
        Node rootNode;
        SoftReference<Node> rootNodeRef = this.rootNodeHolder.get();
        if (rootNodeRef != null) {
            rootNode = rootNodeRef.get();
            ConversationState cs = ConversationState.getCurrent();
            if (rootNode != null && rootNode.getSession().isLive() && cs != null && rootNode.getSession().getUserID().equals(cs.getIdentity().getUserId())) {
                try {
                    rootNode.refresh(true);
                    return rootNode;
                }
                catch (InvalidItemStateException e) {
                    throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
        }
        Session session = this.session();
        try {
            rootNode = session.getNodeByUUID(this.rootUUID);
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
        }
        this.rootNodeHolder.set(new SoftReference<Node>(rootNode));
        return rootNode;
    }

    protected void rollback(Node rootNode) {
        try {
            rootNode.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Error rolling back the changes on drive '" + this.title() + "': " + e.getMessage()));
        }
    }

    void handleError(Node rootNode, Throwable error, String commandDescription) {
        if (commandDescription.equals("connect")) {
            try {
                this.removeJCRListener(rootNode.getSession());
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error removing observation listener on connect error '" + error.getMessage() + "' " + " on Cloud Drive '" + this.title() + "':" + e.getMessage()));
            }
        }
        this.rollback(rootNode);
        try {
            this.listeners.fireOnError(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootNode.getPath()), error);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error firing error '" + error.getMessage() + "' " + (commandDescription != null ? "of " + commandDescription + " command " : DUMMY_DATA) + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
        }
    }

    void handleError(Node rootNode, Throwable error) {
        this.handleError(rootNode, error, null);
    }

    protected Node openFile(String fileId, String fileTitle, String fileType, Node parent) throws RepositoryException, CloudDriveException {
        boolean newContent;
        Node content;
        Node localNode;
        String title;
        String parentPath = parent.getPath();
        String nodeName = title = this.cleanName(fileTitle);
        int siblingNumber = 1;
        try {
            while (true) {
                String localFileId;
                if (fileId.equals(localFileId = (localNode = parent.getNode(nodeName)).getProperty("ecd:id").getString())) {
                    String existingPath;
                    if (localNode.isNodeType(ECD_CLOUDFILE)) break;
                    try {
                        existingPath = parent.getNode(nodeName).getPath();
                    }
                    catch (RepositoryException e1) {
                        LOG.error((Object)("Cannot read existing non cloud file node from the local storage of cloud drive" + parentPath + ". Node name '" + nodeName + "'"), (Throwable)e1);
                        existingPath = "<" + e1.getMessage() + ">";
                    }
                    throw new CloudDriveException("Error cannecting cloud file '" + fileTitle + "'. Node with the same name exists and it is not a cloud drive file " + existingPath + ". If it's local user file - remove it and refresh the drive.");
                }
                StringBuilder newName = new StringBuilder();
                newName.append(title);
                newName.append('-');
                newName.append(siblingNumber);
                nodeName = newName.toString();
                ++siblingNumber;
            }
        }
        catch (PathNotFoundException e) {
            localNode = null;
        }
        if (localNode == null) {
            localNode = parent.addNode(nodeName, NT_FILE);
            content = localNode.addNode("jcr:content", NT_RESOURCE);
            newContent = true;
        } else {
            try {
                content = localNode.getNode("jcr:content");
                newContent = false;
            }
            catch (PathNotFoundException e) {
                content = localNode.addNode("jcr:content", NT_RESOURCE);
                newContent = true;
            }
        }
        if (newContent) {
            this.setContent(content, fileType);
        }
        return localNode;
    }

    protected Node openFolder(String folderId, String folderTitle, Node parent) throws RepositoryException, CloudDriveException {
        Node localNode;
        String title;
        String parentPath = parent.getPath();
        String nodeName = title = this.cleanName(folderTitle);
        int siblingNumber = 1;
        try {
            while (true) {
                String localFolderId;
                if (folderId.equals(localFolderId = (localNode = parent.getNode(nodeName)).getProperty("ecd:id").getString())) {
                    String existingPath;
                    if (localNode.isNodeType(ECD_CLOUDFOLDER)) break;
                    try {
                        existingPath = parent.getNode(nodeName).getPath();
                    }
                    catch (RepositoryException e1) {
                        LOG.error((Object)("Cannot read existing non cloud folder node from the local storage of cloud drive" + parentPath + ". Node name '" + nodeName + "'"), (Throwable)e1);
                        existingPath = "<" + e1.getMessage() + ">";
                    }
                    throw new CloudDriveException("Error cannecting cloud folder '" + folderTitle + "'. Node with the same name exists and it is not a cloud drive folder " + existingPath + ". If it's local user folder - remove it and refresh the drive.");
                }
                StringBuilder newName = new StringBuilder();
                newName.append(title);
                newName.append('-');
                newName.append(siblingNumber);
                nodeName = newName.toString();
                ++siblingNumber;
            }
        }
        catch (PathNotFoundException e) {
            localNode = parent.addNode(nodeName, NT_FOLDER);
        }
        return localNode;
    }

    protected Node moveNode(Node node, String destName, Node destParent) throws RepositoryException {
        Session session = destParent.getSession();
        String nodeName = this.findNodeName(destName, destParent.getPath(), session);
        String destPath = destParent.getPath() + "/" + nodeName;
        session.move(node.getPath(), destPath);
        return node;
    }

    protected Node copyNode(Node node, Node destParent) throws RepositoryException {
        Node nodeCopy = destParent.addNode(node.getName(), node.getPrimaryNodeType().getName());
        for (NodeType mixin : node.getMixinNodeTypes()) {
            String mixinName = mixin.getName();
            if (nodeCopy.isNodeType(mixinName)) continue;
            nodeCopy.addMixin(mixin.getName());
        }
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property ep = piter.nextProperty();
            PropertyDefinition pdef = ep.getDefinition();
            if (pdef.isProtected()) continue;
            if (pdef.isMultiple()) {
                nodeCopy.setProperty(ep.getName(), ep.getValues());
                continue;
            }
            nodeCopy.setProperty(ep.getName(), ep.getValue());
        }
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            Node ecn = niter.nextNode();
            NodeDefinition ndef = ecn.getDefinition();
            if (ndef.isProtected()) continue;
            this.copyNode(ecn, nodeCopy);
        }
        return nodeCopy;
    }

    protected String findNodeName(String fileTitle, String parentPath, Session session) throws RepositoryException {
        String title;
        String nodeName = title = this.cleanName(fileTitle);
        int siblingNumber = 1;
        while (session.itemExists(parentPath + "/" + nodeName)) {
            StringBuilder newName = new StringBuilder();
            newName.append(title);
            newName.append('-');
            newName.append(siblingNumber);
            nodeName = newName.toString();
            ++siblingNumber;
        }
        return nodeName;
    }

    protected void readNodes(Node parent, Map<String, List<Node>> nodes) throws RepositoryException {
        NodeIterator niter = parent.getNodes();
        while (niter.hasNext()) {
            Node cn = niter.nextNode();
            if (cn.isNodeType(ECD_CLOUDFILE)) {
                String cnid = cn.getProperty("ecd:id").getString();
                List<Node> nodeList = nodes.get(cnid);
                if (nodeList == null) {
                    nodeList = new ArrayList<Node>();
                    nodes.put(cnid, nodeList);
                }
                nodeList.add(cn);
                if (!cn.isNodeType(ECD_CLOUDFOLDER)) continue;
                this.readNodes(cn, nodes);
                continue;
            }
            LOG.warn((Object)("Not a cloud file detected " + cn.getPath()));
        }
    }

    protected JCRLocalCloudFile readFile(Node fileNode) throws RepositoryException {
        String downloadUrl;
        String previewUrl;
        String fileUrl = fileNode.getProperty("ecd:url").getString();
        try {
            previewUrl = fileNode.getProperty("ecd:previewUrl").getString();
        }
        catch (PathNotFoundException e) {
            previewUrl = null;
        }
        try {
            downloadUrl = fileNode.getProperty("ecd:downloadUrl").getString();
        }
        catch (PathNotFoundException e) {
            downloadUrl = null;
        }
        return new JCRLocalCloudFile(fileNode.getPath(), fileNode.getProperty("ecd:id").getString(), fileNode.getProperty("exo:title").getString(), fileUrl, previewUrl, downloadUrl, fileNode.getProperty("ecd:type").getString(), fileNode.getProperty("ecd:lastUser").getString(), fileNode.getProperty("ecd:author").getString(), fileNode.getProperty("ecd:created").getDate(), fileNode.getProperty("ecd:modified").getDate(), fileNode.isNodeType(ECD_CLOUDFOLDER));
    }

    protected void initFile(Node localNode, String title, String id, String type, String link, String previewLink, String downloadLink, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFILE)) {
            localNode.addMixin(ECD_CLOUDFILE);
        }
        this.initCommon(localNode, title, id, type, link, author, lastUser, created, modified);
        Node content = localNode.getNode("jcr:content");
        if (!content.isNodeType(ECD_CLOUDFILERESOURCE)) {
            content.addMixin(ECD_CLOUDFILERESOURCE);
        }
        content.setProperty("jcr:mimeType", type);
        content.setProperty("jcr:lastModified", modified);
        localNode.setProperty("ecd:previewUrl", previewLink);
        localNode.setProperty("ecd:downloadUrl", downloadLink);
    }

    protected void initFolder(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFOLDER)) {
            localNode.addMixin(ECD_CLOUDFOLDER);
        }
        this.initCommon(localNode, id, title, type, link, author, lastUser, created, modified);
    }

    protected void initCommon(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        localNode.setProperty("exo:title", title);
        localNode.setProperty("ecd:id", id);
        localNode.setProperty("ecd:driveUUID", this.rootUUID);
        localNode.setProperty("ecd:type", type);
        localNode.setProperty("ecd:url", link);
        localNode.setProperty("ecd:author", author);
        localNode.setProperty("ecd:lastUser", lastUser);
        localNode.setProperty("ecd:created", created);
        localNode.setProperty("ecd:modified", modified);
        localNode.setProperty("ecd:synchronized", Calendar.getInstance());
        if (localNode.isNodeType(EXO_DATETIME)) {
            localNode.setProperty("exo:dateCreated", created);
            localNode.setProperty("exo:dateModified", modified);
        }
        if (localNode.isNodeType(EXO_MODIFY)) {
            localNode.setProperty("exo:lastModifiedDate", modified);
            localNode.setProperty("exo:lastModifier", lastUser);
        }
    }

    protected void setContent(Node content, String mimetype) throws RepositoryException {
        content.setProperty("jcr:data", DUMMY_DATA);
    }

    protected String cleanName(String str) {
        StringBuffer cleanedStr = new StringBuffer((str = this.accentsConverter.transliterate(str.trim())).trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            for (int i = 0; i < cleanedStr.length(); ++i) {
                char c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || c == ' ' || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
        }
        return cleanedStr.toString();
    }

    @Override
    protected String title() {
        return this.titleCached;
    }

    protected NodeRemoveHandler addJCRListener(Node driveNode) throws RepositoryException {
        NodeRemoveHandler handler = new NodeRemoveHandler(driveNode.getPath());
        ObservationManager observation = driveNode.getSession().getWorkspace().getObservationManager();
        observation.addEventListener((EventListener)handler.removeListener, 2, driveNode.getParent().getPath(), false, null, null, true);
        observation.addEventListener((EventListener)handler.addListener, 1, null, false, null, new String[]{EXO_TRASHFOLDER}, true);
        return handler;
    }

    protected void removeJCRListener(Session session) throws RepositoryException {
        ObservationManager observation = session.getWorkspace().getObservationManager();
        observation.removeEventListener((EventListener)this.handler.removeListener);
        observation.removeEventListener((EventListener)this.handler.addListener);
    }

    protected abstract boolean isSyncSupported(CloudFile var1);

    static void startAction(CloudDrive drive) {
        actionDrive.set(drive);
    }

    static boolean acceptAction(CloudDrive drive) {
        return drive != null && drive != actionDrive.get();
    }

    static void doneAction() {
        actionDrive.remove();
    }

    static /* synthetic */ Log access$1400() {
        return LOG;
    }

    static /* synthetic */ Log access$1500() {
        return LOG;
    }

    protected abstract class SyncFileCommand
    extends AbstractCommand {
        final Node fileNode;
        final boolean isFolder;

        public SyncFileCommand(Node file) throws RepositoryException, DriveRemovedException, SyncNotSupportedException {
            Node parentNode = file.getParent();
            if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILE)) {
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFOLDER)) {
                this.isFolder = true;
            } else if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILERESOURCE)) {
                file = parentNode;
                parentNode = file.getParent();
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.NT_FILE)) {
                String mimeType = file.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.NT_RESOURCE)) {
                String mimeType = file.getProperty("jcr:mimeType").getString();
                file = parentNode;
                parentNode = file.getParent();
                this.isFolder = false;
            } else {
                if (file.isNodeType(JCRLocalCloudDrive.NT_UNSTRUCTURED)) {
                    throw new SyncNotSupportedException("Synchronization not supported for " + file.getPrimaryNodeType().getName() + " node: " + file.getPath());
                }
                throw new SyncNotSupportedException("Synchronization not supported for " + file.getPrimaryNodeType().getName() + " node: " + file.getPath());
            }
            this.fileNode = file;
        }

        @Override
        protected String getCommandVerb() {
            return "file synchronization";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class SyncCommand
    extends AbstractCommand {
        protected Map<String, List<Node>> nodes;
        protected final Set<Node> synced;

        protected SyncCommand() throws RepositoryException, DriveRemovedException {
            this.synced = new HashSet<Node>();
        }

        @Override
        protected String getCommandVerb() {
            return "synchronization";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException {
            this.syncFiles();
            this.driveRoot.save();
            JCRLocalCloudDrive.this.listeners.fireOnSynchronized(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveRoot.getPath()));
        }

        protected abstract void syncFiles() throws CloudDriveException, RepositoryException;

        protected void readLocalNodes() throws RepositoryException {
            LinkedHashMap<String, List<Node>> nodes = new LinkedHashMap<String, List<Node>>();
            String rootId = this.driveRoot.getProperty("ecd:id").getString();
            ArrayList<Node> rootList = new ArrayList<Node>();
            rootList.add(this.driveRoot);
            nodes.put(rootId, rootList);
            JCRLocalCloudDrive.this.readNodes(this.driveRoot, nodes);
            this.nodes = nodes;
        }
    }

    protected abstract class ConnectCommand
    extends AbstractCommand {
        protected ConnectCommand() throws RepositoryException, DriveRemovedException {
        }

        protected abstract void fetchFiles() throws CloudDriveException, RepositoryException;

        @Override
        protected String getCommandVerb() {
            return "connect";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException {
            this.fetchFiles();
            this.driveRoot.setProperty("ecd:cloudUserId", JCRLocalCloudDrive.this.getUser().getId());
            this.driveRoot.setProperty("ecd:cloudUserName", JCRLocalCloudDrive.this.getUser().getUsername());
            this.driveRoot.setProperty("ecd:userEmail", JCRLocalCloudDrive.this.getUser().getEmail());
            this.driveRoot.setProperty("ecd:connectDate", Calendar.getInstance());
            this.driveRoot.setProperty("ecd:connected", true);
            this.driveRoot.save();
            JCRLocalCloudDrive.this.listeners.fireOnConnect(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveRoot.getPath()));
        }
    }

    protected abstract class AbstractCommand
    implements CloudDrive.Command,
    CloudDrive.CommandProgress {
        protected final Queue<CloudFile> result = new ConcurrentLinkedQueue<CloudFile>();
        protected Node driveRoot;
        protected volatile int progressReported;
        protected volatile long startTime;
        protected volatile long finishTime;
        protected CommandRunnable async;

        protected AbstractCommand() throws RepositoryException, DriveRemovedException {
        }

        protected abstract String getCommandVerb();

        protected abstract void process() throws CloudDriveException, RepositoryException;

        /*
         * Exception decompiling
         */
        void exec() throws CloudDriveException, RepositoryException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        void execAsync() throws CloudDriveException {
            ConversationState conversation = ConversationState.getCurrent();
            if (conversation == null) {
                throw new CloudDriveException("Error to " + this.getCommandVerb() + " drive for user " + JCRLocalCloudDrive.this.getUser().getEmail() + ". User identity not set.");
            }
            this.async = new CommandRunnable(this, conversation);
            this.async.start();
        }

        @Override
        public int getProgress() {
            if (this.isDone()) {
                return 100;
            }
            int current = Math.round((float)this.getComplete() * 100.0f / (float)this.getAvailable());
            if (current >= this.progressReported) {
                this.progressReported = current;
            }
            return this.progressReported;
        }

        @Override
        public boolean isDone() {
            return this.finishTime > 0L;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getFinishTime() {
            return this.finishTime;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.unmodifiableCollection(this.result);
        }
    }

    protected class CommandRunnable
    implements Runnable {
        final AbstractCommand command;
        final Thread runner;
        final ConversationState conversation;

        CommandRunnable(AbstractCommand command, ConversationState conversation) throws CloudDriveException {
            this.conversation = conversation;
            this.command = command;
            this.runner = new Thread((Runnable)this, JCRLocalCloudDrive.this.title() + " connect " + DATE_FORMAT.format(Calendar.getInstance().getTime()));
        }

        void start() {
            this.runner.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConversationState.setCurrent((ConversationState)this.conversation);
            SessionProvider sp = new SessionProvider(this.conversation);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, sp);
            try {
                this.command.exec();
            }
            catch (CloudDriveException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getMessage(), e);
            }
            finally {
                sp.close();
            }
        }
    }

    @Deprecated
    class NodeMoveHandler {
        final String initialRootPath;
        final RemoveListener removeListener;
        final AddListener addListener;
        ThreadLocal<List<FileNode>> moved = new ThreadLocal();

        NodeMoveHandler(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveListener();
            this.addListener = new AddListener();
        }

        synchronized void addMoved(String path) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes == null) {
                nodes = new ArrayList<FileNode>();
                this.moved.set(nodes);
            }
            FileNode file = new FileNode();
            file.path = path;
            nodes.add(file);
        }

        synchronized void updateMoved(String path, Node node) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes == null) {
                nodes = new ArrayList<FileNode>();
                this.moved.set(nodes);
            }
            FileNode file = new FileNode();
            file.path = path;
            nodes.add(file);
        }

        synchronized void checkMove(List<Node> added) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes != null) {
                // empty if block
            }
        }

        class AddListener
        implements EventListener {
            AddListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    try {
                        driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.error((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node was removed: " + e.getMessage()));
                        return;
                    }
                    String rootPath = driveRoot.getPath();
                    ArrayList<Node> added = new ArrayList<Node>();
                    while (events.hasNext()) {
                        Item addedItem;
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 1 || event.getPath().startsWith(rootPath) || !(addedItem = driveRoot.getSession().getItem(event.getPath())).isNode()) continue;
                        added.add((Node)addedItem);
                    }
                    if (!added.isEmpty()) {
                        NodeMoveHandler.this.checkMove(added);
                    }
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/add event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class RemoveListener
        implements EventListener {
            RemoveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    try {
                        Node driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.error((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node was removed: " + e.getMessage()));
                        return;
                    }
                    ArrayList<FileNode> nodes = new ArrayList<FileNode>();
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 2 || !event.getPath().startsWith(NodeMoveHandler.this.initialRootPath)) continue;
                        FileNode file = new FileNode();
                        file.path = event.getPath();
                        nodes.add(file);
                    }
                    NodeMoveHandler.this.moved.set(nodes);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/remove event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class FileNode {
            String path;
            String id;
            Node node;

            FileNode() {
            }
        }
    }

    class NodeRemoveHandler {
        final String initialRootPath;
        final RemoveListener removeListener;
        final AddListener addListener;
        volatile boolean removed = false;
        volatile boolean added = false;

        NodeRemoveHandler(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveListener();
            this.addListener = new AddListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void checkRemove(Node driveRoot) throws RepositoryException {
            if (this.removed && this.added && driveRoot.getParent().isNodeType(JCRLocalCloudDrive.EXO_TRASHFOLDER)) {
                Session session = driveRoot.getSession();
                try {
                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                    try {
                        JCRLocalCloudDrive.this.disconnect();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error disconnecting Cloud Drive " + JCRLocalCloudDrive.this.title() + " before its removal. " + e.getMessage()), e);
                    }
                    this.finishRemove(session, driveRoot.getPath());
                }
                finally {
                    driveRoot.remove();
                    session.save();
                    JCRLocalCloudDrive.doneAction();
                    LOG.info((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " successfully removed from the Trash."));
                }
            }
        }

        void finishRemove(Session session, String rootPath) {
            this.added = false;
            this.removed = false;
            try {
                JCRLocalCloudDrive.this.removeJCRListener(session);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error unregistering Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node listeners: " + e.getMessage()), (Throwable)e);
            }
            JCRLocalCloudDrive.this.listeners.fireOnRemove(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, rootPath));
        }

        class AddListener
        implements EventListener {
            AddListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    try {
                        driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                        NodeRemoveHandler.this.finishRemove(JCRLocalCloudDrive.this.session(), NodeRemoveHandler.this.initialRootPath);
                        return;
                    }
                    String rootPath = driveRoot.getPath();
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 1 || !rootPath.equals(event.getPath())) continue;
                        NodeRemoveHandler.this.added = true;
                    }
                    NodeRemoveHandler.this.checkRemove(driveRoot);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/add event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class RemoveListener
        implements EventListener {
            RemoveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    try {
                        driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node already removed directly from JCR: " + e.getMessage()));
                        NodeRemoveHandler.this.finishRemove(JCRLocalCloudDrive.this.session(), NodeRemoveHandler.this.initialRootPath);
                        return;
                    }
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 2 || !NodeRemoveHandler.this.initialRootPath.equals(event.getPath())) continue;
                        NodeRemoveHandler.this.removed = true;
                    }
                    NodeRemoveHandler.this.checkRemove(driveRoot);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node move/remove event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    class BufferedNodeIterator
    implements NodeIterator {
        final List<Node> buff = new ArrayList<Node>();
        NodeIterator nodes;
        int buffPos = 0;

        BufferedNodeIterator(NodeIterator nodes) {
            this.nodes = nodes;
        }

        public void skip(long skipNum) {
            if (this.nodes != null) {
                int i = 0;
                while ((long)i < skipNum) {
                    this.buff.add(this.nodes.nextNode());
                    ++i;
                }
            } else {
                this.buffPos = (int)((long)this.buffPos + skipNum);
            }
        }

        public long getSize() {
            if (this.nodes != null) {
                return this.nodes.getSize();
            }
            return this.buff.size();
        }

        public long getPosition() {
            if (this.nodes != null) {
                return this.nodes.getPosition();
            }
            return this.buffPos;
        }

        public boolean hasNext() {
            if (this.nodes != null) {
                return this.nodes.hasNext();
            }
            return this.buffPos < this.buff.size() - 1;
        }

        public Object next() {
            return this.nextNode();
        }

        public Node nextNode() {
            if (this.nodes != null) {
                Node n = this.nodes.nextNode();
                this.buff.add(n);
                if (!this.nodes.hasNext()) {
                    this.nodes = null;
                }
                return n;
            }
            if (this.buffPos == this.buff.size()) {
                throw new NoSuchElementException("Buffer has no more Nodes.");
            }
            Node n = this.buff.get(this.buffPos);
            ++this.buffPos;
            return n;
        }

        public void remove() {
            if (this.nodes != null) {
                this.nodes.remove();
            } else {
                if (this.buffPos == this.buff.size()) {
                    throw new IllegalStateException("End of the buffer reached.");
                }
                this.buff.remove(this.buffPos);
            }
        }

        void reset() {
            this.buffPos = 0;
        }
    }

    static class AlreadyDone
    implements CloudDrive.Command {
        final long time = System.currentTimeMillis();

        AlreadyDone() {
        }

        @Override
        public int getProgress() {
            return 100;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public long getStartTime() {
            return this.time;
        }

        @Override
        public long getFinishTime() {
            return this.time;
        }
    }
}

