/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.jcr.JCRNodeFinder;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.rest.DriveInfo;
import org.exoplatform.clouddrive.rest.LinkedCloudFile;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/drive")
@Produces(value={"application/json"})
public class DriveService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(DriveService.class);
    protected static final String CONTENT_SUFIX = "/jcr:content";
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeFinder finder;

    public DriveService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
    }

    public DriveService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = new JCRNodeFinder(jcrService);
    }

    @GET
    @RolesAllowed(value={"users"})
    public Response getDrive(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                return this.readDrive(workspace, path, false);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    @POST
    @Path(value="/synchronize/")
    @RolesAllowed(value={"users"})
    public Response synchronize(@Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                return this.readDrive(workspace, path, true);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected Response readDrive(String workspace, String path, boolean synchronize) {
        try {
            SessionProvider sp = this.sessionProviders.getSessionProvider(null);
            Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
            try {
                Item item = this.finder.getItem(userSession, path, true);
                if (item.isNode()) {
                    Node userNode = (Node)item;
                    CloudDrive local = this.cloudDrives.findDrive(userNode);
                    if (local != null) {
                        Collection<CloudFile> files;
                        if (synchronize) {
                            try {
                                files = local.synchronize().getFiles();
                            }
                            catch (CloudDriveAccessException e) {
                                LOG.warn((Object)"Request to cloud drive forbidden or revoked.", (Throwable)e);
                                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)local.getUser().getProvider()).build();
                                userSession.logout();
                                return response;
                            }
                            catch (CloudDriveException e) {
                                LOG.error((Object)("Error synchronizing drive " + workspace + ":" + path), (Throwable)e);
                                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error synchronizing drive. " + e.getMessage())).build();
                                userSession.logout();
                                return response;
                            }
                        }
                        files = new ArrayList<CloudFile>();
                        try {
                            String userPath = userNode.getPath();
                            if (!local.getPath().equals(userPath)) {
                                CloudFile file = local.getFile(userPath);
                                files.add(file);
                                if (!file.getPath().equals(path)) {
                                    files.add(new LinkedCloudFile(file, path));
                                }
                            }
                        }
                        catch (NotCloudFileException e) {
                            LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file : " + e.getMessage()));
                            Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                            userSession.logout();
                            return response;
                        }
                        Response response = Response.ok().entity((Object)DriveInfo.create(local, files)).build();
                        return response;
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                    Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                    return response;
                }
                LOG.warn((Object)("Item " + workspace + ":" + path + " not a node."));
                Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Not a node.").build();
                return response;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                userSession.logout();
            }
        }
        catch (LoginException e) {
            LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
        }
        catch (DriveRemovedException e) {
            LOG.error((Object)("Drive removed " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Drive removed.").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
        }
    }

    @GET
    @Path(value="/file/")
    @RolesAllowed(value={"users"})
    public Response getFile(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace != null) {
            if (path != null) {
                try {
                    SessionProvider sp = this.sessionProviders.getSessionProvider(null);
                    Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
                    Item item = this.finder.getItem(userSession, path, true);
                    if (item.isNode()) {
                        Node userNode = (Node)item;
                        CloudDrive local = this.cloudDrives.findDrive(userNode);
                        if (local != null) {
                            try {
                                CloudFile file = local.getFile(userNode.getPath());
                                if (!file.getPath().equals(path)) {
                                    file = new LinkedCloudFile(file, path);
                                }
                                return Response.ok().entity((Object)file).build();
                            }
                            catch (NotCloudFileException e) {
                                LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file: " + e.getMessage()));
                            }
                        }
                        LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                    }
                    LOG.warn((Object)("Item " + workspace + ":" + path + " not a node."));
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Not a node.").build();
                }
                catch (LoginException e) {
                    LOG.warn((Object)("Error login to read drive file " + workspace + ":" + path + ": " + e.getMessage()));
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
                }
                catch (CloudDriveException e) {
                    LOG.warn((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error reading file. " + e.getMessage())).build();
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: storage error.").build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading file " + workspace + ":" + path), e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading file: runtime error.").build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
    }
}

