/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.util.Data;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;

public class BearerToken {
    static final String PARAM_NAME = "access_token";

    public static Credential.AccessMethod authorizationHeaderAccessMethod() {
        return new AuthorizationHeaderAccessMethod();
    }

    public static Credential.AccessMethod formEncodedBodyAccessMethod() {
        return new FormEncodedBodyAccessMethod();
    }

    public static Credential.AccessMethod queryParameterAccessMethod() {
        return new QueryParameterAccessMethod();
    }

    static final class QueryParameterAccessMethod
    implements Credential.AccessMethod {
        QueryParameterAccessMethod() {
        }

        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getUrl().set(BearerToken.PARAM_NAME, accessToken);
        }

        public String getAccessTokenFromRequest(HttpRequest request) {
            Object param = request.getUrl().get(BearerToken.PARAM_NAME);
            return param == null ? null : param.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FormEncodedBodyAccessMethod
    implements Credential.AccessMethod {
        FormEncodedBodyAccessMethod() {
        }

        @Override
        public void intercept(HttpRequest request, String accessToken) throws IOException {
            Preconditions.checkArgument((request.getMethod() != HttpMethod.GET ? 1 : 0) != 0, (Object)"HTTP GET method is not supported");
            FormEncodedBodyAccessMethod.getData(request).put(BearerToken.PARAM_NAME, accessToken);
        }

        @Override
        public String getAccessTokenFromRequest(HttpRequest request) {
            Object bodyParam = FormEncodedBodyAccessMethod.getData(request).get(BearerToken.PARAM_NAME);
            return bodyParam == null ? null : bodyParam.toString();
        }

        private static Map<String, Object> getData(HttpRequest request) {
            return Data.mapOf(UrlEncodedContent.getContent(request).getData());
        }
    }

    static final class AuthorizationHeaderAccessMethod
    implements Credential.AccessMethod {
        static final String HEADER_PREFIX = "Bearer ";

        AuthorizationHeaderAccessMethod() {
        }

        public void intercept(HttpRequest request, String accessToken) throws IOException {
            request.getHeaders().setAuthorization(HEADER_PREFIX + accessToken);
        }

        public String getAccessTokenFromRequest(HttpRequest request) {
            String header = request.getHeaders().getAuthorization();
            if (header != null && header.startsWith(HEADER_PREFIX)) {
                return header.substring(HEADER_PREFIX.length());
            }
            return null;
        }
    }
}

