/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveListener;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class CloudDrive {
    protected static final Log LOG = ExoLogger.getLogger(CloudDrive.class);
    protected final ListenerSupport listeners = new ListenerSupport();

    public String toString() {
        return this.title() + " " + super.toString();
    }

    public void addListener(CloudDriveListener listener) {
        if (!this.listeners.registry.contains(listener)) {
            this.listeners.registry.add(listener);
        }
    }

    public void removeListener(CloudDriveListener listener) {
        this.listeners.registry.remove(listener);
    }

    public abstract CloudUser getUser();

    public abstract String getTitle() throws DriveRemovedException, RepositoryException;

    public abstract String getLink() throws DriveRemovedException, RepositoryException;

    public abstract String getLocalUser() throws DriveRemovedException, RepositoryException;

    public abstract Calendar getInitDate() throws DriveRemovedException, RepositoryException;

    public abstract Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException;

    public abstract String getPath() throws DriveRemovedException, RepositoryException;

    public abstract String getId() throws DriveRemovedException, RepositoryException;

    public abstract CloudFile getFile(String var1) throws DriveRemovedException, NotCloudFileException, RepositoryException;

    public abstract boolean hasFile(String var1) throws DriveRemovedException, RepositoryException;

    public abstract List<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException;

    public abstract List<CloudFile> listFiles(CloudFile var1) throws DriveRemovedException, CloudDriveException, RepositoryException;

    public abstract Command connect(boolean var1) throws CloudDriveException, RepositoryException;

    public abstract Command connect() throws CloudDriveException, RepositoryException;

    public abstract Command synchronize(boolean var1) throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, CloudDriveAccessException, RepositoryException;

    public abstract Command synchronize() throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, CloudDriveAccessException, RepositoryException;

    public abstract Command synchronize(Node var1) throws SyncNotSupportedException, DriveRemovedException, NotConnectedException, CloudDriveException, RepositoryException;

    public abstract boolean isConnected() throws DriveRemovedException, RepositoryException;

    protected abstract boolean isDrive(Node var1, boolean var2) throws DriveRemovedException, RepositoryException;

    protected abstract void disconnect() throws DriveRemovedException, CloudDriveException, RepositoryException;

    protected abstract void checkAccess() throws CloudDriveException;

    protected abstract void updateAccessKey(CloudUser var1) throws CloudDriveException, RepositoryException;

    protected abstract String title();

    protected class ListenerSupport {
        Queue<CloudDriveListener> registry = new ConcurrentLinkedQueue<CloudDriveListener>();

        protected ListenerSupport() {
        }

        public void fireOnConnect(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onConnect(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onConnect listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnDisconnect(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onDisconnect(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onDisconnect listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnRemove(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onRemove(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onRemove listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnSynchronized(CloudDriveEvent event) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onSynchronized(event);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onSynchronized listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void fireOnError(CloudDriveEvent event, Throwable error) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    listener.onError(event, error);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error firing onError listener about '" + error.getMessage() + "' on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void invokeOnNew(CloudFile file) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    CloudDriveListener.FileChangeAction action = listener.getFileChangeAction();
                    if (action == null) continue;
                    action.onNew(file);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error calling onNew action of listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void invokeOnDelete(CloudFile file) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    CloudDriveListener.FileChangeAction action = listener.getFileChangeAction();
                    if (action == null) continue;
                    action.onRemove(file);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error calling onDelete action of listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void invokeOnUpdate(CloudFile prevFile, CloudFile newFile) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    CloudDriveListener.FileChangeAction action = listener.getFileChangeAction();
                    if (action == null) continue;
                    action.onUpdate(prevFile, newFile);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error calling onUpdate action of listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }

        public void invokeOnContent(CloudFile file) {
            for (CloudDriveListener listener : this.registry) {
                try {
                    CloudDriveListener.FileChangeAction action = listener.getFileChangeAction();
                    if (action == null) continue;
                    action.onContent(file);
                }
                catch (Throwable th) {
                    LOG.warn((Object)("Error calling onContent action of listener on Cloud Drive '" + CloudDrive.this.title() + "': " + th.getMessage()), th);
                }
            }
        }
    }

    protected static interface CommandProgress {
        public int getComplete();

        public int getAvailable();
    }

    public static interface Command {
        public static final int COMPLETE = 100;

        public int getProgress();

        public boolean isDone();

        public long getStartTime();

        public long getFinishTime();

        public Collection<CloudFile> getFiles();
    }
}

