/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.DriveRemovedException;

public class DriveInfo {
    final CloudProvider provider;
    final Map<String, CloudFile> files;
    final String path;
    final String user;
    final String email;
    final String title;
    final boolean connected;

    DriveInfo(String title, String path, String user, String email, boolean connected, CloudProvider provider, Map<String, CloudFile> files) {
        this.title = title;
        this.path = path;
        this.user = user;
        this.email = email;
        this.connected = connected;
        this.provider = provider;
        this.files = files;
    }

    static DriveInfo create(CloudDrive drive, Collection<CloudFile> files) throws DriveRemovedException, RepositoryException {
        HashMap<String, CloudFile> driveFiles = new HashMap<String, CloudFile>();
        for (CloudFile cf : files) {
            driveFiles.put(cf.getPath(), cf);
        }
        return new DriveInfo(drive.getTitle(), drive.getPath(), drive.getUser().getUsername(), drive.getUser().getEmail(), drive.isConnected(), drive.getUser().getProvider(), driveFiles);
    }

    static DriveInfo create(CloudDrive drive) throws DriveRemovedException, RepositoryException {
        return DriveInfo.create(drive, new ArrayList<CloudFile>());
    }

    public CloudProvider getProvider() {
        return this.provider;
    }

    public Map<String, CloudFile> getFiles() {
        return this.files;
    }

    public String getPath() {
        return this.path;
    }

    public String getUser() {
        return this.user;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

