/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ByteCountingOutputStream;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class AbstractHttpContent
implements HttpContent {
    private HttpMediaType mediaType;
    private long computedLength = -1L;

    @Deprecated
    protected AbstractHttpContent() {
    }

    protected AbstractHttpContent(String mediaType) {
        this(mediaType == null ? null : new HttpMediaType(mediaType));
    }

    protected AbstractHttpContent(HttpMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() throws IOException {
        if (this.computedLength == -1L) {
            this.computedLength = this.computeLength();
        }
        return this.computedLength;
    }

    public final HttpMediaType getMediaType() {
        return this.mediaType;
    }

    public AbstractHttpContent setMediaType(HttpMediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    protected final Charset getCharset() {
        return this.mediaType == null || this.mediaType.getCharsetParameter() == null ? Charsets.UTF_8 : this.mediaType.getCharsetParameter();
    }

    public String getType() {
        return this.mediaType == null ? null : this.mediaType.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeLength() throws IOException {
        if (!this.retrySupported()) {
            return -1L;
        }
        ByteCountingOutputStream countingStream = new ByteCountingOutputStream();
        try {
            this.writeTo(countingStream);
        }
        finally {
            countingStream.close();
        }
        return countingStream.count;
    }

    public boolean retrySupported() {
        return true;
    }
}

