/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.resourcemanagers;

import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxServerError;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.boxjavalibv2.exceptions.BoxServerException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedHttpStatusException;
import com.box.boxjavalibv2.exceptions.BoxUnexpectedStatus;
import com.box.boxjavalibv2.interfaces.IBoxJSONParser;
import com.box.boxjavalibv2.interfaces.IBoxResourceHub;
import com.box.boxjavalibv2.responseparsers.BoxObjectResponseParser;
import com.box.boxjavalibv2.responseparsers.ErrorResponseParser;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxConfig;
import com.box.restclientv2.interfaces.IBoxRESTClient;
import com.box.restclientv2.interfaces.IBoxRequestAuth;
import com.box.restclientv2.requests.DefaultBoxRequest;
import com.box.restclientv2.responses.DefaultBoxResponse;

public abstract class BoxResourceManager {
    private final IBoxConfig mConfig;
    private final IBoxResourceHub mResourceHub;
    private final IBoxJSONParser mParser;
    private final IBoxRequestAuth mAuth;
    private final IBoxRESTClient mRestClient;

    public BoxResourceManager(IBoxConfig config, IBoxResourceHub resourceHub, IBoxJSONParser parser, IBoxRequestAuth auth, IBoxRESTClient restClient) {
        this.mConfig = config;
        this.mResourceHub = resourceHub;
        this.mParser = parser;
        this.mAuth = auth;
        this.mRestClient = restClient;
    }

    public IBoxRequestAuth getAuth() {
        return this.mAuth;
    }

    IBoxRESTClient getRestClient() {
        return this.mRestClient;
    }

    public IBoxResourceHub getResourceHub() {
        return this.mResourceHub;
    }

    public IBoxJSONParser getJSONParser() {
        return this.mParser;
    }

    public IBoxConfig getConfig() {
        return this.mConfig;
    }

    protected void executeRequestWithNoResponseBody(DefaultBoxRequest request) throws BoxServerException, BoxRestException, AuthFatalFailureException {
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        if (response.getExpectedResponseCode() != response.getResponseStatusCode()) {
            ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
            BoxServerError error = (BoxServerError)errorParser.parse(response);
            if (error == null) {
                throw new BoxServerException("Unexpected response code:" + response.getResponseStatusCode() + ", expecting:" + response.getExpectedResponseCode(), response.getResponseStatusCode());
            }
            throw new BoxServerException(error);
        }
    }

    public Object getResponseAndParseAndTryCast(DefaultBoxRequest request, BoxResourceType type, IBoxJSONParser parser) throws BoxRestException, AuthFatalFailureException, BoxServerException {
        Object obj = this.getResponseAndParse(request, type, parser);
        return this.tryCastObject(type, obj);
    }

    public Object getResponseAndParse(DefaultBoxRequest request, BoxResourceType type, IBoxJSONParser parser) throws BoxRestException, AuthFatalFailureException {
        request.setAuth(this.getAuth());
        DefaultBoxResponse response = (DefaultBoxResponse)this.getRestClient().execute(request);
        BoxObjectResponseParser responseParser = new BoxObjectResponseParser(this.getResourceHub().getClass(type), parser);
        ErrorResponseParser errorParser = new ErrorResponseParser(this.getJSONParser());
        return response.parseResponse(responseParser, errorParser);
    }

    protected Object tryCastBoxItem(BoxResourceType type, Object item) throws BoxServerException, BoxRestException {
        return this.tryCastObject(type, item);
    }

    public Object tryCastObject(BoxResourceType expectedType, Object obj) throws BoxServerException, BoxRestException {
        if (obj instanceof BoxServerError) {
            throw new BoxServerException((BoxServerError)obj);
        }
        if (obj instanceof BoxUnexpectedStatus) {
            throw new BoxUnexpectedHttpStatusException((BoxUnexpectedStatus)obj);
        }
        Class expectedClass = this.getResourceHub().getClass(expectedType);
        if (expectedClass.isInstance(obj)) {
            return obj;
        }
        if (obj == null) {
            throw new BoxRestException("Invalid class, expected:" + expectedClass.getCanonicalName());
        }
        throw new BoxRestException("Invalid class, expected:" + expectedClass.getCanonicalName() + ";current:" + obj.getClass().getCanonicalName());
    }
}

