/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.exoplatform.clouddrive.BaseCloudDriveListener;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveConnector;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.UserAlreadyConnectedException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.picocontainer.Startable;

public class CloudDriveServiceImpl
implements CloudDriveService,
Startable {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveService.class);
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final Map<CloudProvider, CloudDriveConnector> connectors = new HashMap<CloudProvider, CloudDriveConnector>();
    protected final Map<String, Map<CloudUser, CloudDrive>> repositoryDrives = new ConcurrentHashMap<String, Map<CloudUser, CloudDrive>>();
    protected final Map<CloudUser, Map<CloudUser, CloudDrive>> userDrives = new ConcurrentHashMap<CloudUser, Map<CloudUser, CloudDrive>>();
    protected final LocalDrivesListener drivesListener;

    public CloudDriveServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders) {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.drivesListener = new LocalDrivesListener();
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CloudDriveConnector) {
            CloudDriveConnector impl = (CloudDriveConnector)plugin;
            this.connectors.put(impl.getProvider(), impl);
        } else {
            LOG.warn((Object)("Cannot recognize component plugin for " + plugin.getName() + ": type " + plugin.getClass() + " not supported"));
        }
    }

    @Override
    public CloudProvider getProvider(String id) throws ProviderNotAvailableException {
        for (CloudProvider p : this.connectors.keySet()) {
            if (!p.getId().equals(id)) continue;
            return p;
        }
        throw new ProviderNotAvailableException("No such provider '" + id + "'");
    }

    @Override
    public CloudDrive findDrive(Node node) throws RepositoryException {
        String repoName;
        Map<CloudUser, CloudDrive> drives;
        ConversationState convState = ConversationState.getCurrent();
        if (convState != null && convState.getIdentity().getUserId().equals(node.getSession().getUserID()) && (drives = this.repositoryDrives.get(repoName = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName())) != null) {
            for (CloudDrive local : drives.values()) {
                try {
                    if (!local.isDrive(node, true)) continue;
                    return local;
                }
                catch (AccessDeniedException e) {
                }
                catch (DriveRemovedException e) {
                }
            }
        }
        return null;
    }

    @Override
    public boolean isDrive(Node node) throws RepositoryException {
        String repoName;
        Map<CloudUser, CloudDrive> drives;
        ConversationState convState = ConversationState.getCurrent();
        if (convState != null && convState.getIdentity().getUserId().equals(node.getSession().getUserID()) && (drives = this.repositoryDrives.get(repoName = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName())) != null) {
            for (CloudDrive local : drives.values()) {
                try {
                    if (!local.isDrive(node, false)) continue;
                    return true;
                }
                catch (AccessDeniedException e) {
                }
                catch (DriveRemovedException e) {
                }
            }
        }
        return false;
    }

    @Override
    public CloudUser authenticate(CloudProvider cloudProvider, String key) throws ProviderNotAvailableException, CloudDriveException {
        CloudDriveConnector conn = this.connectors.get(cloudProvider);
        if (conn != null) {
            return conn.authenticate(key);
        }
        throw new ProviderNotAvailableException("Provider not available " + cloudProvider.getName());
    }

    @Override
    public CloudDrive createDrive(CloudUser user, Node driveNode) throws UserAlreadyConnectedException, ProviderNotAvailableException, CloudDriveException, RepositoryException {
        CloudDriveConnector conn;
        CloudDrive local;
        String repoName = ((ManageableRepository)driveNode.getSession().getRepository()).getConfiguration().getName();
        Map<CloudUser, CloudDrive> drives = this.repositoryDrives.get(repoName);
        if (drives != null && (local = drives.get(user)) != null) {
            try {
                String localPath = local.getPath();
                if (localPath.equals(driveNode.getPath())) {
                    if (local.isConnected()) {
                        local.updateAccess(user);
                    }
                    return local;
                }
                LOG.warn((Object)("User " + user.getEmail() + " already connected to another node " + localPath));
                throw new UserAlreadyConnectedException("User " + user.getEmail() + " already connected to another node " + localPath);
            }
            catch (DriveRemovedException e) {
            }
            catch (AccessDeniedException e) {
                LOG.warn((Object)("User " + user.getEmail() + " already connected to another node"), (Throwable)e);
                throw new UserAlreadyConnectedException("User " + user.getEmail() + " already connected to another node.");
            }
        }
        if ((conn = this.connectors.get(user.getProvider())) != null) {
            CloudDrive local2 = conn.createDrive(user, driveNode);
            this.registerDrive(user, local2, repoName);
            return local2;
        }
        throw new ProviderNotAvailableException("Provider not available " + user.getProvider().getName());
    }

    @Override
    public Set<CloudProvider> getProviders() {
        return Collections.unmodifiableSet(this.connectors.keySet());
    }

    public void start() {
        try {
            this.loadConnected(this.jcrService.getCurrentRepository());
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error reading current repository: " + e.getMessage()));
            throw new RuntimeException("Error loading connected drives: cannot read current repository", e);
        }
        LOG.info((Object)"Cloud Drive service successfuly started");
    }

    public void stop() {
        this.repositoryDrives.clear();
        this.userDrives.clear();
        LOG.info((Object)"Cloud Drive service successfuly stopped");
    }

    protected void registerDrive(CloudUser user, CloudDrive drive, String repoName) {
        Map<CloudUser, CloudDrive> drives = this.repositoryDrives.get(repoName);
        if (drives == null) {
            drives = new ConcurrentHashMap<CloudUser, CloudDrive>();
            this.repositoryDrives.put(repoName, drives);
            this.userDrives.put(user, drives);
        }
        drives.put(user, drive);
        drive.addListener(this.drivesListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConnected(ManageableRepository jcrRepository) {
        SessionProvider spOrig = this.sessionProviders.getSessionProvider(null);
        SessionProvider sp = SessionProvider.createSystemProvider();
        this.sessionProviders.setSessionProvider(null, sp);
        try {
            for (WorkspaceEntry w : jcrRepository.getConfiguration().getWorkspaceEntries()) {
                try {
                    HashMap<CloudProvider, HashSet<Node>> repoDrives = new HashMap<CloudProvider, HashSet<Node>>();
                    Session session = sp.getSession(w.getName(), jcrRepository);
                    try {
                        Query q = session.getWorkspace().getQueryManager().createQuery("select * from ecd:cloudDrive", "sql");
                        NodeIterator r = q.execute().getNodes();
                        while (r.hasNext()) {
                            Node drive = r.nextNode();
                            if (!drive.getProperty("ecd:connected").getBoolean()) continue;
                            String providerId = drive.getProperty("ecd:provider").getString();
                            try {
                                CloudProvider provider = this.getProvider(providerId);
                                HashSet<Node> driveNodes = (HashSet<Node>)repoDrives.get(provider);
                                if (driveNodes == null) {
                                    driveNodes = new HashSet<Node>();
                                    repoDrives.put(provider, driveNodes);
                                }
                                driveNodes.add(drive);
                            }
                            catch (CloudDriveException e) {
                                LOG.error((Object)("Error loading stored drive " + drive.getPath() + ": " + e.getMessage()), (Throwable)e);
                            }
                        }
                        for (Map.Entry pd : repoDrives.entrySet()) {
                            CloudDriveConnector conn = this.connectors.get(pd.getKey());
                            try {
                                Set<CloudDrive> locals = conn.loadStored((Set)pd.getValue());
                                for (CloudDrive local : locals) {
                                    if (!local.isConnected()) continue;
                                    CloudUser user = local.getUser();
                                    String repoName = jcrRepository.getConfiguration().getName();
                                    this.registerDrive(user, local, repoName);
                                }
                            }
                            catch (CloudDriveException e) {
                                LOG.error((Object)("Error loading stored drive for " + ((CloudProvider)pd.getKey()).getName() + ": " + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Search error on " + w.getName() + "@" + jcrRepository.getConfiguration().getName()), (Throwable)e);
                    }
                    finally {
                        session.logout();
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("System session error on " + w.getName() + "@" + jcrRepository.getConfiguration().getName()), (Throwable)e);
                }
            }
        }
        finally {
            try {
                sp.close();
            }
            catch (IllegalStateException e) {
                LOG.warn((Object)("Unexpectedly session provider already closed: " + e.getMessage()));
            }
            this.sessionProviders.setSessionProvider(null, spOrig);
        }
    }

    class LocalDrivesListener
    extends BaseCloudDriveListener {
        LocalDrivesListener() {
        }

        void cleanUserCaches(CloudUser user) {
            Map<CloudUser, CloudDrive> drives = CloudDriveServiceImpl.this.userDrives.get(user);
            if (drives != null) {
                drives.remove(user);
            }
        }

        @Override
        public void onRemove(CloudDriveEvent event) {
            this.cleanUserCaches(event.getUser());
        }

        @Override
        public void onDisconnect(CloudDriveEvent event) {
            this.cleanUserCaches(event.getUser());
        }

        @Override
        public void onError(CloudDriveEvent event, Throwable error) {
        }
    }
}

