/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.googledrive;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.About;
import com.google.api.services.drive.model.Change;
import com.google.api.services.drive.model.ChangeList;
import com.google.api.services.drive.model.ChildList;
import com.google.api.services.drive.model.ChildReference;
import com.google.api.services.drive.model.File;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.googledrive.GoogleDriveException;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class GoogleDriveAPI {
    public static final String FOLDER_MIMETYPE = "application/vnd.google-apps.folder";
    public static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive.readonly", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/userinfo.profile");
    public static final String SCOPES_STRING = GoogleDriveAPI.scopes();
    public static final String ACCESS_TYPE = "offline";
    public static final String APPOVAl_PROMT = "force";
    public static final String NO_STATE = "__no_state_set__";
    protected static final Log LOG = ExoLogger.getLogger(GoogleDriveAPI.class);
    final Credential credential;
    final Drive drive;
    final Oauth2 oauth2;

    GoogleDriveAPI(String clientId, String clientSecret, String authCode, String redirectUri) throws GoogleDriveException, CloudDriveException {
        GoogleTokenResponse response;
        GoogleAuthorizationCodeFlow authFlow = this.createFlow(clientId, clientSecret, new UserCredentialStore());
        try {
            response = authFlow.newTokenRequest(authCode).setRedirectUri(redirectUri).execute();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error authenticating user code: " + e.getMessage(), e);
        }
        try {
            this.credential = authFlow.createAndStoreCredential((TokenResponse)response, authCode);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error storing user credential: " + e.getMessage(), e);
        }
        this.drive = new Drive.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).build();
        this.oauth2 = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).build();
    }

    GoogleDriveAPI(String clientId, String clientSecret, String userId, String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        GoogleAuthorizationCodeFlow authFlow = this.createFlow(clientId, clientSecret, new UserCredentialStore(userId, accessToken, refreshToken, expirationTime));
        try {
            this.credential = authFlow.loadCredential(userId);
        }
        catch (IOException e) {
            throw new CloudDriveException("Error loading Google user credentials: " + e.getMessage(), e);
        }
        this.drive = new Drive.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).build();
        this.oauth2 = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)this.credential).build();
    }

    private static String scopes() {
        StringBuilder s = new StringBuilder();
        for (String scope : SCOPES) {
            s.append(scope);
            s.append('+');
        }
        return s.toString();
    }

    GoogleAuthorizationCodeFlow createFlow(String clientId, String clientSecret, CredentialStore tokenStore) {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GoogleAuthorizationCodeFlow.Builder builder = new GoogleAuthorizationCodeFlow.Builder((HttpTransport)httpTransport, (JsonFactory)jsonFactory, clientId, clientSecret, SCOPES);
        builder.setAccessType(ACCESS_TYPE).setApprovalPrompt(APPOVAl_PROMT);
        if (tokenStore != null) {
            builder.setCredentialStore(tokenStore);
        }
        return builder.build();
    }

    void setRefreshToken(String refreshToken) {
        this.credential.setRefreshToken(refreshToken);
    }

    Userinfo userInfo() throws GoogleDriveException, CloudDriveException {
        Userinfo userInfo;
        try {
            userInfo = (Userinfo)this.oauth2.userinfo().get().execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError error = e.getDetails();
            throw new GoogleDriveException("Authentication error: " + error.getMessage() + " (" + error.getCode() + ").", e);
        }
        catch (HttpResponseException e) {
            throw new GoogleDriveException("Authentication error: " + e.getMessage() + " (" + e.getStatusCode() + ").", e);
        }
        catch (IOException e) {
            throw new GoogleDriveException("Authentication error: " + e.getMessage(), e);
        }
        if (userInfo != null && userInfo.getId() != null) {
            return userInfo;
        }
        throw new CloudDriveException("User ID cannot be retrieved.");
    }

    About about() throws GoogleDriveException {
        try {
            return (About)this.drive.about().get().execute();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting About service: " + e.getMessage(), e);
        }
    }

    ChildIterator children(String fileId) throws GoogleDriveException {
        return new ChildIterator(fileId);
    }

    ChangesIterator changes(long startChangeId) throws GoogleDriveException {
        return new ChangesIterator(startChangeId);
    }

    File file(String fileId) throws GoogleDriveException {
        try {
            return (File)this.drive.files().get(fileId).execute();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error requesting Files service: " + e.getMessage(), e);
        }
    }

    void checkAccess() throws GoogleDriveException {
        Long expirationTime = this.credential.getExpiresInSeconds();
        if (expirationTime != null && expirationTime < 0L) {
            try {
                this.credential.refreshToken();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error refreshing access token: " + e.getMessage(), e);
            }
        }
    }

    void updateToken(GoogleDriveAPI refreshApi) throws GoogleDriveException {
        this.credential.setRefreshToken(refreshApi.credential.getRefreshToken());
        try {
            this.credential.refreshToken();
        }
        catch (IOException e) {
            throw new GoogleDriveException("Error updating access token: " + e.getMessage(), e);
        }
    }

    String getAccessToken() {
        return this.credential.getAccessToken();
    }

    String getRefreshToken() {
        return this.credential.getRefreshToken();
    }

    long getExpirationTime() {
        return this.credential.getExpirationTimeMilliseconds();
    }

    boolean isFolder(File file) {
        return file.getMimeType().equals(FOLDER_MIMETYPE);
    }

    Calendar parseDate(String datestring) {
        Date d = new Date();
        Calendar calendar = Calendar.getInstance();
        if (datestring.endsWith("Z")) {
            try {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                d = s.parse(datestring);
            }
            catch (ParseException pe) {
                SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                s.setLenient(true);
                try {
                    d = s.parse(datestring);
                }
                catch (ParseException e) {
                    LOG.error((Object)"An error occurred: ", (Throwable)e);
                }
            }
            calendar.setTime(d);
            return calendar;
        }
        String firstpart = datestring.substring(0, datestring.lastIndexOf(45));
        String secondpart = datestring.substring(datestring.lastIndexOf(45));
        secondpart = secondpart.substring(0, secondpart.indexOf(58)) + secondpart.substring(secondpart.indexOf(58) + 1);
        datestring = firstpart + secondpart;
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            d = s.parse(datestring);
        }
        catch (ParseException pe) {
            s = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
            s.setLenient(true);
            try {
                d = s.parse(datestring);
            }
            catch (ParseException e) {
                LOG.error((Object)"An error occurred: ", (Throwable)e);
            }
        }
        calendar.setTime(d);
        return calendar;
    }

    @Deprecated
    class RequestInitializer
    implements HttpRequestInitializer {
        RequestInitializer() {
        }

        public void initialize(HttpRequest request) throws IOException {
            request.setRetryOnExecuteIOException(true);
            request.setNumberOfRetries(3);
            request.setUnsuccessfulResponseHandler(new HttpUnsuccessfulResponseHandler(){

                public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
                    if (supportsRetry) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)("Interrupted while waiting for a next attempt of drive operation: " + e.getMessage()));
                            Thread.currentThread().interrupt();
                        }
                    }
                    return supportsRetry;
                }
            });
        }
    }

    class ChangesIterator
    extends ChunkIterator<Change> {
        final Drive.Changes.List request;

        ChangesIterator(long startChangeId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.changes().list();
                this.request.setStartChangeId(Long.valueOf(startChangeId));
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Changes.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        @Override
        protected Iterator<Change> nextChunk() throws GoogleDriveException {
            try {
                ChangeList children = (ChangeList)this.request.execute();
                this.request.setPageToken(children.getNextPageToken());
                List items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        @Override
        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }
    }

    class ChildIterator
    extends ChunkIterator<ChildReference> {
        final Drive.Children.List request;

        ChildIterator(String fileId) throws GoogleDriveException {
            try {
                this.request = GoogleDriveAPI.this.drive.children().list(fileId);
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error creating request to Children.List service: " + e.getMessage(), e);
            }
            this.iter = this.nextChunk();
        }

        @Override
        protected Iterator<ChildReference> nextChunk() throws GoogleDriveException {
            try {
                ChildList children = (ChildList)this.request.execute();
                this.request.setPageToken(children.getNextPageToken());
                List items = children.getItems();
                this.available(items.size());
                return items.iterator();
            }
            catch (IOException e) {
                throw new GoogleDriveException("Error requesting Children.List service: " + e.getMessage(), e);
            }
        }

        @Override
        protected boolean hasNextChunk() {
            return this.request.getPageToken() != null && this.request.getPageToken().length() > 0;
        }
    }

    @Deprecated
    abstract class PageIterator<C> {
        Iterator<C> iter;
        C next;
        volatile int available;
        volatile int fetched;

        PageIterator() {
        }

        abstract Iterator<C> nextPage() throws GoogleDriveException;

        abstract boolean hasNextPage();

        boolean hasNext() throws GoogleDriveException {
            if (this.next == null) {
                if (this.iter.hasNext()) {
                    this.next = this.iter.next();
                } else {
                    while (this.hasNextPage()) {
                        this.iter = this.nextPage();
                        if (!this.iter.hasNext()) continue;
                        this.next = this.iter.next();
                        break;
                    }
                }
                return this.next != null;
            }
            return true;
        }

        C next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException("No more data on the Google Drive");
            }
            C c = this.next;
            this.next = null;
            ++this.fetched;
            return c;
        }

        void available(int newValue) {
            if (this.available == 0) {
                this.available = this.hasNextPage() ? Math.round((float)newValue * 1.25f) : newValue;
            } else {
                int newFetched = this.available;
                this.available += this.hasNextPage() ? Math.round((float)newValue * 1.25f) : newValue;
                this.fetched = newFetched;
            }
        }
    }

    class UserCredentialStore
    implements CredentialStore {
        final Map<String, Tokens> store = new ConcurrentHashMap<String, Tokens>();

        UserCredentialStore(String id, String accessToken, String refreshToken, long expirationTime) {
            this.store.put(id, new Tokens(accessToken, refreshToken, expirationTime));
        }

        UserCredentialStore() {
        }

        public boolean load(String userId, Credential credential) throws IOException {
            Tokens uc = this.store.get(userId);
            if (uc != null) {
                credential.setAccessToken(uc.accessToken);
                credential.setRefreshToken(uc.refreshToken);
                credential.setExpirationTimeMilliseconds(Long.valueOf(uc.expirationTime));
                return true;
            }
            return false;
        }

        public void store(String userId, Credential credential) throws IOException {
            this.store.put(userId, new Tokens(credential.getAccessToken(), credential.getRefreshToken(), credential.getExpirationTimeMilliseconds()));
        }

        public void delete(String userId, Credential credential) throws IOException {
            this.store.remove(userId);
        }

        class Tokens {
            final String accessToken;
            final String refreshToken;
            final long expirationTime;

            Tokens(String accessToken, String refreshToken, long expirationTime) {
                this.accessToken = accessToken;
                this.refreshToken = refreshToken;
                this.expirationTime = expirationTime;
            }
        }
    }
}

