/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import com.ibm.icu.text.Transliterator;
import java.lang.ref.SoftReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotConnectedException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.jcr.CommandPoolExecutor;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;

public abstract class JCRLocalCloudDrive
extends CloudDrive {
    public static final String ECD_CLOUDDRIVE = "ecd:cloudDrive";
    public static final String ECD_CLOUDFILE = "ecd:cloudFile";
    public static final String ECD_CLOUDFOLDER = "ecd:cloudFolder";
    public static final String ECD_CLOUDFILERESOURCE = "ecd:cloudFileResource";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFY = "exo:modify";
    public static final String EXO_TRASHFOLDER = "exo:trashFolder";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String DUMMY_DATA = "";
    public static final String USER_WORKSPACE = "user.workspace";
    public static final String USER_NODEPATH = "user.nodePath";
    public static final String USER_SESSIONPROVIDER = "user.sessionProvider";
    protected static final CloudDrive.Command ALREADY_DONE = new AlreadyDone();
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd.HHmmss");
    protected static final ThreadLocal<CloudDrive> actionDrive = new ThreadLocal();
    protected final Transliterator accentsConverter;
    protected final String rootWorkspace;
    protected final ManageableRepository repository;
    protected final SessionProviderService sessionProviders;
    protected final CloudUser user;
    protected final String rootUUID;
    protected final ThreadLocal<SoftReference<Node>> rootNodeHolder;
    protected final NodeRemoveHandler handler;
    protected final AtomicReference<ConnectCommand> currentConnect = new AtomicReference();
    protected final AtomicReference<SyncCommand> currentSync = new AtomicReference();
    protected final CommandPoolExecutor commandExecutor;
    private String titleCached;

    protected JCRLocalCloudDrive(CloudUser user, Node driveNode, SessionProviderService sessionProviders) throws CloudDriveException, RepositoryException {
        this.user = user;
        this.sessionProviders = sessionProviders;
        this.accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        this.commandExecutor = CommandPoolExecutor.getInstance();
        Session session = driveNode.getSession();
        this.repository = (ManageableRepository)session.getRepository();
        this.rootWorkspace = session.getWorkspace().getName();
        if (driveNode.isNodeType(ECD_CLOUDDRIVE)) {
            if (driveNode.hasProperty("exo:title")) {
                this.titleCached = driveNode.getProperty("exo:title").getString();
            }
        } else {
            try {
                this.initDrive(driveNode);
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw e;
            }
            catch (RuntimeException e) {
                this.rollback(driveNode);
                throw e;
            }
        }
        this.rootUUID = driveNode.getUUID();
        this.rootNodeHolder = new ThreadLocal();
        this.rootNodeHolder.set(new SoftReference<Node>(driveNode));
        this.handler = this.addJCRListener(driveNode);
    }

    @Override
    public String getTitle() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("exo:title").getString();
    }

    @Override
    public String getLink() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:url").getString();
    }

    @Override
    public String getId() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:id").getString();
    }

    @Override
    public String getLocalUser() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:localUserName").getString();
    }

    @Override
    public Calendar getInitDate() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:initDate").getDate();
    }

    @Override
    public String getPath() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getPath();
    }

    @Override
    public Calendar getConnectDate() throws DriveRemovedException, NotConnectedException, RepositoryException {
        if (this.isConnected()) {
            return this.rootNode().getProperty("ecd:connectDate").getDate();
        }
        throw new NotConnectedException("Drive '" + this.title() + "' not connected.");
    }

    @Override
    public CloudFile getFile(String path) throws DriveRemovedException, NotCloudFileException, RepositoryException {
        Node driveNode = this.rootNode();
        if (path.startsWith(driveNode.getPath())) {
            Item item = driveNode.getSession().getItem(path);
            if (item.isNode()) {
                Node fileNode = this.fileNode((Node)item);
                if (fileNode == null) {
                    throw new NotCloudFileException("Node '" + path + "' is not a Cloud Drive file.");
                }
                return this.readFile(fileNode);
            }
            throw new NotCloudFileException("Item at path '" + path + "' is Property and cannot be read as Cloud Drive file.");
        }
        throw new NotCloudFileException("Item at path '" + path + "' does not belong to Cloud Drive '" + this.title() + "'");
    }

    @Override
    public boolean hasFile(String path) throws DriveRemovedException, RepositoryException {
        Item item;
        Node driveNode = this.rootNode();
        if (path.startsWith(driveNode.getPath()) && (item = driveNode.getSession().getItem(path)).isNode()) {
            return this.fileNode((Node)item) != null;
        }
        return false;
    }

    @Override
    public List<CloudFile> listFiles() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.listFiles(this.rootNode());
    }

    @Override
    public List<CloudFile> listFiles(CloudFile parent) throws DriveRemovedException, NotCloudFileException, RepositoryException {
        Node driveNode;
        String parentPath = parent.getPath();
        if (parentPath.startsWith((driveNode = this.rootNode()).getPath())) {
            Item item = driveNode.getSession().getItem(parentPath);
            if (item.isNode()) {
                return this.listFiles((Node)item);
            }
            throw new NotCloudFileException("Item at path '" + parentPath + "' is Property and cannot be read as Cloud Drive file.");
        }
        throw new NotCloudFileException("File '" + parentPath + "' does not belong to '" + this.title() + "' Cloud Drive.");
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        Session session = driveNode.getSession();
        driveNode.addMixin(ECD_CLOUDDRIVE);
        if (!driveNode.hasProperty("exo:title")) {
            this.titleCached = this.getUser().getProvider().getName() + " - " + this.getUser().getEmail();
            driveNode.setProperty("exo:title", this.titleCached);
        } else {
            this.titleCached = driveNode.getProperty("exo:title").getString();
        }
        driveNode.setProperty("ecd:connected", false);
        driveNode.setProperty("ecd:localUserName", session.getUserID());
        driveNode.setProperty("ecd:initDate", Calendar.getInstance());
        driveNode.setProperty("ecd:provider", this.getUser().getProvider().getId());
    }

    protected List<CloudFile> listFiles(Node parentNode) throws RepositoryException {
        ArrayList<CloudFile> files = new ArrayList<CloudFile>();
        NodeIterator fileNodes = parentNode.getNodes();
        while (fileNodes.hasNext()) {
            Node fileNode = fileNodes.nextNode();
            if (!fileNode.isNodeType(ECD_CLOUDFILE)) continue;
            JCRLocalCloudFile local = this.readFile(fileNode);
            files.add(local);
            if (!local.isFolder()) continue;
            files.addAll(this.listFiles(fileNode));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudDrive.Command connect(boolean async) throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            return ALREADY_DONE;
        }
        ConnectCommand connect = this.currentConnect.get();
        if (connect == null) {
            AtomicReference<ConnectCommand> atomicReference = this.currentConnect;
            synchronized (atomicReference) {
                connect = this.currentConnect.get();
                if (connect == null) {
                    connect = this.getConnectCommand();
                    this.currentConnect.set(connect);
                    connect.execAsync();
                }
            }
        }
        if (!async) {
            try {
                connect.await();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Caller of connect command interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Throwable err = e.getCause();
                if (err instanceof CloudDriveException) {
                    throw (CloudDriveException)err;
                }
                if (err instanceof RepositoryException) {
                    throw (RepositoryException)err;
                }
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                throw new UndeclaredThrowableException(err, "Error connecting drive: " + err.getMessage());
            }
        }
        return connect;
    }

    @Override
    public synchronized CloudDrive.Command connect() throws DriveRemovedException, CloudDriveException, RepositoryException {
        return this.connect(false);
    }

    protected abstract ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException;

    protected abstract SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    protected abstract SyncFileCommand getSyncFileCommand(Node var1) throws DriveRemovedException, SyncNotSupportedException, RepositoryException;

    @Override
    protected synchronized void disconnect() throws CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            try {
                Node rootNode = this.rootNode();
                try {
                    this.commandExecutor.stop();
                    rootNode.setProperty("ecd:connected", false);
                    NodeIterator niter = rootNode.getNodes();
                    while (niter.hasNext()) {
                        Node existing = niter.nextNode();
                        if (existing.isNodeType(ECD_CLOUDFILE)) {
                            existing.remove();
                            continue;
                        }
                        LOG.warn((Object)("Not a cloud file detected " + existing.getPath() + ". Such files should not be in cloud drive: " + rootNode.getPath() + "."));
                    }
                    rootNode.save();
                    this.listeners.fireOnDisconnect(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootNode.getPath()));
                }
                catch (RepositoryException e) {
                    this.rollback(rootNode);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.rollback(rootNode);
                    throw e;
                }
            }
            catch (ItemNotFoundException e) {
                throw new DriveRemovedException("Drive '" + this.title() + "' was removed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudDrive.Command synchronize(boolean async) throws SyncNotSupportedException, DriveRemovedException, CloudDriveException, CloudDriveAccessException, RepositoryException {
        if (this.isConnected()) {
            this.checkAccess();
            SyncCommand sync = this.currentSync.get();
            if (sync == null) {
                AtomicReference<SyncCommand> atomicReference = this.currentSync;
                synchronized (atomicReference) {
                    sync = this.currentSync.get();
                    if (sync == null) {
                        sync = this.getSyncCommand();
                        this.currentSync.set(sync);
                        sync.execAsync();
                    }
                }
            }
            if (!async) {
                try {
                    sync.await();
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Caller of synchronization command interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable err = e.getCause();
                    if (err instanceof CloudDriveException) {
                        throw (CloudDriveException)err;
                    }
                    if (err instanceof RepositoryException) {
                        throw (RepositoryException)err;
                    }
                    if (err instanceof RuntimeException) {
                        throw (RuntimeException)err;
                    }
                    throw new UndeclaredThrowableException(err, "Error synchronizing drive: " + err.getMessage());
                }
            }
            return sync;
        }
        throw new NotConnectedException("Cloud drive '" + this.title() + "' not connected.");
    }

    @Override
    public CloudDrive.Command synchronize() throws SyncNotSupportedException, CloudDriveException, RepositoryException {
        return this.synchronize(false);
    }

    @Override
    public CloudDrive.Command synchronize(Node file) throws SyncNotSupportedException, NotConnectedException, CloudDriveException, RepositoryException {
        if (this.isConnected()) {
            String rootPath;
            String filePath = file.getPath();
            if (filePath.equals(rootPath = this.rootNode().getPath())) {
                return this.synchronize();
            }
            if (filePath.startsWith(rootPath)) {
                SyncFileCommand sync = this.getSyncFileCommand(file);
                sync.execAsync();
                return sync;
            }
            throw new SyncNotSupportedException("Synchronization not supported for not cloud drive file: " + filePath);
        }
        throw new NotConnectedException("Cloud drive not connected. Cannot synchronize " + file.getPath());
    }

    @Override
    public boolean isConnected() throws DriveRemovedException, RepositoryException {
        return this.rootNode().getProperty("ecd:connected").getBoolean();
    }

    @Override
    protected boolean isDrive(Node node, boolean includeFiles) throws DriveRemovedException, RepositoryException {
        Node driveNode = this.rootNode();
        return driveNode.getProperty("ecd:connected").getBoolean() && (driveNode.isSame((Item)node) || includeFiles && node.getPath().startsWith(driveNode.getPath()) && this.fileNode(node) != null);
    }

    protected Node fileNode(Node node) throws RepositoryException {
        Node parent;
        if (node.isNodeType(ECD_CLOUDFILE)) {
            return node;
        }
        if (node.isNodeType(ECD_CLOUDFILERESOURCE) && (parent = node.getParent()).isNodeType(ECD_CLOUDFILE)) {
            return parent;
        }
        return null;
    }

    protected Session systemSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider ssp = this.sessionProviders.getSystemSessionProvider(null);
        if (ssp != null) {
            return ssp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Session session() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        if (sp != null) {
            return sp.getSession(this.rootWorkspace, this.repository);
        }
        throw new RepositoryException("Cannot get session provider.");
    }

    protected Node rootNode() throws DriveRemovedException, RepositoryException {
        Node rootNode;
        SoftReference<Node> rootNodeRef = this.rootNodeHolder.get();
        if (rootNodeRef != null) {
            rootNode = rootNodeRef.get();
            ConversationState cs = ConversationState.getCurrent();
            if (rootNode != null && rootNode.getSession().isLive() && cs != null && rootNode.getSession().getUserID().equals(cs.getIdentity().getUserId())) {
                try {
                    rootNode.refresh(true);
                    return rootNode;
                }
                catch (InvalidItemStateException e) {
                    throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
            }
        }
        Session session = this.session();
        try {
            rootNode = session.getNodeByUUID(this.rootUUID);
        }
        catch (ItemNotFoundException e) {
            throw new DriveRemovedException("Drive " + this.title() + " was removed.", e);
        }
        this.rootNodeHolder.set(new SoftReference<Node>(rootNode));
        return rootNode;
    }

    protected void rollback(Node rootNode) {
        try {
            rootNode.refresh(false);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Error rolling back the changes on drive '" + this.title() + "': " + e.getMessage()));
        }
    }

    void handleError(Node rootNode, Throwable error, String commandDescription) {
        String rootPath = null;
        if (rootNode != null) {
            try {
                rootPath = rootNode.getPath();
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error reading drive root '" + e.getMessage() + "' " + (commandDescription != null ? "of " + commandDescription + " command " : DUMMY_DATA) + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
            }
            if (commandDescription.equals("connect")) {
                try {
                    this.removeJCRListener(rootNode.getSession());
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error removing observation listener on connect error '" + error.getMessage() + "' " + " on Cloud Drive '" + this.title() + "':" + e.getMessage()));
                }
            }
            this.rollback(rootNode);
        }
        try {
            this.listeners.fireOnError(new CloudDriveEvent(this.getUser(), this.rootWorkspace, rootPath), error);
        }
        catch (Throwable e) {
            LOG.warn((Object)("Error firing error '" + error.getMessage() + "' " + (commandDescription != null ? "of " + commandDescription + " command " : DUMMY_DATA) + "to listeners on Cloud Drive '" + this.title() + "':" + e.getMessage()));
        }
    }

    private Node openNode(String fileId, String fileTitle, Node parent, String nodeType) throws RepositoryException, CloudDriveException {
        Node localNode;
        block4: {
            String title;
            String parentPath = parent.getPath();
            String nodeName = title = this.cleanName(fileTitle);
            int siblingNumber = 1;
            try {
                while ((localNode = parent.getNode(nodeName)).isNodeType(ECD_CLOUDFILE)) {
                    if (!fileId.equals(localNode.getProperty("ecd:id").getString())) {
                        StringBuilder newName = new StringBuilder();
                        newName.append(title);
                        newName.append('-');
                        newName.append(siblingNumber);
                        nodeName = newName.toString();
                        ++siblingNumber;
                        continue;
                    }
                    break block4;
                }
                throw new CloudDriveException("Cannot open cloud file. Another node exists in drive storage with the same name: " + parentPath + "/" + nodeName);
            }
            catch (PathNotFoundException e) {
                localNode = parent.addNode(nodeName, nodeType);
            }
        }
        return localNode;
    }

    protected Node openFile(String fileId, String fileTitle, String fileType, Node parent) throws RepositoryException, CloudDriveException {
        Node localNode = this.openNode(fileId, fileTitle, parent, NT_FILE);
        if (localNode.isNew() && !localNode.hasNode("jcr:content")) {
            Node content = localNode.addNode("jcr:content", NT_RESOURCE);
            this.setContent(content, fileType);
        }
        return localNode;
    }

    protected Node openFolder(String folderId, String folderTitle, Node parent) throws RepositoryException, CloudDriveException {
        return this.openNode(folderId, folderTitle, parent, NT_FOLDER);
    }

    protected Node moveNode(String id, String title, Node source, Node destParent) throws RepositoryException, CloudDriveException {
        Node place = this.openNode(id, title, destParent, NT_FILE);
        if (place.isNew() && !place.hasProperty("ecd:id")) {
            String nodeName = place.getName();
            place.remove();
            Session session = destParent.getSession();
            String destPath = destParent.getPath() + "/" + nodeName;
            session.move(source.getPath(), destPath);
            return source;
        }
        return place;
    }

    protected Node copyNode(Node node, Node destParent) throws RepositoryException {
        Node nodeCopy = destParent.addNode(node.getName(), node.getPrimaryNodeType().getName());
        for (NodeType mixin : node.getMixinNodeTypes()) {
            String mixinName = mixin.getName();
            if (nodeCopy.isNodeType(mixinName)) continue;
            nodeCopy.addMixin(mixin.getName());
        }
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property ep = piter.nextProperty();
            PropertyDefinition pdef = ep.getDefinition();
            if (pdef.isProtected()) continue;
            if (pdef.isMultiple()) {
                nodeCopy.setProperty(ep.getName(), ep.getValues());
                continue;
            }
            nodeCopy.setProperty(ep.getName(), ep.getValue());
        }
        NodeIterator niter = node.getNodes();
        while (niter.hasNext()) {
            Node ecn = niter.nextNode();
            NodeDefinition ndef = ecn.getDefinition();
            if (ndef.isProtected()) continue;
            this.copyNode(ecn, nodeCopy);
        }
        return nodeCopy;
    }

    @Deprecated
    protected String findNodeName(String fileTitle, String parentPath, Session session) throws RepositoryException {
        String title;
        String nodeName = title = this.cleanName(fileTitle);
        int siblingNumber = 1;
        while (session.itemExists(parentPath + "/" + nodeName)) {
            StringBuilder newName = new StringBuilder();
            newName.append(title);
            newName.append('-');
            newName.append(siblingNumber);
            nodeName = newName.toString();
            ++siblingNumber;
        }
        return nodeName;
    }

    protected void readNodes(Node parent, Map<String, List<Node>> nodes, boolean deep) throws RepositoryException {
        NodeIterator niter = parent.getNodes();
        while (niter.hasNext()) {
            Node cn = niter.nextNode();
            if (cn.isNodeType(ECD_CLOUDFILE)) {
                String cnid = cn.getProperty("ecd:id").getString();
                List<Node> nodeList = nodes.get(cnid);
                if (nodeList == null) {
                    nodeList = new ArrayList<Node>();
                    nodes.put(cnid, nodeList);
                }
                nodeList.add(cn);
                if (!deep || !cn.isNodeType(ECD_CLOUDFOLDER)) continue;
                this.readNodes(cn, nodes, deep);
                continue;
            }
            LOG.warn((Object)("Not a cloud file detected " + cn.getPath()));
        }
    }

    protected Node readNode(Node parent, String title, String id) throws RepositoryException {
        String name = this.cleanName(title);
        try {
            Node n = parent.getNode(name);
            if (n.isNodeType(ECD_CLOUDFILE) && id.equals(n.getProperty("ecd:id").getString())) {
                return n;
            }
        }
        catch (PathNotFoundException e) {
            // empty catch block
        }
        NodeIterator niter = parent.getNodes(name + "*");
        while (niter.hasNext()) {
            Node n = niter.nextNode();
            if (!n.isNodeType(ECD_CLOUDFILE) || !id.equals(n.getProperty("ecd:id").getString())) continue;
            return n;
        }
        return null;
    }

    protected Node findNode(String id) throws RepositoryException, DriveRemovedException {
        Node rootNode = this.rootNode();
        QueryManager qm = rootNode.getSession().getWorkspace().getQueryManager();
        Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE ecd:id='" + id + "' AND jcr:path LIKE '" + rootNode.getPath() + "/%'", "sql");
        QueryResult qr = q.execute();
        NodeIterator nodes = qr.getNodes();
        if (nodes.hasNext()) {
            return nodes.nextNode();
        }
        return null;
    }

    protected JCRLocalCloudFile readFile(Node fileNode) throws RepositoryException {
        String downloadUrl;
        String previewUrl;
        String fileUrl = fileNode.getProperty("ecd:url").getString();
        try {
            previewUrl = fileNode.getProperty("ecd:previewUrl").getString();
        }
        catch (PathNotFoundException e) {
            previewUrl = null;
        }
        try {
            downloadUrl = fileNode.getProperty("ecd:downloadUrl").getString();
        }
        catch (PathNotFoundException e) {
            downloadUrl = null;
        }
        return new JCRLocalCloudFile(fileNode.getPath(), fileNode.getProperty("ecd:id").getString(), fileNode.getProperty("exo:title").getString(), fileUrl, previewUrl, downloadUrl, fileNode.getProperty("ecd:type").getString(), fileNode.getProperty("ecd:lastUser").getString(), fileNode.getProperty("ecd:author").getString(), fileNode.getProperty("ecd:created").getDate(), fileNode.getProperty("ecd:modified").getDate(), fileNode.isNodeType(ECD_CLOUDFOLDER));
    }

    protected void initFile(Node localNode, String title, String id, String type, String link, String previewLink, String downloadLink, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFILE)) {
            localNode.addMixin(ECD_CLOUDFILE);
        }
        this.initCommon(localNode, title, id, type, link, author, lastUser, created, modified);
        Node content = localNode.getNode("jcr:content");
        if (!content.isNodeType(ECD_CLOUDFILERESOURCE)) {
            content.addMixin(ECD_CLOUDFILERESOURCE);
        }
        content.setProperty("jcr:mimeType", type);
        content.setProperty("jcr:lastModified", modified);
        localNode.setProperty("ecd:previewUrl", previewLink);
        localNode.setProperty("ecd:downloadUrl", downloadLink);
    }

    protected void initFolder(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        if (!localNode.isNodeType(ECD_CLOUDFOLDER)) {
            localNode.addMixin(ECD_CLOUDFOLDER);
        }
        this.initCommon(localNode, id, title, type, link, author, lastUser, created, modified);
    }

    protected void initCommon(Node localNode, String id, String title, String type, String link, String author, String lastUser, Calendar created, Calendar modified) throws RepositoryException {
        localNode.setProperty("exo:title", title);
        localNode.setProperty("ecd:id", id);
        localNode.setProperty("ecd:driveUUID", this.rootUUID);
        localNode.setProperty("ecd:type", type);
        localNode.setProperty("ecd:url", link);
        localNode.setProperty("ecd:author", author);
        localNode.setProperty("ecd:lastUser", lastUser);
        localNode.setProperty("ecd:created", created);
        localNode.setProperty("ecd:modified", modified);
        localNode.setProperty("ecd:synchronized", Calendar.getInstance());
        if (localNode.isNodeType(EXO_DATETIME)) {
            localNode.setProperty("exo:dateCreated", created);
            localNode.setProperty("exo:dateModified", modified);
        }
        if (localNode.isNodeType(EXO_MODIFY)) {
            localNode.setProperty("exo:lastModifiedDate", modified);
            localNode.setProperty("exo:lastModifier", lastUser);
        }
    }

    protected void setContent(Node content, String mimetype) throws RepositoryException {
        content.setProperty("jcr:data", DUMMY_DATA);
    }

    protected String cleanName(String str) {
        StringBuffer cleanedStr = new StringBuffer((str = this.accentsConverter.transliterate(str.trim())).trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            for (int i = 0; i < cleanedStr.length(); ++i) {
                char c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
        }
        return cleanedStr.toString().trim();
    }

    @Override
    protected String title() {
        return this.titleCached;
    }

    protected NodeRemoveHandler addJCRListener(Node driveNode) throws RepositoryException {
        NodeRemoveHandler handler = new NodeRemoveHandler(driveNode.getPath());
        ObservationManager observation = driveNode.getSession().getWorkspace().getObservationManager();
        observation.addEventListener((EventListener)handler.removeListener, 2, driveNode.getParent().getPath(), false, null, null, true);
        observation.addEventListener((EventListener)handler.addListener, 1, null, false, null, new String[]{EXO_TRASHFOLDER}, true);
        return handler;
    }

    protected void removeJCRListener(Session session) throws RepositoryException {
        ObservationManager observation = session.getWorkspace().getObservationManager();
        observation.removeEventListener((EventListener)this.handler.removeListener);
        observation.removeEventListener((EventListener)this.handler.addListener);
    }

    protected abstract boolean isSyncSupported(CloudFile var1);

    static void startAction(CloudDrive drive) {
        actionDrive.set(drive);
    }

    static boolean acceptAction(CloudDrive drive) {
        return drive != null && drive != actionDrive.get();
    }

    static void doneAction() {
        actionDrive.remove();
    }

    public static void checkTrashed(Node node) throws RepositoryException, DriveRemovedException {
        if (node.getParent().isNodeType(EXO_TRASHFOLDER)) {
            throw new DriveRemovedException("Drive " + node.getPath() + " was moved to Trash.");
        }
    }

    protected abstract class SyncFileCommand
    extends AbstractCommand {
        final Node fileNode;
        final boolean isFolder;

        public SyncFileCommand(Node file) throws RepositoryException, DriveRemovedException, SyncNotSupportedException {
            Node parentNode = file.getParent();
            if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILE)) {
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFOLDER)) {
                this.isFolder = true;
            } else if (file.isNodeType(JCRLocalCloudDrive.ECD_CLOUDFILERESOURCE)) {
                file = parentNode;
                parentNode = file.getParent();
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.NT_FILE)) {
                String mimeType = file.getNode("jcr:content").getProperty("jcr:mimeType").getString();
                this.isFolder = false;
            } else if (file.isNodeType(JCRLocalCloudDrive.NT_RESOURCE)) {
                String mimeType = file.getProperty("jcr:mimeType").getString();
                file = parentNode;
                parentNode = file.getParent();
                this.isFolder = false;
            } else {
                if (file.isNodeType(JCRLocalCloudDrive.NT_UNSTRUCTURED)) {
                    throw new SyncNotSupportedException("Synchronization not supported for " + file.getPrimaryNodeType().getName() + " node: " + file.getPath());
                }
                throw new SyncNotSupportedException("Synchronization not supported for " + file.getPrimaryNodeType().getName() + " node: " + file.getPath());
            }
            this.fileNode = file;
        }

        @Override
        public String getName() {
            return "file synchronization";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException {
        }
    }

    protected abstract class SyncCommand
    extends AbstractCommand {
        protected Map<String, List<Node>> nodes;

        protected SyncCommand() throws RepositoryException, DriveRemovedException {
        }

        @Override
        public String getName() {
            return "synchronization";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException {
            try {
                this.syncFiles();
                this.driveRoot.save();
            }
            finally {
                JCRLocalCloudDrive.this.currentSync.set(null);
            }
            JCRLocalCloudDrive.this.listeners.fireOnSynchronized(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveRoot.getPath()));
        }

        protected abstract void syncFiles() throws CloudDriveException, RepositoryException;

        protected void readLocalNodes() throws RepositoryException {
            LinkedHashMap<String, List<Node>> nodes = new LinkedHashMap<String, List<Node>>();
            String rootId = this.driveRoot.getProperty("ecd:id").getString();
            ArrayList<Node> rootList = new ArrayList<Node>();
            rootList.add(this.driveRoot);
            nodes.put(rootId, rootList);
            JCRLocalCloudDrive.this.readNodes(this.driveRoot, nodes, true);
            this.nodes = nodes;
        }
    }

    protected abstract class ConnectCommand
    extends AbstractCommand {
        protected ConnectCommand() throws RepositoryException, DriveRemovedException {
        }

        protected abstract void fetchFiles() throws CloudDriveException, RepositoryException;

        @Override
        public String getName() {
            return "connect";
        }

        @Override
        protected void process() throws CloudDriveException, RepositoryException {
            this.fetchFiles();
            this.driveRoot.setProperty("ecd:cloudUserId", JCRLocalCloudDrive.this.getUser().getId());
            this.driveRoot.setProperty("ecd:cloudUserName", JCRLocalCloudDrive.this.getUser().getUsername());
            this.driveRoot.setProperty("ecd:userEmail", JCRLocalCloudDrive.this.getUser().getEmail());
            this.driveRoot.setProperty("ecd:connectDate", Calendar.getInstance());
            this.driveRoot.setProperty("ecd:connected", true);
            this.driveRoot.save();
            JCRLocalCloudDrive.this.listeners.fireOnConnect(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, this.driveRoot.getPath()));
        }
    }

    protected abstract class AbstractCommand
    implements CloudDrive.Command,
    CloudDrive.CommandProgress {
        protected final Queue<CloudFile> changed = new ConcurrentLinkedQueue<CloudFile>();
        protected final Queue<String> removed = new ConcurrentLinkedQueue<String>();
        protected Node driveRoot;
        protected final AtomicInteger progressReported = new AtomicInteger();
        protected final AtomicLong startTime = new AtomicLong();
        protected final AtomicLong finishTime = new AtomicLong();
        protected final List<ChunkIterator<?>> iterators = new ArrayList();
        protected Future<CloudDrive.Command> async;

        protected AbstractCommand() throws RepositoryException, DriveRemovedException {
        }

        protected abstract void process() throws CloudDriveAccessException, CloudDriveException, RepositoryException;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void exec() throws CloudDriveAccessException, CloudDriveException, RepositoryException {
            this.startTime.set(System.currentTimeMillis());
            try {
                this.driveRoot = JCRLocalCloudDrive.this.rootNode();
                JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                int attemptNumb = 0;
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.process();
                        return;
                    }
                    catch (CloudProviderException e) {
                        try {
                            if (JCRLocalCloudDrive.this.getUser().getProvider().retryOnProviderError()) {
                                if (++attemptNumb > 3) {
                                    JCRLocalCloudDrive.this.handleError(this.driveRoot, e, this.getName());
                                    throw e;
                                }
                                JCRLocalCloudDrive.this.rollback(this.driveRoot);
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException ie) {
                                    LOG.warn((Object)("Interrupted while waiting for a next attempt of " + this.getName() + ": " + ie.getMessage()));
                                    Thread.currentThread().interrupt();
                                }
                                LOG.warn((Object)("Error running " + this.getName() + " command: " + e.getMessage() + ". Rolled back and running next attempt."));
                                continue;
                            }
                            JCRLocalCloudDrive.this.handleError(this.driveRoot, e, this.getName());
                            throw e;
                        }
                        catch (CloudDriveException e2) {
                            JCRLocalCloudDrive.this.handleError(this.driveRoot, e2, this.getName());
                            throw e2;
                        }
                        catch (RepositoryException e3) {
                            JCRLocalCloudDrive.this.handleError(this.driveRoot, e3, this.getName());
                            throw e3;
                        }
                        catch (RuntimeException e4) {
                            JCRLocalCloudDrive.this.handleError(this.driveRoot, e4, this.getName());
                            throw e4;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                JCRLocalCloudDrive.doneAction();
                this.finishTime.set(System.currentTimeMillis());
            }
        }

        protected Future<CloudDrive.Command> execAsync() throws CloudDriveException {
            ConversationState conversation = ConversationState.getCurrent();
            if (conversation == null) {
                throw new CloudDriveException("Error to " + this.getName() + " drive for user " + JCRLocalCloudDrive.this.getUser().getEmail() + ". User identity not set.");
            }
            this.async = JCRLocalCloudDrive.this.commandExecutor.submit(this.getName(), new CommandCallable(this, conversation, ExoContainerContext.getCurrentContainer()));
            return this.async;
        }

        @Override
        public long getComplete() {
            int complete = 0;
            for (ChunkIterator<?> child : this.iterators) {
                complete = (int)((long)complete + child.getFetched());
            }
            return complete;
        }

        @Override
        public long getAvailable() {
            int available = 0;
            for (ChunkIterator<?> child : this.iterators) {
                available = (int)((long)available + child.getAvailable());
            }
            return Math.round((float)available * 1.075f);
        }

        @Override
        public int getProgress() {
            int reported;
            if (this.isDone()) {
                return 100;
            }
            int current = Math.round((float)this.getComplete() * 100.0f / (float)this.getAvailable());
            if (current >= (reported = this.progressReported.get())) {
                reported = current;
            }
            this.progressReported.set(reported);
            return reported;
        }

        @Override
        public boolean isDone() {
            return this.finishTime.get() > 0L;
        }

        @Override
        public long getStartTime() {
            return this.startTime.get();
        }

        @Override
        public long getFinishTime() {
            return this.finishTime.get();
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.unmodifiableCollection(this.changed);
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.unmodifiableCollection(this.removed);
        }

        @Override
        public void await() throws ExecutionException, InterruptedException {
            if (this.async != null) {
                this.async.get();
            }
        }
    }

    protected class CommandCallable
    implements Callable<CloudDrive.Command> {
        final ConversationState conversation;
        final ExoContainer container;
        final AbstractCommand command;

        CommandCallable(AbstractCommand command, ConversationState conversation, ExoContainer container) throws CloudDriveException {
            this.conversation = conversation;
            this.container = container;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CloudDrive.Command call() throws Exception {
            ConversationState prevConversation = ConversationState.getCurrent();
            ConversationState.setCurrent((ConversationState)this.conversation);
            ExoContainer prevContainer = ExoContainerContext.getCurrentContainerIfPresent();
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            SessionProvider prevSessions = JCRLocalCloudDrive.this.sessionProviders.getSessionProvider(null);
            SessionProvider sp = new SessionProvider(this.conversation);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, sp);
            try {
                this.command.exec();
                AbstractCommand abstractCommand = this.command;
                return abstractCommand;
            }
            finally {
                JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, prevSessions);
                ExoContainerContext.setCurrentContainer((ExoContainer)prevContainer);
                ConversationState.setCurrent((ConversationState)prevConversation);
                sp.close();
            }
        }
    }

    @Deprecated
    protected class CommandRunnable
    implements Runnable {
        final AbstractCommand command;
        final Thread runner;
        final ConversationState conversation;
        final CountDownLatch lock = new CountDownLatch(1);

        CommandRunnable(AbstractCommand command, ConversationState conversation) throws CloudDriveException {
            this.conversation = conversation;
            this.command = command;
            this.runner = new Thread((Runnable)this, JCRLocalCloudDrive.this.title() + " connect " + DATE_FORMAT.format(Calendar.getInstance().getTime()));
        }

        void start() {
            this.runner.start();
        }

        void await() throws InterruptedException {
            this.lock.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConversationState.setCurrent((ConversationState)this.conversation);
            SessionProvider sp = new SessionProvider(this.conversation);
            JCRLocalCloudDrive.this.sessionProviders.setSessionProvider(null, sp);
            try {
                this.command.exec();
            }
            catch (CloudDriveException e) {
                LOG.error((Object)("Cloud Drive error during " + this.command.getName() + ": " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error((Object)("Error to " + this.command.getName() + ": " + e.getMessage()), e);
            }
            finally {
                sp.close();
                this.lock.countDown();
            }
        }
    }

    @Deprecated
    class NodeMoveHandler {
        final String initialRootPath;
        final RemoveListener removeListener;
        final AddListener addListener;
        ThreadLocal<List<FileNode>> moved = new ThreadLocal();

        NodeMoveHandler(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveListener();
            this.addListener = new AddListener();
        }

        synchronized void addMoved(String path) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes == null) {
                nodes = new ArrayList<FileNode>();
                this.moved.set(nodes);
            }
            FileNode file = new FileNode();
            file.path = path;
            nodes.add(file);
        }

        synchronized void updateMoved(String path, Node node) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes == null) {
                nodes = new ArrayList<FileNode>();
                this.moved.set(nodes);
            }
            FileNode file = new FileNode();
            file.path = path;
            nodes.add(file);
        }

        synchronized void checkMove(List<Node> added) throws RepositoryException {
            List<FileNode> nodes = this.moved.get();
            if (nodes != null) {
                // empty if block
            }
        }

        class AddListener
        implements EventListener {
            AddListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    try {
                        driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.error((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node was removed: " + e.getMessage()));
                        return;
                    }
                    String rootPath = driveRoot.getPath();
                    ArrayList<Node> added = new ArrayList<Node>();
                    while (events.hasNext()) {
                        Item addedItem;
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 1 || event.getPath().startsWith(rootPath) || !(addedItem = driveRoot.getSession().getItem(event.getPath())).isNode()) continue;
                        added.add((Node)addedItem);
                    }
                    if (!added.isEmpty()) {
                        NodeMoveHandler.this.checkMove(added);
                    }
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/add event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class RemoveListener
        implements EventListener {
            RemoveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    try {
                        Node driveRoot = JCRLocalCloudDrive.this.rootNode();
                    }
                    catch (DriveRemovedException e) {
                        LOG.error((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node was removed: " + e.getMessage()));
                        return;
                    }
                    ArrayList<FileNode> nodes = new ArrayList<FileNode>();
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 2 || !event.getPath().startsWith(NodeMoveHandler.this.initialRootPath)) continue;
                        FileNode file = new FileNode();
                        file.path = event.getPath();
                        nodes.add(file);
                    }
                    NodeMoveHandler.this.moved.set(nodes);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/remove event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class FileNode {
            String path;
            String id;
            Node node;

            FileNode() {
            }
        }
    }

    class NodeRemoveHandler {
        final String initialRootPath;
        final RemoveListener removeListener;
        final AddListener addListener;
        volatile boolean removed = false;
        volatile boolean added = false;

        NodeRemoveHandler(String initialRootPath) {
            this.initialRootPath = initialRootPath;
            this.removeListener = new RemoveListener();
            this.addListener = new AddListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void checkRemove(Node driveRoot) throws RepositoryException {
            if (this.removed && this.added && driveRoot.getParent().isNodeType(JCRLocalCloudDrive.EXO_TRASHFOLDER)) {
                Session session = driveRoot.getSession();
                try {
                    JCRLocalCloudDrive.startAction(JCRLocalCloudDrive.this);
                    try {
                        JCRLocalCloudDrive.this.disconnect();
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error disconnecting Cloud Drive " + JCRLocalCloudDrive.this.title() + " before its removal. " + e.getMessage()), e);
                    }
                    this.finishRemove(session, driveRoot.getPath());
                }
                finally {
                    driveRoot.remove();
                    session.save();
                    JCRLocalCloudDrive.doneAction();
                    LOG.info((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " successfully removed from the Trash."));
                }
            }
        }

        void finishRemove(Session session, String rootPath) {
            this.added = false;
            this.removed = false;
            try {
                JCRLocalCloudDrive.this.removeJCRListener(session);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error unregistering Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node listeners: " + e.getMessage()), (Throwable)e);
            }
            JCRLocalCloudDrive.this.listeners.fireOnRemove(new CloudDriveEvent(JCRLocalCloudDrive.this.getUser(), JCRLocalCloudDrive.this.rootWorkspace, rootPath));
        }

        class AddListener
        implements EventListener {
            AddListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    try {
                        driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                    }
                    catch (ItemNotFoundException e) {
                        LOG.warn((Object)("Cloud Drive " + JCRLocalCloudDrive.this.title() + " node already removed directly from JCR: " + e.getMessage()));
                        NodeRemoveHandler.this.finishRemove(session, NodeRemoveHandler.this.initialRootPath);
                        return;
                    }
                    String rootPath = driveRoot.getPath();
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 1 || !rootPath.equals(event.getPath())) continue;
                        NodeRemoveHandler.this.added = true;
                    }
                    NodeRemoveHandler.this.checkRemove(driveRoot);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive " + JCRLocalCloudDrive.this.title() + " node move/add event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }

        class RemoveListener
        implements EventListener {
            RemoveListener() {
            }

            public void onEvent(EventIterator events) {
                String userId = null;
                try {
                    Node driveRoot;
                    Session session = JCRLocalCloudDrive.this.systemSession();
                    try {
                        driveRoot = session.getNodeByUUID(JCRLocalCloudDrive.this.rootUUID);
                    }
                    catch (ItemNotFoundException e) {
                        LOG.warn((Object)("Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node already removed directly from JCR: " + e.getMessage()));
                        NodeRemoveHandler.this.finishRemove(JCRLocalCloudDrive.this.session(), NodeRemoveHandler.this.initialRootPath);
                        return;
                    }
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        userId = event.getUserID();
                        if (event.getType() != 2 || !NodeRemoveHandler.this.initialRootPath.equals(event.getPath())) continue;
                        NodeRemoveHandler.this.removed = true;
                    }
                    NodeRemoveHandler.this.checkRemove(driveRoot);
                }
                catch (AccessDeniedException e) {
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error handling Cloud Drive '" + JCRLocalCloudDrive.this.title() + "' node move/remove event" + (userId != null ? " for user " + userId : JCRLocalCloudDrive.DUMMY_DATA)), (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    class BufferedNodeIterator
    implements NodeIterator {
        final List<Node> buff = new ArrayList<Node>();
        NodeIterator nodes;
        int buffPos = 0;

        BufferedNodeIterator(NodeIterator nodes) {
            this.nodes = nodes;
        }

        public void skip(long skipNum) {
            if (this.nodes != null) {
                int i = 0;
                while ((long)i < skipNum) {
                    this.buff.add(this.nodes.nextNode());
                    ++i;
                }
            } else {
                this.buffPos = (int)((long)this.buffPos + skipNum);
            }
        }

        public long getSize() {
            if (this.nodes != null) {
                return this.nodes.getSize();
            }
            return this.buff.size();
        }

        public long getPosition() {
            if (this.nodes != null) {
                return this.nodes.getPosition();
            }
            return this.buffPos;
        }

        public boolean hasNext() {
            if (this.nodes != null) {
                return this.nodes.hasNext();
            }
            return this.buffPos < this.buff.size() - 1;
        }

        public Object next() {
            return this.nextNode();
        }

        public Node nextNode() {
            if (this.nodes != null) {
                Node n = this.nodes.nextNode();
                this.buff.add(n);
                if (!this.nodes.hasNext()) {
                    this.nodes = null;
                }
                return n;
            }
            if (this.buffPos == this.buff.size()) {
                throw new NoSuchElementException("Buffer has no more Nodes.");
            }
            Node n = this.buff.get(this.buffPos);
            ++this.buffPos;
            return n;
        }

        public void remove() {
            if (this.nodes != null) {
                this.nodes.remove();
            } else {
                if (this.buffPos == this.buff.size()) {
                    throw new IllegalStateException("End of the buffer reached.");
                }
                this.buff.remove(this.buffPos);
            }
        }

        void reset() {
            this.buffPos = 0;
        }
    }

    static class AlreadyDone
    implements CloudDrive.Command {
        final long time = System.currentTimeMillis();

        AlreadyDone() {
        }

        @Override
        public int getProgress() {
            return 100;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Collection<CloudFile> getFiles() {
            return Collections.emptyList();
        }

        @Override
        public Collection<String> getRemoved() {
            return Collections.emptyList();
        }

        @Override
        public long getStartTime() {
            return this.time;
        }

        @Override
        public long getFinishTime() {
            return this.time;
        }

        @Override
        public void await() throws InterruptedException {
        }

        @Override
        public String getName() {
            return "complete";
        }
    }
}

