/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.features.CloudDriveFeatures;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudDriveContext {
    protected static final String JAVASCRIPT = "CloudDriveContext_Javascript".intern();
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveContext.class);
    private final RequireJS require;
    private final Set<String> nodes = new HashSet<String>();
    private final Set<String> providers = new HashSet<String>();

    public static boolean init(RequestContext requestContext, String workspace, String nodePath, CloudProvider provider) throws CloudDriveException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj == null) {
            CloudDriveContext context = new CloudDriveContext(requestContext);
            CloudDriveFeatures features = (CloudDriveFeatures)WCMCoreUtils.getService(CloudDriveFeatures.class);
            if (features.canCreateDrive(workspace, nodePath, requestContext.getRemoteUser(), provider)) {
                context.init(workspace, nodePath);
            }
            if (provider != null) {
                context.addProvider(provider);
            }
            requestContext.setAttribute(JAVASCRIPT, (Object)context);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request context already initialized");
        }
        return false;
    }

    public static boolean init(RequestContext requestContext, String workspace, String nodePath) throws CloudDriveException {
        return CloudDriveContext.init(requestContext, workspace, nodePath, null);
    }

    public static boolean initNodes(RequestContext requestContext, Node parent) throws RepositoryException, CloudDriveException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            CloudDriveContext context = (CloudDriveContext)obj;
            context.addNodes(parent.getNodes());
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Context not initialized for adding of drive nodes.");
        }
        return false;
    }

    public static boolean initProviders(RequestContext requestContext, CloudProvider ... providers) throws CloudDriveException {
        Object obj = requestContext.getAttribute(JAVASCRIPT);
        if (obj != null) {
            CloudDriveContext context = (CloudDriveContext)obj;
            for (CloudProvider p : providers) {
                context.addProvider(p);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Context not initialized for adding of providers.");
        }
        return false;
    }

    private CloudDriveContext(RequestContext requestContext) {
        JavascriptManager js = ((WebuiRequestContext)requestContext).getJavascriptManager();
        this.require = js.require("SHARED/cloudDrive", "cloudDrive");
    }

    private CloudDriveContext init(String workspace, String nodePath) {
        this.require.addScripts("\ncloudDrive.init('" + workspace + "','" + nodePath + "');\n");
        return this;
    }

    private CloudDriveContext addNodes(NodeIterator nodes) throws CloudDriveException, RepositoryException {
        if (nodes.hasNext()) {
            CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            StringBuilder map = new StringBuilder();
            map.append('{');
            int count = 0;
            do {
                String title;
                Node child;
                CloudDrive drive;
                if ((drive = driveService.findDrive(child = nodes.nextNode())) == null || this.nodes.contains(title = child.getProperty("exo:title").getString())) continue;
                map.append('\"');
                map.append(title);
                map.append("\":\"");
                map.append(drive.getUser().getProvider().getId());
                map.append("\",");
                ++count;
                this.nodes.add(title);
            } while (nodes.hasNext());
            if (count >= 1) {
                map.deleteCharAt(map.length() - 1);
                map.append('}');
                this.require.addScripts("\ncloudDrive.initNodes(" + map.toString() + ");\n");
            }
        }
        return this;
    }

    private CloudDriveContext addProvider(CloudProvider provider) throws CloudDriveException {
        String id = provider.getId();
        if (!this.providers.contains(id)) {
            this.require.addScripts("\ncloudDrive.initProvider('" + id + "', '" + provider.getAuthUrl() + "');\n");
            this.providers.add(id);
        }
        return this;
    }
}

