/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.authorization;

import com.box.boxjavalibv2.authorization.OAuthDataController;
import com.box.boxjavalibv2.dao.BoxOAuthToken;
import com.box.boxjavalibv2.exceptions.AuthFatalFailureException;
import com.box.restclientv2.authorization.DefaultRequestAuth;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.interfaces.IBoxRequest;

public class OAuthAuthorization
extends DefaultRequestAuth {
    private static final String BEARER = "Bearer";
    private final OAuthDataController mOAuth;

    public OAuthAuthorization(OAuthDataController oAuth) {
        this.mOAuth = oAuth;
    }

    public void setOAuthData(BoxOAuthToken data) {
        this.mOAuth.setOAuthData(data);
        this.mOAuth.initialize();
    }

    public void refresh() throws AuthFatalFailureException {
        this.mOAuth.refresh();
    }

    public void initOAuthForRequest() {
        this.mOAuth.initialize();
    }

    @Override
    public void setAuth(IBoxRequest request) throws BoxRestException, AuthFatalFailureException {
        super.setAuth(request);
        request.addHeader("Authorization", this.getAuthString());
    }

    private String getAuthString() throws AuthFatalFailureException {
        BoxOAuthToken data = this.mOAuth.getAuthData();
        return "Bearer " + data.getAccessToken();
    }
}

