/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.box;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.services.jcr.RepositoryService;

public class BoxProvider
extends CloudProvider {
    protected final String authUrl;
    protected final String redirectUrl;
    protected final RepositoryService jcrService;

    public BoxProvider(String id, String name, String authUrl, String redirectUrl, RepositoryService jcrService) {
        super(id, name);
        this.authUrl = authUrl;
        this.redirectUrl = redirectUrl;
        this.jcrService = jcrService;
    }

    @Override
    public String getAuthUrl() throws CloudDriveException {
        if (this.jcrService != null) {
            try {
                String currentRepo = this.jcrService.getCurrentRepository().getConfiguration().getName();
                return this.authUrl.replace("__no_state_set__", currentRepo);
            }
            catch (RepositoryException e) {
                throw new CloudDriveException(e);
            }
        }
        return this.authUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    public boolean retryOnProviderError() {
        return true;
    }
}

