/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.jcr;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CommandPoolExecutor {
    public static final long SYNC_PERIOD = 10000L;
    public static final long STOP_TIMEOUT = 40000L;
    protected static final Log LOG = ExoLogger.getLogger(CommandPoolExecutor.class);
    protected static CommandPoolExecutor singleton;
    private final ConcurrentHashMap<CloudDrive, Object> drives = new ConcurrentHashMap();
    private ExecutorService executor;

    static CommandPoolExecutor getInstance() {
        if (singleton == null) {
            singleton = new CommandPoolExecutor();
        }
        return singleton;
    }

    private CommandPoolExecutor() {
    }

    public synchronized <S> Future<CloudDrive.Command> submit(String name, Callable<CloudDrive.Command> command) {
        this.init();
        return this.executor.submit(command);
    }

    void stop() {
        this.stopSheduller();
    }

    private void init() {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                if (!this.executor.isTerminated()) {
                    this.stopSheduller();
                    try {
                        if (!this.executor.awaitTermination(40000L, TimeUnit.SECONDS)) {
                            LOG.warn((Object)("Cloud Drive scheduler (" + this.drives.size() + ") already shutdown but not yet terminated " + this.executor));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                return;
            }
        }
        this.executor = new ThreadPoolExecutor(2, 6, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new CommandThreadFactory());
    }

    private void stopSheduller() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "clouddrive-command-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

