/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.oauth2;

import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;

public abstract class UserToken {
    private String accessToken;
    private String refreshToken;
    private long expirationTime;
    private Set<UserTokenRefreshListener> listeners = new LinkedHashSet<UserTokenRefreshListener>();

    protected UserToken() {
    }

    public void addListener(UserTokenRefreshListener listener) throws CloudDriveException {
        this.listeners.add(listener);
        listener.onUserTokenRefresh(this);
    }

    public void removeListener(UserTokenRefreshListener listener) {
        this.listeners.remove(listener);
    }

    public void load(String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTime = expirationTime;
    }

    public void store(String accessToken, String refreshToken, long expirationTime) throws CloudDriveException {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expirationTime = expirationTime;
        this.fireListeners();
    }

    public void merge(UserToken newToken) throws CloudDriveException {
        this.removeListeners();
        this.store(newToken.getAccessToken(), newToken.getRefreshToken(), newToken.getExpirationTime());
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    void unregisterListeners() {
        this.listeners.clear();
    }

    private void fireListeners() throws CloudDriveException {
        for (UserTokenRefreshListener listener : this.listeners) {
            listener.onUserTokenRefresh(this);
        }
    }

    void removeListeners() throws CloudDriveException {
        this.listeners.clear();
    }
}

