/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import javax.annotation.security.RolesAllowed;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/clouddrive/changes/")
@Produces(value={"application/json"})
public class ChangesService
implements ResourceContainer {
    protected static final Log LOG = ExoLogger.getLogger(ChangesService.class);
    protected final CloudDriveService cloudDrives;
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeFinder finder;

    public ChangesService(CloudDriveService cloudDrives, RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder) {
        this.cloudDrives = cloudDrives;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.finder = finder;
    }

    /*
     * Exception decompiling
     */
    @POST
    @RolesAllowed(value={"users"})
    @Deprecated
    public Response asyncSynchronization(@Context UriInfo uriInfo, @FormParam(value="workspace") String workspace, @FormParam(value="path") String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/link/")
    @RolesAllowed(value={"users"})
    public Response getChangesLink(@Context UriInfo uriInfo, @QueryParam(value="workspace") String workspace, @QueryParam(value="path") String path) {
        if (workspace == null) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null workspace.").build();
        if (path == null) return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Null path.").build();
        try {
            SessionProvider sp = this.sessionProviders.getSessionProvider(null);
            Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
            try {
                Item item = this.finder.getItem(userSession, path, true);
                if (item.isNode()) {
                    Node userNode = (Node)item;
                    CloudDrive local = this.cloudDrives.findDrive(userNode);
                    if (local == null) {
                        LOG.warn((Object)("Item " + workspace + ":" + path + " not a cloud file or drive not connected."));
                        Response response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                        return response;
                    }
                    try {
                        local.updateChangesLink();
                        String link = local.getChangesLink();
                        if (link != null) {
                            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"changesLink\":\"" + link + "\"}")).build();
                            return response;
                        }
                    }
                    catch (CloudDriveException e) {
                        LOG.error((Object)("Error getting changes link for drive " + workspace + ":" + path), (Throwable)e);
                        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Error getting changes link. " + e.getMessage())).build();
                        return response;
                    }
                    Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Changes link not provided").build();
                    return response;
                }
                LOG.warn((Object)("Item " + workspace + ":" + path + " not a node."));
                Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Not a node.").build();
                return response;
            }
            finally {
                userSession.logout();
            }
        }
        catch (LoginException e) {
            LOG.warn((Object)("Error login to read drive " + workspace + ":" + path + ". " + e.getMessage()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Authentication error.").build();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: storage error.").build();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading drive " + workspace + ":" + path), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error reading drive: runtime error.").build();
        }
    }
}

