/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CommandPoolExecutor {
    public static final long SYNC_PERIOD = 10000L;
    public static final long STOP_TIMEOUT = 40000L;
    public static final int MIN_THREADS = 2;
    protected static final Log LOG = ExoLogger.getLogger(CommandPoolExecutor.class);
    protected static CommandPoolExecutor singleton;
    private final ConcurrentHashMap<CloudDrive, Object> drives = new ConcurrentHashMap();
    private ExecutorService executor;

    public static CommandPoolExecutor getInstance() {
        if (singleton == null) {
            singleton = new CommandPoolExecutor();
        }
        return singleton;
    }

    private CommandPoolExecutor() {
    }

    public synchronized <S> Future<CloudDrive.Command> submit(String name, Callable<CloudDrive.Command> command) throws InterruptedException {
        this.init();
        return this.executor.submit(command);
    }

    public void stop() {
        this.stopSheduller();
    }

    private void init() throws InterruptedException {
        int cpus;
        int maxThreads;
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                if (!this.executor.isTerminated()) {
                    this.stopSheduller();
                    if (!this.executor.awaitTermination(40000L, TimeUnit.SECONDS)) {
                        LOG.warn((Object)("Cloud Drive scheduler (" + this.drives.size() + ") already shutdown but not yet terminated " + this.executor));
                    }
                }
            } else {
                return;
            }
        }
        maxThreads = (maxThreads = Math.round((float)(cpus = Runtime.getRuntime().availableProcessors()) * 25.0f)) > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 2 ? 2 : maxThreads;
        int queueSize = cpus * 4;
        queueSize = queueSize < 4 ? 4 : queueSize;
        LOG.info((Object)("Initializing command executor for max " + maxThreads + " threads, queue size " + queueSize));
        this.executor = new ThreadPoolExecutor(2, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void stopSheduller() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "clouddrive-command-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

                protected void finalize() throws Throwable {
                    super.finalize();
                    CommandThreadFactory.this.threadNumber.decrementAndGet();
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

