/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.exodrive.service;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveConfigurationException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveException;
import org.exoplatform.clouddrive.exodrive.service.ExoDriveRepository;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ExoDriveService
implements Startable {
    public static final String CONFIG_ROOT_DIR = "root-dir";
    public static final String CONFIG_BASE_URL = "base-url";
    public static final String PATTERN_REPOSITORY_CURRENT_NAME = "REPOSITORY_CURRENT_NAME";
    protected static final Log LOG = ExoLogger.getLogger(ExoDriveService.class);
    protected final Map<String, String> config;
    protected final Map<String, ExoDriveRepository> repositories = new HashMap<String, ExoDriveRepository>();
    protected final File storageRoot;
    protected final String baseUrl;
    protected final MimeTypeResolver mimeResolver;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExoDriveService(InitParams params) throws ExoDriveConfigurationException {
        PropertiesParam param = params.getPropertiesParam("storage-configuration");
        if (param == null) throw new ExoDriveConfigurationException("Property parameters storage-configuration required.");
        this.config = Collections.unmodifiableMap(param.getProperties());
        String baseUrl = this.config.get(CONFIG_BASE_URL);
        if (baseUrl == null) {
            throw new ExoDriveConfigurationException("Configuration of base-url required.");
        }
        this.baseUrl = baseUrl;
        String rootPath = this.config.get(CONFIG_ROOT_DIR);
        if (rootPath == null) throw new ExoDriveConfigurationException("Configuration of root-dir required.");
        this.storageRoot = new File(rootPath);
        if (!this.storageRoot.exists()) {
            this.storageRoot.mkdirs();
        }
        this.mimeResolver = new MimeTypeResolver();
        this.mimeResolver.setDefaultMimeType("application/octet-stream");
    }

    public ExoDriveRepository read(String name) throws ExoDriveException {
        ExoDriveRepository repo = this.repositories.get(name);
        if (repo == null) {
            File repoDir = new File(this.storageRoot, name);
            if (repoDir.exists()) {
                String repoUrl = this.baseUrl.replace(PATTERN_REPOSITORY_CURRENT_NAME, name);
                repo = new ExoDriveRepository(name, repoDir, repoUrl, this.mimeResolver);
                this.repositories.put(name, repo);
            } else {
                throw new ExoDriveException("eXo Drive repository not found " + name);
            }
        }
        return repo;
    }

    public ExoDriveRepository open(String name) throws ExoDriveConfigurationException {
        ExoDriveRepository repo = this.repositories.get(name);
        if (repo == null) {
            File repoDir = new File(this.storageRoot, name);
            repoDir.mkdirs();
            String repoUrl = this.baseUrl.replace(PATTERN_REPOSITORY_CURRENT_NAME, name);
            repo = new ExoDriveRepository(name, repoDir, repoUrl, this.mimeResolver);
            this.repositories.put(name, repo);
        }
        return repo;
    }

    public boolean remove(String name) throws ExoDriveConfigurationException {
        ExoDriveRepository repo = this.repositories.remove(name);
        if (repo != null) {
            return repo.getBaseDir().delete();
        }
        return true;
    }

    public void start() {
    }

    public void stop() {
    }
}

