/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.RefreshAccessException;

public class DriveInfo {
    final CloudProvider provider;
    final Map<String, CloudFile> files;
    final Collection<String> removed;
    final String workspace;
    final String path;
    final String user;
    final String email;
    final String title;
    final Object state;
    final boolean connected;

    DriveInfo(String title, String workspace, String path, String user, String email, Object state, boolean connected, CloudProvider provider, Map<String, CloudFile> files, Collection<String> removed) {
        this.title = title;
        this.workspace = workspace;
        this.path = path;
        this.user = user;
        this.email = email;
        this.state = state;
        this.connected = connected;
        this.provider = provider;
        this.files = files;
        this.removed = removed;
    }

    static DriveInfo create(String workspaces, CloudDrive drive, Collection<CloudFile> files, Collection<String> removed) throws DriveRemovedException, CloudProviderException, RepositoryException, RefreshAccessException {
        HashMap<String, CloudFile> driveFiles = new HashMap<String, CloudFile>();
        for (CloudFile cf : files) {
            driveFiles.put(cf.getPath(), cf);
        }
        return new DriveInfo(drive.getTitle(), workspaces, drive.getPath(), drive.getUser().getUsername(), drive.getUser().getEmail(), drive.getState(), drive.isConnected(), drive.getUser().getProvider(), driveFiles, removed);
    }

    static DriveInfo create(String workspaces, CloudDrive drive, Collection<CloudFile> files) throws DriveRemovedException, CloudProviderException, RepositoryException, RefreshAccessException {
        return DriveInfo.create(workspaces, drive, files, new HashSet<String>());
    }

    static DriveInfo create(String workspaces, CloudDrive drive) throws DriveRemovedException, CloudProviderException, RepositoryException, RefreshAccessException {
        return DriveInfo.create(workspaces, drive, new ArrayList<CloudFile>(), new HashSet<String>());
    }

    public CloudProvider getProvider() {
        return this.provider;
    }

    public Map<String, CloudFile> getFiles() {
        return this.files;
    }

    public Collection<String> getRemoved() {
        return this.removed;
    }

    public String getPath() {
        return this.path;
    }

    public String getUser() {
        return this.user;
    }

    public String getEmail() {
        return this.email;
    }

    public Object getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

