/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConfigurationException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.ProviderNotAvailableException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISConnector;
import org.exoplatform.clouddrive.cmis.CMISConnectorImpl;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.cmis.login.CodeAuthentication;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.sharepoint.JCRLocalSharepointDrive;
import org.exoplatform.clouddrive.sharepoint.SharepointAPI;
import org.exoplatform.clouddrive.sharepoint.SharepointUser;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;

public class SharepointConnector
extends CMISConnector
implements CMISConnectorImpl {
    public static final String SP_VENDORNAME = "Microsoft Corporation";
    public static final String SP_PRODUCTNAME = "Office SharePoint Server";
    public static final String SP_AUTHPROVIDERID = "cmis";

    public SharepointConnector(RepositoryService jcrService, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes, InitParams params, CodeAuthentication codeAuth) throws ConfigurationException {
        super(jcrService, sessionProviders, finder, mimeTypes, params, codeAuth);
    }

    public boolean hasSupport(RepositoryInfo repo) {
        return repo.getVendorName().equals(SP_VENDORNAME) && repo.getProductName().equals(SP_PRODUCTNAME);
    }

    public SharepointConnector getConnector() {
        return this;
    }

    protected SharepointAPI createAPI(CodeAuthentication.Identity userId) throws CMISException, CloudDriveException {
        return new API().auth(userId.getUser(), userId.getPassword()).serviceUrl(userId.getServiceURL()).build();
    }

    protected SharepointUser createUser(CodeAuthentication.Identity userId) throws CMISException, CloudDriveException {
        SharepointAPI spAPI = this.createAPI(userId);
        SharepointAPI.User user = spAPI.getSiteUser();
        return new SharepointUser(user.getId(), spAPI.getUser(), user.getEmail(), this.provider, spAPI);
    }

    protected CloudDrive createDrive(CloudUser user, Node driveNode) throws CloudDriveException, RepositoryException {
        if (user instanceof SharepointUser) {
            SharepointUser apiUser = (SharepointUser)user;
            JCRLocalSharepointDrive drive = new JCRLocalSharepointDrive(apiUser, driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes, this.exoURL());
            return drive;
        }
        throw new CloudDriveException("Not SharePoint user: " + user);
    }

    protected CloudDrive loadDrive(Node driveNode) throws DriveRemovedException, CloudDriveException, RepositoryException {
        JCRLocalSharepointDrive.checkNotTrashed((Node)driveNode);
        JCRLocalSharepointDrive.migrateName((Node)driveNode);
        JCRLocalSharepointDrive drive = new JCRLocalSharepointDrive(new API(), driveNode, this.sessionProviders, this.jcrFinder, this.mimeTypes, this.exoURL());
        return drive;
    }

    protected String getAuthProviderId() throws ConfigurationException {
        CloudDriveService cdService = (CloudDriveService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CloudDriveService.class);
        try {
            return cdService.getProvider(SP_AUTHPROVIDERID).getId();
        }
        catch (ProviderNotAvailableException e) {
            throw new ConfigurationException("Cannot initialize Office SharePoint Server connector: cmis provider not registered but required", (Throwable)e);
        }
    }

    protected class API
    extends CMISConnector.API {
        protected API() {
            super((CMISConnector)SharepointConnector.this);
        }

        protected API auth(String user, String password) {
            return (API)super.auth(user, password);
        }

        protected API serviceUrl(String serviceUrl) {
            return (API)super.serviceUrl(serviceUrl);
        }

        protected SharepointAPI build() throws CMISException, CloudDriveException {
            if (this.user == null || this.password == null) {
                throw new CloudDriveException("Cannot create API: user required");
            }
            if (this.serviceUrl == null) {
                throw new CloudDriveException("Cannot create API: service URL required");
            }
            return new SharepointAPI(this.serviceUrl, this.user, this.password);
        }

        protected SharepointUser createUser(String userId, String userName, String email, CMISAPI api) {
            return new SharepointUser(userId, userName, email, (CloudProvider)SharepointConnector.this.getProvider(), (SharepointAPI)api);
        }
    }
}

