/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.utils;

import com.box.boxjavalibv2.dao.BoxCollection;
import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.dao.BoxTypedObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static String getContainerString(BoxResourceType type) {
        switch (type) {
            case FILE_VERSION: {
                return "versions";
            }
        }
        return type.toPluralString();
    }

    public static <T extends BoxTypedObject> List<T> getTypedObjects(BoxCollection collection, Class<T> cls) {
        ArrayList<BoxTypedObject> objects = new ArrayList<BoxTypedObject>();
        ArrayList<BoxTypedObject> list = collection.getEntries();
        for (BoxTypedObject object : list) {
            if (!cls.isInstance(object)) continue;
            objects.add(object);
        }
        return objects;
    }

    public static void consumeHttpEntityQuietly(HttpEntity entity) {
        try {
            Utils.consumeHttpEntity(entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consumeHttpEntity(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }
}

