/*
 * Decompiled with CFR 0.152.
 */
package com.box.restclientv2.requestsbase;

import com.box.boxjavalibv2.exceptions.BoxJSONException;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.boxjavalibv2.jsonparsing.IBoxJSONParser;
import com.box.boxjavalibv2.requests.requestobjects.BoxRequestExtras;
import com.box.restclientv2.exceptions.BoxRestException;
import com.box.restclientv2.requestsbase.IBoxRequestObject;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

public class BoxDefaultRequestObject
implements IBoxRequestObject {
    private final MapJSONStringEntity jsonEntity = new MapJSONStringEntity();
    private final BoxRequestExtras requestExtras = new BoxRequestExtras();

    HttpEntity getEntity(IBoxJSONParser parser) throws BoxRestException, BoxJSONException, UnsupportedEncodingException {
        MapJSONStringEntity en = this.getJSONEntity();
        if (en == null) {
            return null;
        }
        try {
            return new StringEntity(en.toJSONString(parser), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRestException(e);
        }
    }

    protected MapJSONStringEntity getJSONEntity() {
        return this.jsonEntity;
    }

    public Object put(String key, Object value) {
        return this.getJSONEntity().put(key, value);
    }

    public Object getFromEntity(String key) {
        return this.getJSONEntity().get(key);
    }

    public BoxDefaultRequestObject setPage(int limit, int offset) {
        this.getRequestExtras().addQueryParam("limit", Integer.toString(limit));
        this.getRequestExtras().addQueryParam("offset", Integer.toString(offset));
        return this;
    }

    public BoxRequestExtras getRequestExtras() {
        return this.requestExtras;
    }
}

