/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.cmis.ecms.viewer.storage;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.jcr.RepositoryException;
import org.artofsolving.jodconverter.office.OfficeException;
import org.exoplatform.clouddrive.BaseCloudDriveListener;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveEvent;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudDriveListener;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.cmis.ContentReader;
import org.exoplatform.clouddrive.cmis.JCRLocalCMISDrive;
import org.exoplatform.clouddrive.cmis.ecms.viewer.storage.DocumentNotFoundException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.Stream;

public class PDFViewerStorage {
    private static final Log LOG = ExoLogger.getLogger(PDFViewerStorage.class);
    public static final int MAX_FILENAME_LENGTH = 180;
    public static final long FILE_LIVE_TIME = 43200000L;
    public static final String PAGE_IMAGE_TYPE = "image/png";
    public static final String PDF_TYPE = "application/pdf";
    public static final String PAGE_IMAGE_EXT = ".png";
    public static final String PDF_EXT = ".pdf";
    protected final ConcurrentHashMap<FileKey, PDFFile> spool = new ConcurrentHashMap();
    protected final JodConverterService jodConverter;
    protected final File rootDir;
    protected final ConcurrentHashMap<String, FilesCleaner> cleaners = new ConcurrentHashMap();

    public PDFViewerStorage(CacheService cacheService, JodConverterService jodConverter) throws IOException {
        String storageName = "CloudDrive.cmis." + PDFViewerStorage.class.getSimpleName();
        this.jodConverter = jodConverter;
        File probe = null;
        try {
            probe = File.createTempFile(storageName + "-" + System.currentTimeMillis(), ".temp");
            this.rootDir = new File(probe.getParentFile(), storageName);
            if (this.rootDir.exists()) {
                LOG.info((Object)("Cleaning PDFViewerStorage " + this.rootDir.getPath()));
                this.delete(this.rootDir);
            }
            this.rootDir.mkdir();
        }
        catch (IOException e) {
            LOG.error((Object)("Cannot create local PDF storage: " + e.getMessage()));
            throw e;
        }
        finally {
            if (probe != null) {
                probe.delete();
            }
        }
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.schedule(new Evicter(), 30L, TimeUnit.MINUTES);
    }

    public PDFFile getFile(String repository, String workspace, CloudDrive drive, String fileId) throws DriveRemovedException, RepositoryException {
        FileKey key = new FileKey(repository, workspace, drive.getLocalUser(), drive.getTitle(), fileId);
        return this.spool.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFFile createFile(String repository, String workspace, JCRLocalCMISDrive drive, CloudFile file) throws CloudDriveException, DriveRemovedException, RepositoryException, IOException {
        long lastModified = file.getModifiedDate().getTimeInMillis();
        String userId = drive.getLocalUser();
        FileKey key = new FileKey(repository, workspace, userId, drive.getTitle(), file.getId());
        PDFFile pdfFile = this.spool.get(key);
        if (pdfFile != null) {
            if (pdfFile.exists()) {
                if (lastModified > pdfFile.getLastModified()) {
                    if (pdfFile.remove()) {
                        pdfFile = null;
                    } else {
                        LOG.warn((Object)("Cannot remove PDF view of cloud file from the storage: " + file.getTitle()));
                    }
                }
            } else {
                this.spool.remove(key);
                pdfFile = null;
            }
        }
        if (pdfFile == null) {
            File tempFile;
            block30: {
                String baseFileName;
                StringBuilder filePath = new StringBuilder();
                filePath.append(repository);
                filePath.append(File.separatorChar);
                filePath.append(workspace);
                filePath.append(File.separatorChar);
                filePath.append(userId);
                File parent = new File(this.rootDir, filePath.toString());
                parent.mkdirs();
                StringBuilder fileName = new StringBuilder();
                String cleanName = this.extractName(file.getPath());
                fileName.append(cleanName);
                fileName.append('-');
                fileName.append(lastModified);
                String name = baseFileName = fileName.toString();
                long counter = 1L;
                tempFile = null;
                do {
                    File f;
                    if ((f = new File(parent, name)).exists()) {
                        name = baseFileName + "-" + counter++;
                        continue;
                    }
                    tempFile = f;
                } while (tempFile == null);
                try {
                    ContentReader content = drive.getFileContent(file.getId());
                    if (file.getType().startsWith(PDF_TYPE) || file.getType().startsWith("text/pdf") || file.getType().startsWith("application/x-pdf")) {
                        this.spoolToFile(content.getStream(), tempFile);
                    } else {
                        File origFile = new File(parent, name + "-tmp");
                        try {
                            this.spoolToFile(content.getStream(), origFile);
                            boolean success = this.jodConverter.convert(origFile, tempFile, "pdf");
                            if (!success) {
                                tempFile.delete();
                            }
                        }
                        catch (OfficeException e) {
                            tempFile.delete();
                            throw new IOException("Error converting office document " + file.getTitle() + " (" + cleanName + ")", e);
                        }
                        finally {
                            origFile.delete();
                        }
                    }
                    if (tempFile.exists()) {
                        FileInputStream tempStream = new FileInputStream(tempFile);
                        try {
                            Document pdf = this.buildDocumentImage(tempStream, tempFile.getName());
                            try {
                                pdfFile = new PDFFile(key, tempFile, cleanName, lastModified, pdf);
                                this.addDriveListener((CloudDrive)drive, pdfFile);
                                break block30;
                            }
                            finally {
                                pdf.dispose();
                            }
                        }
                        finally {
                            tempStream.close();
                        }
                    }
                    throw new DocumentNotFoundException("PDF file cannot be created due to previous errors.");
                }
                catch (IOException e) {
                    tempFile.delete();
                    throw e;
                }
                catch (CloudDriveException e) {
                    tempFile.delete();
                    throw e;
                }
                catch (RepositoryException e) {
                    tempFile.delete();
                    throw e;
                }
            }
            PDFFile alreadySpooled = this.spool.putIfAbsent(key, pdfFile);
            if (alreadySpooled != null) {
                pdfFile = alreadySpooled;
                tempFile.delete();
            }
        }
        return pdfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolToFile(InputStream sourceStream, File destFile) throws IOException {
        ReadableByteChannel source = Channels.newChannel(sourceStream);
        FileOutputStream destStream = new FileOutputStream(destFile);
        WritableByteChannel dest = Channels.newChannel(destStream);
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
            while (source.read(buffer) >= 0 || buffer.position() != 0) {
                buffer.flip();
                dest.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                dest.write(buffer);
            }
        }
        finally {
            source.close();
            sourceStream.close();
            dest.close();
            ((OutputStream)destStream).close();
        }
    }

    private Document buildDocumentImage(InputStream input, String name) throws IOException {
        Document document = new Document();
        Logger.getLogger(Document.class.toString()).setLevel(Level.OFF);
        try {
            document.setInputStream(input, name);
        }
        catch (PDFException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing PDF document " + (Object)((Object)ex)));
            }
            throw new IOException("Error parsing PDF document " + name, ex);
        }
        catch (PDFSecurityException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error encryption not supported " + (Object)((Object)ex)));
            }
            throw new IOException("Error parsing PDF document " + name, ex);
        }
        catch (IOException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error handling PDF document: {} {}", new Object[]{name, ex.toString()});
            }
            throw new IOException("Error handling PDF document " + name, ex);
        }
        return document;
    }

    /*
     * Loose catch block
     */
    private File buildFileImage(File input, int page, float rotation, float scale) throws IOException {
        FileInputStream inputStream = new FileInputStream(input);
        try {
            File parent = input.getParentFile();
            StringBuilder fileName = new StringBuilder();
            fileName.append(input.getName());
            fileName.append('-');
            fileName.append(page);
            fileName.append(',');
            fileName.append(rotation);
            fileName.append(',');
            fileName.append(scale);
            String baseFileName = fileName.toString();
            String name = baseFileName + PAGE_IMAGE_EXT;
            long counter = 1L;
            File file = null;
            do {
                File f;
                if ((f = new File(parent, name)).exists()) {
                    name = baseFileName + "-" + counter++ + PAGE_IMAGE_EXT;
                    continue;
                }
                file = f;
            } while (file == null);
            Document document = this.buildDocumentImage(inputStream, name);
            Logger.getLogger(Stream.class.toString()).setLevel(Level.OFF);
            BufferedImage image = (BufferedImage)document.getPageImage(page - 1, 1, 2, rotation, scale);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
                image.flush();
                File file2 = file;
                return file2;
            }
            catch (IOException e) {
                file.delete();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error captiring page image " + input.getName()), (Throwable)e);
                }
                throw new IOException("Error captiring page image " + input.getName(), e);
            }
            finally {
                document.dispose();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    private boolean delete(File dir) {
        boolean res = true;
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                res &= this.delete(child);
            }
        }
        if (!res) {
            LOG.warn((Object)("Child files not removed fully for " + dir.getAbsolutePath()));
        }
        return dir.delete();
    }

    private String extractName(String nodePath) {
        int nameIndex = nodePath.lastIndexOf("/");
        int pathLen = nodePath.length();
        String name = nameIndex >= 0 && pathLen > 1 && nameIndex < pathLen - 1 ? nodePath.substring(nameIndex + 1) : nodePath;
        String cleanName = JCRLocalCloudDrive.cleanName((String)name);
        return cleanName.length() > 180 ? cleanName.substring(0, 180) : cleanName;
    }

    private String previewFileName(String name) {
        return name + PDF_EXT;
    }

    private void addDriveListener(CloudDrive drive, PDFFile file) throws DriveRemovedException, RepositoryException {
        FilesCleaner cleaner = this.cleaners.get(drive.getPath());
        if (cleaner == null) {
            cleaner = new FilesCleaner();
            drive.addListener((CloudDriveListener)cleaner);
        }
        cleaner.addFile(file);
    }

    protected class FilesCleaner
    extends BaseCloudDriveListener {
        final Map<String, PDFFile> files = new ConcurrentHashMap<String, PDFFile>();

        protected FilesCleaner() {
        }

        void addFile(PDFFile file) {
            PDFFile prev = this.files.put(file.getName(), file);
            if (prev != null) {
                prev.remove();
            }
        }

        void removeFile(PDFFile file) {
            this.files.remove(file.getName());
        }

        void cleanAll() {
            Iterator<PDFFile> fiter = this.files.values().iterator();
            while (fiter.hasNext()) {
                PDFFile file = fiter.next();
                if (file.remove()) {
                    PDFViewerStorage.this.spool.remove(file.key);
                    fiter.remove();
                    continue;
                }
                LOG.warn((Object)("Cannot remove preview file: " + file.getName()));
            }
        }

        void cleanFile(String name) {
            PDFFile file = this.files.get(name);
            if (file != null) {
                if (file.remove()) {
                    PDFViewerStorage.this.spool.remove(file.key);
                    this.files.remove(name);
                } else {
                    LOG.warn((Object)("Cannot remove preview file: " + file.getName()));
                }
            }
        }

        public void onDisconnect(CloudDriveEvent event) {
            this.cleanAll();
        }

        public void onRemove(CloudDriveEvent event) {
            this.cleanAll();
        }

        public void onSynchronized(CloudDriveEvent event) {
            for (CloudFile cfile : event.getChanged()) {
                this.cleanFile(PDFViewerStorage.this.extractName(cfile.getPath()));
            }
            for (String rpath : event.getRemoved()) {
                this.cleanFile(PDFViewerStorage.this.extractName(rpath));
            }
        }
    }

    protected class Evicter
    implements Runnable {
        protected Evicter() {
        }

        @Override
        public void run() {
            Iterator<PDFFile> fiter = PDFViewerStorage.this.spool.values().iterator();
            while (fiter.hasNext()) {
                PDFFile file = fiter.next();
                if (System.currentTimeMillis() - file.lastAcccessed <= 43200000L || !file.remove()) continue;
                fiter.remove();
            }
        }
    }

    public class PDFFile
    implements ContentReader {
        protected final FileKey key;
        protected final File file;
        protected final String name;
        protected final long lastModified;
        protected final int numberOfPages;
        protected final Map<String, String> metadata = new HashMap<String, String>();
        protected final ConcurrentHashMap<PageKey, ImageFile> pages = new ConcurrentHashMap();
        protected long lastAcccessed;

        protected PDFFile(FileKey key, File file, String name, long lastModified, Document document) {
            this.key = key;
            this.name = name;
            this.file = file;
            this.lastModified = lastModified;
            this.numberOfPages = document.getNumberOfPages();
            this.putDocumentInfo(document.getInfo());
            this.touch();
        }

        private long touch() {
            this.lastAcccessed = System.currentTimeMillis();
            return this.lastAcccessed;
        }

        private void putDocumentInfo(PInfo documentInfo) {
            if (documentInfo != null) {
                if (documentInfo.getTitle() != null && documentInfo.getTitle().length() > 0) {
                    this.metadata.put("title", documentInfo.getTitle());
                }
                if (documentInfo.getAuthor() != null && documentInfo.getAuthor().length() > 0) {
                    this.metadata.put("author", documentInfo.getAuthor());
                }
                if (documentInfo.getSubject() != null && documentInfo.getSubject().length() > 0) {
                    this.metadata.put("subject", documentInfo.getSubject());
                }
                if (documentInfo.getKeywords() != null && documentInfo.getKeywords().length() > 0) {
                    this.metadata.put("keyWords", documentInfo.getKeywords());
                }
                if (documentInfo.getCreator() != null && documentInfo.getCreator().length() > 0) {
                    this.metadata.put("creator", documentInfo.getCreator());
                }
                if (documentInfo.getProducer() != null && documentInfo.getProducer().length() > 0) {
                    this.metadata.put("producer", documentInfo.getProducer());
                }
                if (documentInfo.getCreationDate() != null) {
                    this.metadata.put("creationDate", documentInfo.getCreationDate().toString());
                }
                if (documentInfo.getModDate() != null) {
                    this.metadata.put("modDate", documentInfo.getModDate().toString());
                }
            }
        }

        public boolean remove() {
            boolean res = true;
            for (ImageFile pageFile : this.pages.values()) {
                res &= pageFile.delete();
            }
            return res ? this.file.delete() : false;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public int getNumberOfPages() {
            return this.numberOfPages;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLastAcccessed() {
            return this.lastAcccessed;
        }

        public String getName() {
            return this.name;
        }

        public ImageFile getPageImage(int page, float rotation, float scale) throws IOException {
            this.touch();
            PageKey key = new PageKey(page, Float.valueOf(rotation), Float.valueOf(scale));
            ImageFile pageFile = this.pages.get(key);
            if (pageFile == null) {
                File image = PDFViewerStorage.this.buildFileImage(this.file, page, rotation, scale);
                ImageFile imageFile = new ImageFile(image, this.name + "-" + key + PDFViewerStorage.PAGE_IMAGE_EXT, PDFViewerStorage.PAGE_IMAGE_TYPE);
                ImageFile alreadyCreated = this.pages.putIfAbsent(key, imageFile);
                if (alreadyCreated != null) {
                    pageFile = alreadyCreated;
                    imageFile.delete();
                } else {
                    pageFile = imageFile;
                }
            }
            return pageFile;
        }

        @Override
        public InputStream getStream() {
            this.touch();
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new DocumentNotFoundException("Document file not found: " + this.file.getAbsolutePath(), e);
            }
        }

        @Override
        public String getMimeType() {
            return PDFViewerStorage.PDF_TYPE;
        }

        @Override
        public String getTypeMode() {
            return null;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof PDFFile) {
                PDFFile other = (PDFFile)obj;
                return this.file.equals(other.file);
            }
            return false;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public class ImageFile {
            protected final File file;
            protected final String name;
            protected final String type;

            protected ImageFile(File file, String name, String type) {
                this.file = file;
                this.name = name;
                this.type = type;
            }

            public long getLength() {
                return this.file.length();
            }

            public String getType() {
                return this.type;
            }

            public String getName() {
                return this.name;
            }

            public InputStream getStream() {
                try {
                    return new FileInputStream(this.file);
                }
                catch (FileNotFoundException e) {
                    throw new DocumentNotFoundException("Page image file not found: " + this.file.getAbsolutePath(), e);
                }
            }

            protected boolean delete() {
                return this.file.delete();
            }
        }

        protected class PageKey {
            protected final Integer page;
            protected final Float rotation;
            protected final Float scale;
            protected final int hashCode;

            protected PageKey(Integer page, Float rotation, Float scale) {
                this.page = page;
                this.rotation = rotation;
                this.scale = scale;
                int hc = 1;
                hc = hc * 31 + page.hashCode();
                hc = hc * 31 + rotation.hashCode();
                this.hashCode = hc = hc * 31 + scale.hashCode();
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object obj) {
                if (obj != null && obj instanceof PageKey) {
                    PageKey other = (PageKey)obj;
                    return this.page.equals(other.page) && this.rotation.equals(other.rotation) && this.scale.equals(other.scale);
                }
                return false;
            }

            public String toString() {
                StringBuilder key = new StringBuilder();
                key.append(this.page);
                key.append(',');
                key.append(this.rotation);
                key.append(',');
                key.append(this.scale);
                return key.toString();
            }
        }
    }

    protected class FileKey
    implements Serializable {
        private static final long serialVersionUID = -1075842770973938557L;
        protected final String repository;
        protected final String workspace;
        protected final String username;
        protected final String driveName;
        protected final String fileId;
        protected final int hashCode;

        protected FileKey(String repository, String workspace, String username, String driveName, String fileId) {
            this.repository = repository;
            this.workspace = workspace;
            this.username = username;
            this.driveName = driveName;
            this.fileId = fileId;
            int hc = 1;
            hc = hc * 31 + repository.hashCode();
            hc = hc * 31 + workspace.hashCode();
            hc = hc * 31 + username.hashCode();
            hc = hc * 31 + driveName.hashCode();
            this.hashCode = hc = hc * 31 + fileId.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FileKey) {
                FileKey other = (FileKey)obj;
                return this.repository.equals(other.repository) && this.workspace.equals(other.workspace) && this.username.equals(other.username) && this.driveName.equals(other.driveName) && this.fileId.equals(other.fileId);
            }
            return false;
        }

        public String toString() {
            StringBuilder key = new StringBuilder();
            key.append(this.repository);
            key.append(File.separatorChar);
            key.append(this.workspace);
            key.append(File.separatorChar);
            key.append(this.username);
            key.append(File.separatorChar);
            key.append(this.driveName);
            key.append(File.separatorChar);
            key.append(this.fileId);
            return key.toString();
        }
    }
}

