/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.clipboard;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlink;
import org.exoplatform.clouddrive.ecms.symlink.CloudFileSymlinkException;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.PasteManageComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.event.Event;

@ComponentConfig(events={@EventConfig(listeners={PasteActionListener.class})})
public class CloudDrivePasteManageComponent
extends PasteManageComponent {
    protected static final Log LOG = ExoLogger.getLogger(CloudDrivePasteManageComponent.class);

    public static class PasteActionListener
    extends PasteManageComponent.PasteActionListener {
        public void processEvent(Event<PasteManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((PasteManageComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            CloudFileSymlink symlinks = new CloudFileSymlink(uiExplorer);
            try {
                String destParam = event.getRequestContext().getRequestParameter("objectId");
                if (destParam == null) {
                    symlinks.setDestination(uiExplorer.getCurrentNode());
                } else {
                    symlinks.setDestination(destParam);
                }
                LinkedList allClipboards = uiExplorer.getAllClipBoard();
                if (allClipboards.size() > 0) {
                    UIWorkingArea uiWorkingArea = (UIWorkingArea)((PasteManageComponent)event.getSource()).getParent();
                    List virtClipboards = uiWorkingArea.getVirtualClipboards();
                    ClipboardCommand current2 = null;
                    if (virtClipboards.isEmpty()) {
                        current2 = (ClipboardCommand)allClipboards.getLast();
                        boolean isCut = "cut".equals(current2.getType());
                        symlinks.addSource(current2.getWorkspace(), current2.getSrcPath());
                        if (isCut) {
                            symlinks.move();
                        }
                        if (symlinks.create()) {
                            symlinks.getDestinationNode().getSession().save();
                            if (isCut) {
                                virtClipboards.clear();
                                allClipboards.remove(current2);
                            }
                            uiExplorer.updateAjax(event);
                            return;
                        }
                    } else {
                        int virtSize = virtClipboards.size();
                        LinkedHashSet<ClipboardCommand> linked = new LinkedHashSet<ClipboardCommand>();
                        Boolean isCut = null;
                        for (ClipboardCommand current2 : virtClipboards) {
                            boolean isThisCut = "cut".equals(current2.getType());
                            if (isCut == null) {
                                isCut = isThisCut;
                            }
                            if (isCut.equals(isThisCut)) {
                                symlinks.addSource(current2.getWorkspace(), current2.getSrcPath());
                                linked.add(current2);
                                continue;
                            }
                            LOG.warn((Object)("Cannot handle different types of clipboard operations for group action. Files " + (isCut != false ? " cut-paste" : " copy-paste") + " already started but " + (isThisCut ? " cut-paste" : " copy-paste") + " found for " + current2.getSrcPath()));
                            break;
                        }
                        if (virtSize == linked.size()) {
                            if (isCut != null && isCut.booleanValue()) {
                                symlinks.move();
                            }
                            if (symlinks.create()) {
                                symlinks.getDestinationNode().getSession().save();
                                if (isCut.booleanValue()) {
                                    virtClipboards.clear();
                                    for (ClipboardCommand c : linked) {
                                        allClipboards.remove(c);
                                    }
                                }
                                uiExplorer.updateAjax(event);
                                return;
                            }
                        } else {
                            symlinks.getDestinationNode().getSession().refresh(false);
                            LOG.warn((Object)("Links cannot be created for all cloud files. Destination " + symlinks.getDestonationPath() + "." + (current2 != null ? " Last file " + current2.getSrcPath() + "." : "") + " Default behaviour will be applied (files Paste)."));
                        }
                    }
                }
            }
            catch (CloudFileSymlinkException e) {
                LOG.warn((Object)e.getMessage());
                UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(e.getUIMessage());
                symlinks.getDestinationNode().getSession().refresh(false);
                uiExplorer.updateAjax(event);
                return;
            }
            catch (Exception e) {
                LOG.warn((Object)"Error creating link of cloud file. Default behaviour will be applied (file Paste).", (Throwable)e);
            }
            super.processEvent(event);
        }
    }
}

