/*
 * Decompiled with CFR 0.152.
 */
package com.box.boxjavalibv2.requests.requestobjects;

import com.box.boxjavalibv2.dao.BoxResourceType;
import com.box.boxjavalibv2.jsonentities.MapJSONStringEntity;
import com.box.restclientv2.requestsbase.BoxDefaultRequestObject;
import org.apache.commons.lang.StringUtils;

public class BoxCollabRequestObject
extends BoxDefaultRequestObject {
    private BoxCollabRequestObject() {
    }

    public static BoxCollabRequestObject createCollabObject(String folderId, String userId, String login, String role) {
        BoxCollabRequestObject entity = new BoxCollabRequestObject();
        MapJSONStringEntity item = BoxCollabRequestObject.getItemEntity(folderId);
        entity.setAccessibleBy(userId, login);
        entity.setItem(item);
        entity.setRole(role);
        return entity;
    }

    public BoxCollabRequestObject setAccessibleBy(String userId, String login) {
        MapJSONStringEntity accessibleBy = BoxCollabRequestObject.getAccessibilityEntity(userId, login);
        this.put("accessible_by", accessibleBy);
        return this;
    }

    public static BoxCollabRequestObject updateCollabObjects(String role) {
        BoxCollabRequestObject obj = new BoxCollabRequestObject();
        return obj.setRole(role);
    }

    private BoxCollabRequestObject setItem(MapJSONStringEntity item) {
        this.put("item", item);
        return this;
    }

    public BoxCollabRequestObject setRole(String role) {
        this.put("role", role);
        return this;
    }

    public BoxCollabRequestObject setStatus(String status) {
        this.getRequestExtras().addQueryParam("status", status);
        return this;
    }

    private static MapJSONStringEntity getItemEntity(String folderId) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        entity.put("id", folderId);
        entity.put("type", BoxResourceType.FOLDER.toString());
        return entity;
    }

    private static MapJSONStringEntity getAccessibilityEntity(String userId, String login) {
        MapJSONStringEntity entity = new MapJSONStringEntity();
        if (StringUtils.isNotEmpty((String)userId)) {
            entity.put("id", userId);
        }
        entity.put("login", login);
        return entity;
    }
}

