/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxEvent;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.EventListener;
import com.box.sdk.LRUCache;
import com.box.sdk.RealtimeServerConnection;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;

public class EventStream {
    private static final int LIMIT = 800;
    private static final URLTemplate EVENT_URL = new URLTemplate("events?limit=800&stream_position=%s");
    private static final int STREAM_POSITION_NOW = -1;
    private final BoxAPIConnection api;
    private final long startingPosition;
    private final Collection<EventListener> listeners;
    private final Object listenerLock;
    private LRUCache<String> receivedEvents;
    private boolean started;
    private Poller poller;
    private Thread pollerThread;

    public EventStream(BoxAPIConnection api) {
        this(api, -1L);
    }

    public EventStream(BoxAPIConnection api, long startingPosition) {
        this.api = api;
        this.startingPosition = startingPosition;
        this.listeners = new ArrayList<EventListener>();
        this.listenerLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Cannot stop the EventStream because it isn't started.");
        }
        this.started = false;
        this.pollerThread.interrupt();
    }

    public void start() {
        long initialPosition;
        if (this.started) {
            throw new IllegalStateException("Cannot start the EventStream because it isn't stopped.");
        }
        if (this.startingPosition == -1L) {
            BoxAPIRequest request = new BoxAPIRequest(this.api, EVENT_URL.build(this.api.getBaseURL(), "now"), "GET");
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
            initialPosition = jsonObject.get("next_stream_position").asLong();
        } else {
            initialPosition = this.startingPosition;
        }
        this.poller = new Poller(initialPosition);
        this.pollerThread = new Thread(this.poller);
        this.pollerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                EventStream.this.notifyException(e);
            }
        });
        this.pollerThread.start();
        this.started = true;
    }

    protected boolean isDuplicate(String eventID) {
        if (this.receivedEvents == null) {
            this.receivedEvents = new LRUCache();
        }
        return !this.receivedEvents.add(eventID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNextPosition(long position) {
        Object object = this.listenerLock;
        synchronized (object) {
            for (EventListener listener : this.listeners) {
                listener.onNextPosition(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(BoxEvent event) {
        Object object = this.listenerLock;
        synchronized (object) {
            boolean isDuplicate = this.isDuplicate(event.getID());
            if (!isDuplicate) {
                for (EventListener listener : this.listeners) {
                    listener.onEvent(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyException(Throwable e) {
        if (e instanceof InterruptedException && !this.started) {
            return;
        }
        this.stop();
        Object object = this.listenerLock;
        synchronized (object) {
            for (EventListener listener : this.listeners) {
                if (!listener.onException(e)) continue;
                return;
            }
        }
    }

    private class Poller
    implements Runnable {
        private final long initialPosition;
        private RealtimeServerConnection server;

        public Poller(long initialPosition) {
            this.initialPosition = initialPosition;
            this.server = new RealtimeServerConnection(EventStream.this.api);
        }

        @Override
        public void run() {
            long position = this.initialPosition;
            while (!Thread.interrupted()) {
                if (this.server.getRemainingRetries() == 0) {
                    this.server = new RealtimeServerConnection(EventStream.this.api);
                }
                if (!this.server.waitForChange(position)) continue;
                if (Thread.interrupted()) {
                    return;
                }
                BoxAPIRequest request = new BoxAPIRequest(EventStream.this.api, EVENT_URL.build(EventStream.this.api.getBaseURL(), position), "GET");
                BoxJSONResponse response = (BoxJSONResponse)request.send();
                JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
                JsonArray entriesArray = jsonObject.get("entries").asArray();
                for (JsonValue entry : entriesArray) {
                    BoxEvent event = new BoxEvent(EventStream.this.api, entry.asObject());
                    EventStream.this.notifyEvent(event);
                }
                position = jsonObject.get("next_stream_position").asLong();
                EventStream.this.notifyNextPosition(position);
            }
        }
    }
}

