/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.utils;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.security.IdentityConstants;

public class IdentityHelper {
    public static final String ROOT_USER_ID = "root";
    public static final String SYSTEM_USER_ID = IdentityConstants.SYSTEM;
    public static final String EXO_OWNEABLE = "exo:owneable";
    public static final String EXO_USER = "exo:owner";

    private IdentityHelper() {
    }

    public static boolean isUserMatch(String user1, String user2) {
        return user1.equals(user2) || ROOT_USER_ID.equals(user1) || SYSTEM_USER_ID.equals(user1) || ROOT_USER_ID.equals(user2) || SYSTEM_USER_ID.equals(user2);
    }

    public static Node ensureOwned(Node node, Session systemSession) throws PathNotFoundException, RepositoryException {
        String currentUser = node.getSession().getUserID();
        if (!currentUser.equals(SYSTEM_USER_ID) && node.isNodeType(EXO_OWNEABLE) && node.getProperty(EXO_USER).getString().equals(SYSTEM_USER_ID)) {
            Node snode = (Node)systemSession.getItem(node.getPath());
            snode.removeMixin(EXO_OWNEABLE);
            snode.save();
            node.refresh(true);
            node.addMixin(EXO_OWNEABLE);
            node.save();
        }
        return node;
    }

    public static boolean hasPermission(AccessControlList acl, String identity, String type) {
        if (acl.hasPermissions()) {
            for (String idp : acl.getPermissions(identity)) {
                if (!idp.equals(type)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

