/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public abstract class AbstractCloudDriveNodeFilter
implements UIExtensionFilter {
    protected long minSize;
    protected long maxSize;
    protected List<String> providers;

    public AbstractCloudDriveNodeFilter() {
        this(Collections.emptyList());
    }

    public AbstractCloudDriveNodeFilter(List<String> providers) {
        this(providers, 0L, Long.MAX_VALUE);
    }

    public AbstractCloudDriveNodeFilter(long minSize, long maxSize) {
        this(Collections.emptyList(), minSize, maxSize);
    }

    public AbstractCloudDriveNodeFilter(List<String> providers, long minSize, long maxSize) {
        this.providers = providers;
        this.minSize = minSize >= 0L ? minSize : 0L;
        this.maxSize = maxSize;
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        if (context == null) {
            return true;
        }
        boolean accepted = false;
        Node contextNode = (Node)context.get(Node.class.getName());
        if (contextNode == null) {
            WebuiRequestContext reqContext;
            UIApplication uiApp;
            UIJcrExplorerContainer jcrExplorerContainer;
            UIJCRExplorer uiExplorer = (UIJCRExplorer)context.get(UIJCRExplorer.class.getName());
            if (uiExplorer != null) {
                contextNode = uiExplorer.getCurrentNode();
            }
            if (contextNode == null && (jcrExplorerContainer = (UIJcrExplorerContainer)(uiApp = (reqContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getUIApplication()).getChild(UIJcrExplorerContainer.class)) != null) {
                UIJCRExplorer jcrExplorer = (UIJCRExplorer)jcrExplorerContainer.getChild(UIJCRExplorer.class);
                contextNode = jcrExplorer.getCurrentNode();
            }
        }
        if (contextNode != null) {
            accepted = this.accept(contextNode);
        }
        return accepted;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
    }

    protected boolean acceptProvider(CloudProvider provider) {
        if (this.providers.size() > 0) {
            boolean accepted = this.providers.contains(provider.getId());
            return accepted;
        }
        return true;
    }

    protected abstract boolean accept(Node var1) throws RepositoryException;
}

