/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.StandardCharsets;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class BoxJSONResponse
extends BoxAPIResponse {
    private static final int BUFFER_SIZE = 8192;
    private String json;

    public BoxJSONResponse() {
    }

    public BoxJSONResponse(HttpURLConnection connection) {
        super(connection);
    }

    public String getJSON() {
        if (this.json != null) {
            return this.json;
        }
        InputStreamReader reader = new InputStreamReader(this.getBody(), StandardCharsets.UTF_8);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[8192];
        try {
            int read = reader.read(buffer, 0, 8192);
            while (read != -1) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer, 0, 8192);
            }
            this.disconnect();
            reader.close();
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        this.json = builder.toString();
        return this.json;
    }

    @Override
    protected String bodyToString() {
        String bodyString = super.bodyToString();
        if (bodyString == null) {
            return this.getJSON();
        }
        return bodyString;
    }
}

