/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.auth.oauth2;

import java.io.IOException;
import java.util.Map;
import org.exoplatform.shaded.google.api.client.http.HttpExecuteInterceptor;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.UrlEncodedContent;
import org.exoplatform.shaded.google.api.client.util.Data;
import org.exoplatform.shaded.google.api.client.util.Preconditions;

public class ClientParametersAuthentication
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final String clientId;
    private final String clientSecret;

    public ClientParametersAuthentication(String clientId, String clientSecret) {
        this.clientId = Preconditions.checkNotNull(clientId);
        this.clientSecret = clientSecret;
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    public void intercept(HttpRequest request) throws IOException {
        Map<String, Object> data = Data.mapOf(UrlEncodedContent.getContent(request).getData());
        data.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            data.put("client_secret", this.clientSecret);
        }
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientSecret() {
        return this.clientSecret;
    }
}

