/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.v2.files.DeletedMetadata;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FileSharingInfo;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.sharing.SharedLinkMetadata;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.CloudFileAPI;
import org.exoplatform.clouddrive.CloudProviderException;
import org.exoplatform.clouddrive.CloudUser;
import org.exoplatform.clouddrive.ConflictException;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.LocalFileNotFoundException;
import org.exoplatform.clouddrive.NotAcceptableException;
import org.exoplatform.clouddrive.NotFoundException;
import org.exoplatform.clouddrive.RefreshAccessException;
import org.exoplatform.clouddrive.RetryLaterException;
import org.exoplatform.clouddrive.SyncNotSupportedException;
import org.exoplatform.clouddrive.dropbox.DropboxAPI;
import org.exoplatform.clouddrive.dropbox.DropboxConnector;
import org.exoplatform.clouddrive.dropbox.DropboxException;
import org.exoplatform.clouddrive.dropbox.DropboxProvider;
import org.exoplatform.clouddrive.dropbox.DropboxUser;
import org.exoplatform.clouddrive.dropbox.ResetCursorException;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudDrive;
import org.exoplatform.clouddrive.jcr.JCRLocalCloudFile;
import org.exoplatform.clouddrive.jcr.NodeFinder;
import org.exoplatform.clouddrive.oauth2.UserToken;
import org.exoplatform.clouddrive.oauth2.UserTokenRefreshListener;
import org.exoplatform.clouddrive.rest.ContentService;
import org.exoplatform.clouddrive.utils.ChunkIterator;
import org.exoplatform.clouddrive.utils.ExtendedMimeTypeResolver;
import org.exoplatform.clouddrive.viewer.CloudFileContent;
import org.exoplatform.clouddrive.viewer.ContentReader;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.Log;

public class JCRLocalDropboxDrive
extends JCRLocalCloudDrive
implements UserTokenRefreshListener {
    public static final String FOLDER_REV = "".intern();
    public static final String FOLDER_TYPE = "folder".intern();
    protected DropboxState state;

    protected JCRLocalDropboxDrive(DropboxUser user, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws CloudDriveException, RepositoryException {
        super((CloudUser)user, driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
    }

    protected JCRLocalDropboxDrive(DropboxConnector.API apiFactory, DropboxProvider provider, Node driveNode, SessionProviderService sessionProviders, NodeFinder finder, ExtendedMimeTypeResolver mimeTypes) throws RepositoryException, CloudDriveException {
        super((CloudUser)JCRLocalDropboxDrive.loadUser(apiFactory, provider, driveNode), driveNode, sessionProviders, finder, mimeTypes);
        this.getUser().api().getToken().addListener(this);
        try {
            String cursor = driveNode.getProperty("dropbox:cursor").getString();
            this.updateState(cursor);
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)("Drive node exists but delta cursor not found for " + this.title() + ": " + e.getMessage()));
        }
    }

    protected void initDrive(Node driveNode) throws CloudDriveException, RepositoryException {
        super.initDrive(driveNode);
        driveNode.setProperty("ecd:id", DropboxAPI.ROOT_PATH_V2);
        driveNode.setProperty("ecd:url", "https://www.dropbox.com/home");
        this.initDropboxPath(driveNode, DropboxAPI.ROOT_PATH_V2);
    }

    protected void updateState(String cursor) {
        this.state = new DropboxState(cursor);
    }

    protected static DropboxUser loadUser(DropboxConnector.API apiFactory, DropboxProvider provider, Node driveNode) throws RepositoryException, DropboxException, CloudDriveException {
        String username = driveNode.getProperty("ecd:cloudUserName").getString();
        String email = driveNode.getProperty("ecd:userEmail").getString();
        String userId = driveNode.getProperty("ecd:cloudUserId").getString();
        String accessToken = driveNode.getProperty("dropbox:oauth2AccessToken").getString();
        DropboxAPI driveAPI = apiFactory.load(accessToken).build();
        return new DropboxUser(userId, username, email, provider, driveAPI);
    }

    public void onUserTokenRefresh(UserToken token) throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                driveNode.setProperty("dropbox:oauth2AccessToken", token.getAccessToken());
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error updating access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public void onUserTokenRemove() throws CloudDriveException {
        try {
            this.jcrListener.disable();
            Node driveNode = this.rootNode();
            try {
                if (driveNode.hasProperty("dropbox:oauth2AccessToken")) {
                    driveNode.getProperty("dropbox:oauth2AccessToken").remove();
                }
                driveNode.save();
            }
            catch (RepositoryException e) {
                this.rollback(driveNode);
                throw new CloudDriveException("Error removing access key: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (DriveRemovedException e) {
            throw new CloudDriveException("Error openning drive node: " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new CloudDriveException("Error reading drive node: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
    }

    public ContentReader getFileContent(String idPath) throws RepositoryException, CloudDriveException {
        DropboxAPI api = this.getUser().api();
        DbxDownloader<FileMetadata> downloader = api.getContent(idPath);
        MetadataInfo item = this.itemInfo((Metadata)downloader.getResult());
        if (item.isFile()) {
            FileInfo file = item.asFile();
            String type = this.findMimetype(file.getTitle());
            String typeMode = this.mimeTypes.getMimeTypeMode(type, file.getTitle());
            return new CloudFileContent(downloader.getInputStream(), type, typeMode, file.getSize());
        }
        LOG.warn((Object)("File content request returned non file item: " + item));
        return null;
    }

    public CloudDrive.FilesState getState() throws DriveRemovedException, RefreshAccessException, CloudProviderException, RepositoryException {
        return this.state;
    }

    public boolean isSharingSupported() {
        return true;
    }

    public void shareFile(Node fileNode, String ... users) throws RepositoryException, CloudDriveException {
        this.createSharedLink(fileNode);
    }

    protected JCRLocalCloudDrive.ConnectCommand getConnectCommand() throws DriveRemovedException, RepositoryException {
        return new Connect();
    }

    protected JCRLocalCloudDrive.SyncCommand getSyncCommand() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new EventsSync();
    }

    protected CloudFileAPI createFileAPI() throws DriveRemovedException, SyncNotSupportedException, RepositoryException {
        return new FileAPI();
    }

    protected Long readChangeId() throws RepositoryException, CloudDriveException {
        try {
            return this.rootNode().getProperty("dropbox:changePosition").getLong();
        }
        catch (PathNotFoundException e) {
            throw new CloudDriveException("Change id not found for the drive " + this.title(), (Throwable)e);
        }
    }

    protected void saveChangeId(Long id) throws CloudDriveException, RepositoryException {
        Node driveNode = this.rootNode();
        driveNode.setProperty("dropbox:changePosition", id.longValue());
        driveNode.setProperty("dropbox:changeDate", Calendar.getInstance());
    }

    public DropboxUser getUser() {
        return (DropboxUser)this.user;
    }

    protected void refreshAccess() throws CloudDriveException {
    }

    protected void updateAccess(CloudUser newUser) throws CloudDriveException, RepositoryException {
        this.getUser().api().updateToken(((DropboxUser)newUser).api().getToken());
    }

    protected void fixNameConflict(Node file) throws RepositoryException {
        super.fixNameConflict(file);
        this.normalizeName(file);
    }

    protected void normalizeName(Node fileNode) throws RepositoryException {
        String jcrName = fileNode.getName();
        String lcName = this.nodeName(this.getUser().api().lowerCase(this.fileAPI.getTitle(fileNode)));
        if (!lcName.equals(jcrName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Normalizing node name: " + jcrName + " -> " + lcName));
            }
            fileNode.getSession().move(fileNode.getPath(), this.getUser().api().filePath(fileNode.getParent().getPath(), lcName));
        }
    }

    protected void initDropboxFile(Node localNode, String rev, Long size) throws RepositoryException, DropboxException {
        localNode.setProperty("dropbox:rev", rev);
        localNode.setProperty("ecd:size", size.longValue());
    }

    protected void initDropboxFolder(Node localNode, String cursor) throws RepositoryException, DropboxException {
        if (cursor != null && localNode.hasProperty("dropbox:hash")) {
            localNode.getProperty("dropbox:hash").remove();
        }
    }

    protected void initDropboxPath(Node localNode, String path) throws RepositoryException {
        localNode.setProperty("dropbox:path", path);
    }

    protected String getDropboxPath(Node localNode) throws RepositoryException {
        return localNode.getProperty("dropbox:path").getString();
    }

    protected JCRLocalCloudFile updateItem(DropboxAPI api, MetadataInfo update, Node parent, Node node) throws RepositoryException, CloudDriveException {
        if (update.isItem()) {
            JCRLocalCloudFile localFile;
            String modifiedBy;
            ItemInfo item = update.asItem();
            String id = item.getId();
            String title = item.getTitle();
            String createdBy = modifiedBy = this.currentUserName();
            if (item.isFolder()) {
                String link;
                Calendar created;
                Calendar modified;
                boolean changed;
                FolderInfo folder = item.asFolder();
                if (node == null) {
                    if (parent != null) {
                        node = this.readNode(parent, folder.getName(), id);
                    } else {
                        throw new IllegalArgumentException("Parent or node required");
                    }
                }
                if (node == null) {
                    node = this.openFolder(id, folder.getName(), parent);
                } else if (this.fileAPI.isFile(node) && !this.fileAPI.isFolder(node)) {
                    parent = parent != null ? parent : node.getParent();
                    this.removeNode(node);
                    node = this.openFolder(id, folder.getName(), parent);
                }
                String type = FOLDER_TYPE;
                if (node.isNew() || this.hasLocationChanged(node, folder)) {
                    changed = true;
                    if (node.isNew()) {
                        created = modified = Calendar.getInstance();
                    } else {
                        modified = Calendar.getInstance();
                        try {
                            this.fileAPI.getCreated(node);
                            created = null;
                        }
                        catch (PathNotFoundException e) {
                            created = modified;
                        }
                    }
                    link = api.getUserFolderLink(folder.getPathDisplay());
                    this.initFolder(node, id, title, type, link, createdBy, modifiedBy, created, modified);
                    this.initDropboxPath(node, folder.getPath());
                } else {
                    changed = false;
                    modified = null;
                    created = null;
                    link = null;
                }
                localFile = new JCRLocalCloudFile(node.getPath(), id, title, link, type, modifiedBy, createdBy, created, modified, node, changed);
            } else {
                String link;
                String type;
                Calendar modified;
                Calendar created;
                boolean changed;
                FileInfo file = item.asFile();
                String fileModifiedBy = file.getModifiedBy();
                if (fileModifiedBy != null && fileModifiedBy.length() > 0) {
                    modifiedBy = fileModifiedBy;
                }
                if (node == null) {
                    if (parent != null) {
                        node = this.readNode(parent, file.getName(), id);
                    } else {
                        throw new IllegalArgumentException("Parent or node required");
                    }
                }
                if (node == null) {
                    node = this.openFile(id, file.getName(), parent);
                } else if (this.fileAPI.isFolder(node)) {
                    parent = parent != null ? parent : node.getParent();
                    this.removeNode(node);
                    node = this.openFile(id, file.getName(), parent);
                }
                if (node.isNew() || this.hasDifferentRev(node, file) || this.hasLocationChanged(node, file)) {
                    changed = true;
                    if (node.isNew()) {
                        created = Calendar.getInstance();
                        created.setTime(file.getClientModified());
                    } else {
                        try {
                            this.fileAPI.getCreated(node);
                            created = null;
                        }
                        catch (PathNotFoundException e) {
                            created = Calendar.getInstance();
                            created.setTime(file.getClientModified());
                        }
                    }
                    modified = Calendar.getInstance();
                    modified.setTime(file.getServerModified());
                    type = this.findMimetype(title);
                    link = api.getUserFileLink(file.getParentPathDisplay(), file.getTitle());
                    this.initFile(node, id, title, type, link, null, null, createdBy, modifiedBy, created, modified, file.getSize());
                    this.initDropboxPath(node, file.getPath());
                    this.initDropboxFile(node, file.getRev(), file.getSize());
                } else {
                    changed = false;
                    modified = null;
                    created = null;
                    link = null;
                    type = null;
                }
                localFile = new JCRLocalCloudFile(node.getPath(), id, title, link, this.previewLink(null, node), null, type, this.mimeTypes.getMimeTypeMode(type, title), modifiedBy, createdBy, created, modified, file.getSize(), node, changed);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updated item: " + localFile.getPath() + " [" + localFile.getId() + ", " + item.getPath() + "] changed: " + localFile.isChanged() + " folder: " + localFile.isFolder()));
            }
            return localFile;
        }
        if (update.isDeleted()) {
            throw new CloudDriveException("Deleted item cannot be updated: " + update);
        }
        throw new CloudDriveException("Unexpected item update type: " + update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createSharedLink(Node fileNode) throws RepositoryException, CloudDriveException {
        String idPath = this.fileAPI.getId(fileNode);
        SharedLinkMetadata metadata = this.getUser().api().createSharedLink(idPath);
        this.jcrListener.disable();
        try {
            String link = metadata.getUrl();
            Property dlProp = fileNode.setProperty("dropbox:sharedLink", link);
            long sharedLinkExpires = metadata.getExpires() != null ? metadata.getExpires().getTime() : -1L;
            Property dleProp = fileNode.setProperty("dropbox:sharedLinkExpires", sharedLinkExpires);
            if (dlProp.isNew()) {
                if (!fileNode.isNew() && !fileNode.isModified()) {
                    fileNode.save();
                }
            } else {
                dlProp.save();
                dleProp.save();
            }
            String string = link;
            return string;
        }
        finally {
            this.jcrListener.enable();
        }
    }

    protected String link(Node fileNode) throws RepositoryException {
        boolean isNotOwner;
        String currentUser = this.currentUserName();
        try {
            String driveOwner = this.rootNode().getProperty("ecd:localUserName").getString();
            isNotOwner = !driveOwner.equals(currentUser);
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Cannot read drive owner: " + e.getMessage()));
            isNotOwner = false;
        }
        if (isNotOwner) {
            boolean acquireNew;
            block9: {
                acquireNew = false;
                try {
                    String sharedLink = fileNode.getProperty("dropbox:sharedLink").getString();
                    long expires = fileNode.getProperty("dropbox:sharedLinkExpires").getLong();
                    if (expires == -1L || expires > System.currentTimeMillis()) {
                        return sharedLink;
                    }
                    acquireNew = true;
                }
                catch (PathNotFoundException e) {
                    Node parent = fileNode.getParent();
                    if (!this.fileAPI.isFolder(parent) || !parent.hasProperty("dropbox:sharedLink")) break block9;
                    acquireNew = true;
                }
            }
            if (acquireNew) {
                try {
                    Node node = isNotOwner ? (Node)this.systemSession().getItem(fileNode.getPath()) : fileNode;
                    return this.createSharedLink(node);
                }
                catch (CloudDriveException e) {
                    LOG.error((Object)("Error creating shared link of Dropbox file " + this.fileAPI.getId(fileNode)), (Throwable)e);
                }
            }
        }
        return super.link(fileNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String previewLink(String type, Node fileNode) throws RepositoryException {
        String directLink;
        String id = this.fileAPI.getId(fileNode);
        try {
            directLink = fileNode.getProperty("dropbox:directLink").getString();
            long expires = fileNode.getProperty("dropbox:directLinkExpires").getLong();
            if (expires > System.currentTimeMillis()) {
                return directLink;
            }
        }
        catch (PathNotFoundException expires) {
            // empty catch block
        }
        try {
            directLink = this.getUser().api().getDirectLink(id);
            this.jcrListener.disable();
            String currentUser = this.currentUserName();
            String driveOwner = this.rootNode().getProperty("ecd:localUserName").getString();
            Node node = !driveOwner.equals(currentUser) && !fileNode.isNew() ? (Node)this.systemSession().getItem(fileNode.getPath()) : fileNode;
            Property dlProp = node.setProperty("dropbox:directLink", directLink);
            Property dleProp = node.setProperty("dropbox:directLinkExpires", System.currentTimeMillis() + 14395000L);
            if (dlProp.isNew()) {
                if (!node.isNew() && !node.isModified()) {
                    node.save();
                }
            } else {
                dlProp.save();
                dleProp.save();
            }
            String string = directLink;
            return string;
        }
        catch (NotAcceptableException e) {
            LOG.warn((Object)("Error getting direct link of Dropbox file " + id + ": " + e.getMessage()), (Throwable)e);
        }
        catch (DriveRemovedException e) {
            LOG.warn((Object)("Error getting direct link of Dropbox file " + id + ": " + e.getMessage()), (Throwable)e);
        }
        catch (DropboxException e) {
            LOG.error((Object)("Error getting direct link of Dropbox file " + id), (Throwable)((Object)e));
        }
        catch (RefreshAccessException e) {
            LOG.warn((Object)("Cannot getting direct link of Dropbox file " + id + ": authorization required."), (Throwable)e);
        }
        catch (NotFoundException e) {
            LOG.error((Object)("Error getting direct link of Dropbox file " + id), (Throwable)e);
        }
        catch (RetryLaterException e) {
            LOG.error((Object)("Error getting direct link of Dropbox file " + id), (Throwable)e);
        }
        finally {
            this.jcrListener.enable();
        }
        return ContentService.contentLink((String)this.rootWorkspace, (String)fileNode.getPath(), (String)id);
    }

    protected String findMimetype(String fileName) {
        String defaultType = this.mimeTypes.getDefaultMimeType();
        String resolvedType = this.mimeTypes.getMimeType(fileName);
        String fileType = resolvedType != null && !resolvedType.startsWith(defaultType) ? resolvedType : defaultType;
        return fileType;
    }

    protected DropboxAPI.ListFolder fetchSubtree(DropboxAPI api, String itemId, Node node, Collection<ChunkIterator<?>> iterators, Changes changes) throws RepositoryException, CloudDriveException {
        DropboxAPI.ListFolder ls = api.listFolder(itemId);
        while (ls.hasNext() && !Thread.currentThread().isInterrupted()) {
            MetadataInfo dbxItem = this.itemInfo((Metadata)ls.next());
            this.fetchItem(api, dbxItem, itemId, node, iterators, changes);
        }
        return ls;
    }

    protected void fetchItem(DropboxAPI api, MetadataInfo item, String parentId, Node parentNode, Collection<ChunkIterator<?>> iterators, Changes changes) throws RepositoryException, NotFoundException, CloudDriveException {
        if (item.isFolder()) {
            FolderInfo folder = item.asFolder();
            if (changes.canApply(parentId, folder.getId())) {
                JCRLocalCloudFile localItem = this.updateItem(api, folder, parentNode, null);
                changes.apply(localItem);
                try {
                    DropboxAPI.ListFolder ls = api.listFolder(folder.getId());
                    if (iterators != null) {
                        iterators.add(ls);
                    }
                    while (ls.hasNext()) {
                        Metadata child = (Metadata)ls.next();
                        MetadataInfo childItem = this.itemInfo(child);
                        this.fetchItem(api, childItem, localItem.getId(), localItem.getNode(), iterators, changes);
                    }
                }
                catch (NotFoundException e) {
                    this.removeNode(localItem.getNode());
                    changes.undo(localItem);
                }
            }
        } else if (item.isFile()) {
            FileInfo file = item.asFile();
            if (changes.canApply(parentId, file.getId())) {
                JCRLocalCloudFile localItem = this.updateItem(api, file, parentNode, null);
                changes.apply(localItem);
            }
        } else if (item.isDeleted()) {
            Node node = this.readNode(parentNode, item.getName(), null);
            if (node != null) {
                JCRLocalCloudFile localItem = this.readFile(node);
                LOG.warn((Object)("Fetched item deleted remotelly: " + localItem.getPath() + " >> " + item.getPath()));
                this.removeNode(node);
                changes.undo(localItem);
            }
        } else {
            LOG.warn((Object)("Remote item type unknown: " + item.getPath()));
        }
    }

    protected String folderCursor(Node node) throws RepositoryException {
        String cursor;
        if (this.fileAPI.isFolder(node)) {
            try {
                cursor = node.getProperty("dropbox:cursor").getString();
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Folder cursor not found in the node: " + node.getPath()));
                }
                cursor = null;
            }
        } else {
            cursor = null;
        }
        return cursor;
    }

    protected String nodeName(String title) {
        return super.nodeName(title);
    }

    protected MetadataInfo itemInfo(Metadata item) {
        if (FileMetadata.class.isAssignableFrom(item.getClass())) {
            FileMetadata dbxFile = (FileMetadata)FileMetadata.class.cast(item);
            return new FileInfo(dbxFile);
        }
        if (FolderMetadata.class.isAssignableFrom(item.getClass())) {
            FolderMetadata dbxFolder = (FolderMetadata)FolderMetadata.class.cast(item);
            return new FolderInfo(dbxFolder);
        }
        if (DeletedMetadata.class.isAssignableFrom(item.getClass())) {
            DeletedMetadata dbxDeleted = (DeletedMetadata)DeletedMetadata.class.cast(item);
            return new DeletedInfo(dbxDeleted);
        }
        return new UnknownInfo(item);
    }

    protected boolean hasLocationChanged(Node node, ItemInfo item) throws RepositoryException {
        try {
            return !this.getDropboxPath(node).equals(item.getPath());
        }
        catch (PathNotFoundException e) {
            return true;
        }
    }

    protected boolean hasSameId(Node node, ItemInfo item) throws RepositoryException {
        try {
            return this.fileAPI.getId(node).equals(item.getId());
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected boolean hasDifferentRev(Node node, FileInfo file) throws RepositoryException {
        try {
            return !node.getProperty("dropbox:rev").getString().equals(file.getRev());
        }
        catch (PathNotFoundException e) {
            return true;
        }
    }

    protected String cleanPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static /* synthetic */ CloudFileAPI access$2900(JCRLocalDropboxDrive x0) {
        return x0.fileAPI;
    }

    static /* synthetic */ Log access$3000() {
        return LOG;
    }

    static /* synthetic */ Log access$3100() {
        return LOG;
    }

    static /* synthetic */ Log access$3200() {
        return LOG;
    }

    static /* synthetic */ Log access$3300() {
        return LOG;
    }

    static /* synthetic */ Log access$3400() {
        return LOG;
    }

    static /* synthetic */ Log access$3500() {
        return LOG;
    }

    static /* synthetic */ Log access$3600() {
        return LOG;
    }

    static /* synthetic */ Log access$3700() {
        return LOG;
    }

    static /* synthetic */ Log access$3800() {
        return LOG;
    }

    static /* synthetic */ Log access$3900() {
        return LOG;
    }

    static /* synthetic */ Log access$4000() {
        return LOG;
    }

    static /* synthetic */ Log access$4100() {
        return LOG;
    }

    static /* synthetic */ Log access$4200() {
        return LOG;
    }

    static /* synthetic */ Log access$4300() {
        return LOG;
    }

    static /* synthetic */ Log access$4400() {
        return LOG;
    }

    static /* synthetic */ void access$4500(JCRLocalDropboxDrive x0, Long x1) throws CloudDriveException, RepositoryException {
        x0.setChangeId(x1);
    }

    static /* synthetic */ Log access$4600() {
        return LOG;
    }

    static /* synthetic */ Log access$4700() {
        return LOG;
    }

    static /* synthetic */ Log access$4800() {
        return LOG;
    }

    static /* synthetic */ Log access$4900() {
        return LOG;
    }

    static /* synthetic */ Log access$5000() {
        return LOG;
    }

    static /* synthetic */ Log access$5100() {
        return LOG;
    }

    protected class DropboxDrive {
        protected final DropboxAPI api;
        protected final Node rootNode;
        protected final Map<String, Node> pathNodes = new HashMap<String, Node>();

        protected DropboxDrive(DropboxAPI api, Node rootNode) {
            this.api = api;
            this.rootNode = rootNode;
            this.pathNodes.put(DropboxAPI.ROOT_PATH_V2, rootNode);
        }

        protected void close() {
            this.pathNodes.clear();
        }

        void removePaths(String dbxPath) throws RepositoryException {
            Iterator<Map.Entry<String, Node>> pniter = this.pathNodes.entrySet().iterator();
            while (pniter.hasNext()) {
                Map.Entry<String, Node> pne = pniter.next();
                if (!pne.getValue().getPath().startsWith(dbxPath)) continue;
                JCRLocalDropboxDrive.this.removeLinks(pne.getValue());
                pniter.remove();
            }
        }

        public String getRemotePath(String jcrPath) throws RepositoryException {
            String rootPath = this.rootNode.getPath();
            if (jcrPath.startsWith(rootPath)) {
                return jcrPath.substring(rootPath.length());
            }
            return null;
        }

        public String getLocalPath(String dbxPath) throws RepositoryException {
            String[] pathElems;
            StringBuilder jcrPath = new StringBuilder(this.rootNode.getPath());
            for (String e : pathElems = JCRLocalDropboxDrive.this.cleanPath(dbxPath).split("/")) {
                jcrPath.append('/').append(JCRLocalDropboxDrive.this.nodeName(e));
            }
            return jcrPath.append(dbxPath).toString();
        }

        public LocalItem findByLocalPath(String jcrPath) throws RepositoryException {
            String dbxPath = this.getRemotePath(jcrPath);
            if (dbxPath != null) {
                return this.getItem(dbxPath);
            }
            return null;
        }

        public LocalItem getItem(String dbxPath) throws RepositoryException {
            Node node = this.pathNodes.get(dbxPath);
            if (node == null) {
                return this.readItem(dbxPath);
            }
            return new LocalItem(dbxPath, node, null, null);
        }

        protected LocalItem readItem(String dbxPath) throws RepositoryException {
            String relPath = JCRLocalDropboxDrive.this.cleanPath(dbxPath);
            Node node = null;
            Node parent = this.rootNode;
            StringBuilder mapPath = new StringBuilder();
            String itemPath = null;
            ArrayList<String> relPathElems = new ArrayList<String>(Arrays.asList(relPath.split("/")));
            Iterator eiter = relPathElems.iterator();
            while (eiter.hasNext()) {
                String name = (String)eiter.next();
                mapPath.append('/').append(name);
                itemPath = mapPath.toString();
                node = this.pathNodes.get(itemPath);
                if (node == null) {
                    node = JCRLocalDropboxDrive.this.readNode(parent, name, null);
                    if (node == null) break;
                    this.pathNodes.put(itemPath, node);
                }
                if (eiter.hasNext()) {
                    if (JCRLocalDropboxDrive.this.fileAPI.isFolder(node)) {
                        parent = node;
                    } else {
                        node = null;
                        break;
                    }
                }
                eiter.remove();
            }
            if (node != null) {
                return new LocalItem(dbxPath, node, null, null);
            }
            if (parent != null) {
                return new LocalItem(dbxPath, null, parent, Collections.unmodifiableList(relPathElems));
            }
            return new LocalItem(dbxPath, null, this.rootNode, Collections.unmodifiableList(relPathElems));
        }

        @Deprecated
        protected Node findDropboxNode(String dbxPath) throws RepositoryException {
            if (DropboxAPI.ROOT_PATH_V2.equals(dbxPath)) {
                return this.rootNode;
            }
            QueryManager qm = this.rootNode.getSession().getWorkspace().getQueryManager();
            Query q = qm.createQuery("SELECT * FROM ecd:cloudFile WHERE dropbox:path='" + dbxPath + "' AND jcr:dbxPath LIKE '" + this.rootNode.getPath() + "/%'", "sql");
            QueryResult qr = q.execute();
            NodeIterator nodes = qr.getNodes();
            if (nodes.hasNext()) {
                return nodes.nextNode();
            }
            return null;
        }

        public Node restore(Node node) throws RepositoryException {
            String savedDbxPath = JCRLocalDropboxDrive.this.getDropboxPath(node);
            String assumedDbxPath = this.getRemotePath(node.getPath());
            try {
                if (!savedDbxPath.equals(assumedDbxPath)) {
                    this.rootNode.getSession().move(node.getPath(), this.getLocalPath(savedDbxPath));
                }
                return node;
            }
            catch (PathNotFoundException e) {
                node.remove();
                return null;
            }
        }

        protected class LocalItem {
            private final String dbxPath;
            private final Node node;
            private final Node parent;
            private final List<String> relPath;
            private Node updated;

            protected LocalItem(String dbxPath, Node node, Node parent, List<String> relPath) {
                if (dbxPath == null) {
                    throw new IllegalArgumentException("Dropbox path (dbxPath) required");
                }
                this.dbxPath = dbxPath;
                if (node == null && parent == null) {
                    throw new IllegalArgumentException("Node or parent required");
                }
                this.node = node;
                this.parent = parent;
                if (node == null && parent != null && (relPath == null || relPath.isEmpty())) {
                    throw new IllegalArgumentException("Rellative part of path (relPath list) required");
                }
                this.relPath = relPath != null ? Collections.unmodifiableList(relPath) : null;
            }

            public boolean exists() {
                return this.getNode() != null;
            }

            public Node getNode() {
                return this.updated != null ? this.updated : this.node;
            }

            public String removeNode() throws RepositoryException {
                return this.removeNode(this.getNode());
            }

            private String removeNode(Node node) throws RepositoryException {
                if (node != null) {
                    String jcrPath = node.getPath();
                    DropboxDrive.this.removePaths(jcrPath);
                    JCRLocalDropboxDrive.this.removeNode(node);
                    return jcrPath;
                }
                return null;
            }

            public Node update(ItemInfo item, Changes changes) throws RepositoryException, CloudDriveException {
                String itemPath = item.getPath();
                if (itemPath.equals(this.dbxPath)) {
                    JCRLocalCloudFile local = JCRLocalDropboxDrive.this.updateItem(DropboxDrive.this.api, item, this.parent, this.getNode());
                    changes.apply(local);
                    this.updated = local.getNode();
                    DropboxDrive.this.pathNodes.put(itemPath, this.updated);
                    return this.updated;
                }
                throw new IllegalArgumentException("Item path doesn't match the local: " + itemPath + " vs " + this.dbxPath);
            }

            public Node move(ItemInfo toItem, Changes changes) throws RepositoryException, CloudDriveException {
                JCRLocalCloudFile local;
                String toPath = toItem.getPath();
                Node fromNode = this.getNode();
                if (fromNode != null) {
                    if (toPath.equals(this.dbxPath)) {
                        local = JCRLocalDropboxDrive.this.updateItem(DropboxDrive.this.api, toItem, this.parent, fromNode);
                    } else {
                        LocalItem toLocalItem;
                        LocalItem localItem = toLocalItem = toItem.localItem != null ? toItem.localItem : DropboxDrive.this.getItem(toPath);
                        if (toLocalItem.exists() && JCRLocalDropboxDrive.this.hasSameId(toLocalItem.getNode(), toItem)) {
                            local = JCRLocalDropboxDrive.this.updateItem(DropboxDrive.this.api, toItem, this.parent, toLocalItem.getNode());
                        } else {
                            block9: {
                                toLocalItem.removeNode();
                                try {
                                    fromNode.refresh(true);
                                }
                                catch (InvalidItemStateException e) {
                                    fromNode = DropboxDrive.this.getItem(this.dbxPath).getNode();
                                    if (fromNode != null) break block9;
                                    throw new LocalFileNotFoundException("Cannot move not cloud file: " + this.dbxPath, (Throwable)e);
                                }
                            }
                            LocalItem toParent = DropboxDrive.this.getItem(toItem.getParentPath());
                            Node parent = toParent.getNode();
                            if (parent == null) {
                                LOG.warn((Object)("Move's destination parent not found and will be fetched from cloud side: " + toItem.getParentPath()));
                                parent = toParent.fetch(changes);
                            }
                            String srcJcrPath = fromNode.getPath();
                            String destJcrPath = DropboxDrive.this.api.filePath(parent.getPath(), JCRLocalDropboxDrive.this.nodeName(toItem.getName()));
                            fromNode.getSession().move(srcJcrPath, destJcrPath);
                            local = JCRLocalDropboxDrive.this.updateItem(DropboxDrive.this.api, toItem, parent, null);
                            changes.removed(srcJcrPath);
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Cannot move an item not found locally: " + this.dbxPath + " to " + toPath);
                }
                this.updated = local.getNode();
                DropboxDrive.this.removePaths(this.dbxPath);
                DropboxDrive.this.pathNodes.put(toPath, this.updated);
                changes.apply(local);
                return this.updated;
            }

            public Node fetch(Changes changes) throws RepositoryException, CloudDriveException {
                if (this.exists()) {
                    return this.getNode();
                }
                Node node = null;
                Node theParent = this.parent;
                StringBuilder mapPath = new StringBuilder(JCRLocalDropboxDrive.this.getDropboxPath(theParent));
                Iterator<String> eiter = this.relPath.iterator();
                while (eiter.hasNext()) {
                    String name = eiter.next();
                    mapPath.append('/').append(name);
                    String itemPath = mapPath.toString();
                    node = DropboxDrive.this.pathNodes.get(itemPath);
                    MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo(DropboxDrive.this.api.get(itemPath, true));
                    if (item.isItem()) {
                        JCRLocalCloudFile local = JCRLocalDropboxDrive.this.updateItem(DropboxDrive.this.api, item, theParent, node);
                        changes.apply(local);
                        node = local.getNode();
                        DropboxDrive.this.pathNodes.put(itemPath, node);
                        if (item.isFolder()) {
                            if (eiter.hasNext() && node.isNew()) {
                                JCRLocalDropboxDrive.this.fetchSubtree(DropboxDrive.this.api, item.asFolder().getId(), theParent, null, changes);
                                node = DropboxDrive.this.getItem(this.dbxPath).getNode();
                                if (node != null) break;
                                DropboxDrive.this.removePaths(this.dbxPath);
                                node = null;
                                break;
                            }
                            theParent = node;
                            continue;
                        }
                        if (!eiter.hasNext()) continue;
                        DropboxDrive.this.removePaths(itemPath);
                        node = null;
                        break;
                    }
                    if (node == null) {
                        node = JCRLocalDropboxDrive.this.readNode(theParent, name, null);
                    }
                    if (node == null) continue;
                    this.removeNode(node);
                    DropboxDrive.this.removePaths(itemPath);
                    node = null;
                    break;
                }
                this.updated = node;
                return this.updated;
            }
        }
    }

    @Deprecated
    public class JCRLocalDropboxFile
    extends JCRLocalCloudFile {
        protected final ItemInfo file;
        protected String link;
        protected String previewLink;
        protected String typeMode;
        protected String author;
        protected String lastUser;
        protected transient AtomicReference<Calendar> createdDate;
        protected transient AtomicReference<Calendar> modifiedDate;
        private transient Node node;
        private transient boolean changed;

        JCRLocalDropboxFile(ItemInfo folder, String path, String id, String title, String link, String type, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, Node node, boolean changed) {
            super(path, id, title, link, FOLDER_TYPE, lastUser, author, createdDate, modifiedDate, node, changed);
            this.file = folder;
            this.link = link;
            this.author = author;
            this.lastUser = lastUser;
            if (createdDate != null) {
                this.createdDate = new AtomicReference<Calendar>(createdDate);
            }
            if (modifiedDate != null) {
                this.modifiedDate = new AtomicReference<Calendar>(modifiedDate);
            }
        }

        JCRLocalDropboxFile(ItemInfo file, String path, String id, String title, String link, String type, String lastUser, String author, Calendar createdDate, Calendar modifiedDate, long size, Node node, boolean changed) {
            super(path, id, title, link, null, null, type, null, lastUser, author, createdDate, modifiedDate, size, node, changed);
            this.file = file;
            this.link = link;
            this.author = author;
            this.lastUser = lastUser;
            if (createdDate != null) {
                this.createdDate = new AtomicReference<Calendar>(createdDate);
            }
            if (modifiedDate != null) {
                this.modifiedDate = new AtomicReference<Calendar>(modifiedDate);
            }
        }

        public String getPreviewLink() {
            if (this.previewLink == null) {
                try {
                    this.previewLink = JCRLocalDropboxDrive.this.previewLink(null, this.getNode());
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file preview link: " + this.getPath()), (Throwable)e);
                    this.previewLink = JCRLocalCloudDrive.DUMMY_DATA;
                }
            }
            return JCRLocalCloudDrive.DUMMY_DATA == this.previewLink ? null : this.previewLink;
        }

        public String getTypeMode() {
            if (this.typeMode == null && !this.isFolder()) {
                this.typeMode = JCRLocalDropboxDrive.this.mimeTypes.getMimeTypeMode(this.getType(), this.getTitle());
            }
            return this.typeMode;
        }

        public Calendar getCreatedDate() {
            if (this.createdDate == null) {
                try {
                    this.createdDate = new AtomicReference<Calendar>(JCRLocalDropboxDrive.this.fileAPI.getCreated(this.getNode()));
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file created date: " + this.getPath()), (Throwable)e);
                    this.createdDate = new AtomicReference();
                }
            }
            return this.createdDate.get();
        }

        public Calendar getModifiedDate() {
            if (this.modifiedDate == null) {
                try {
                    this.modifiedDate = new AtomicReference<Calendar>(JCRLocalDropboxDrive.this.fileAPI.getModified(this.getNode()));
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file modified date: " + this.getPath()), (Throwable)e);
                    this.modifiedDate = new AtomicReference();
                }
            }
            return this.modifiedDate.get();
        }

        public String getAuthor() {
            if (this.author == null) {
                try {
                    this.author = JCRLocalDropboxDrive.this.fileAPI.getAuthor(this.getNode());
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file author: " + this.getPath()), (Throwable)e);
                    this.author = JCRLocalCloudDrive.DUMMY_DATA;
                }
            }
            return JCRLocalCloudDrive.DUMMY_DATA == this.author ? null : this.author;
        }

        public String getLastUser() {
            if (this.lastUser == null) {
                try {
                    this.lastUser = JCRLocalDropboxDrive.this.fileAPI.getLastUser(this.getNode());
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error reading file's last modified user: " + this.getPath()), (Throwable)e);
                    this.lastUser = JCRLocalCloudDrive.DUMMY_DATA;
                }
            }
            return JCRLocalCloudDrive.DUMMY_DATA == this.lastUser ? null : this.lastUser;
        }

        public String getLink() {
            if (this.link == null) {
                this.link = this.isFolder() ? JCRLocalDropboxDrive.this.getUser().api().getUserFolderLink(this.file.getPathDisplay()) : JCRLocalDropboxDrive.this.getUser().api().getUserFileLink(this.file.getParentPathDisplay(), this.file.getTitle());
            }
            return this.link;
        }
    }

    protected class DeletedInfo
    extends MetadataInfo {
        final DeletedMetadata deleted;

        DeletedInfo(DeletedMetadata deleted) {
            this.deleted = deleted;
        }

        public String toString() {
            return "DeletedInfo [" + this.getPath() + "]";
        }

        @Override
        protected boolean isFolder() {
            return false;
        }

        @Override
        protected boolean isFile() {
            return false;
        }

        @Override
        protected boolean isItem() {
            return false;
        }

        @Override
        protected boolean isDeleted() {
            return true;
        }

        @Override
        protected FileInfo asFile() {
            throw new IllegalArgumentException("Deleted is not a file: " + this.getPath());
        }

        @Override
        protected FolderInfo asFolder() {
            throw new IllegalArgumentException("Deleted is not a folder: " + this.getPath());
        }

        @Override
        protected ItemInfo asItem() {
            throw new IllegalArgumentException("Deleted is not an item: " + this.getPath());
        }

        @Override
        protected String getTitle() {
            return this.deleted.getName();
        }

        @Override
        protected String getPath() {
            return this.deleted.getPathLower();
        }

        @Override
        protected String getPathDisplay() {
            return this.deleted.getPathDisplay();
        }
    }

    protected class FolderInfo
    extends ItemInfo {
        final FolderMetadata folder;

        FolderInfo(FolderMetadata folder) {
            this.folder = folder;
        }

        public String toString() {
            return "FolderInfo [" + this.getPath() + "] ID: " + this.folder.getId();
        }

        @Override
        protected boolean isFolder() {
            return true;
        }

        @Override
        protected boolean isFile() {
            return false;
        }

        @Override
        protected boolean isDeleted() {
            return false;
        }

        @Override
        protected FileInfo asFile() {
            throw new IllegalArgumentException("Folder is not a file: " + this.getPath());
        }

        @Override
        protected FolderInfo asFolder() {
            return this;
        }

        @Override
        protected String getId() {
            return this.folder.getId();
        }

        @Override
        protected String getTitle() {
            return this.folder.getName();
        }

        @Override
        protected String getPath() {
            return this.folder.getPathLower();
        }

        @Override
        protected String getPathDisplay() {
            return this.folder.getPathDisplay();
        }
    }

    protected class FileInfo
    extends ItemInfo {
        final FileMetadata file;

        FileInfo(FileMetadata file) {
            this.file = file;
        }

        public String toString() {
            return "FileInfo [" + this.getPath() + "] ID: " + this.file.getId();
        }

        @Override
        protected boolean isFolder() {
            return false;
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        @Override
        protected boolean isDeleted() {
            return false;
        }

        @Override
        protected FileInfo asFile() {
            return this;
        }

        @Override
        protected FolderInfo asFolder() {
            throw new IllegalArgumentException("File is not a folder: " + this.getPath());
        }

        @Override
        protected String getId() {
            return this.file.getId();
        }

        @Override
        protected String getTitle() {
            return this.file.getName();
        }

        @Override
        protected String getPath() {
            return this.file.getPathLower();
        }

        @Override
        protected String getPathDisplay() {
            return this.file.getPathDisplay();
        }

        protected String getRev() {
            return this.file.getRev();
        }

        protected long getSize() {
            return this.file.getSize();
        }

        protected Date getClientModified() {
            return this.file.getClientModified();
        }

        protected Date getServerModified() {
            return this.file.getServerModified();
        }

        protected String getModifiedBy() {
            FileSharingInfo sinfo = this.file.getSharingInfo();
            return sinfo != null ? sinfo.getModifiedBy() : null;
        }
    }

    protected abstract class ItemInfo
    extends MetadataInfo {
        protected ItemInfo() {
        }

        @Override
        protected boolean isItem() {
            return true;
        }

        @Override
        protected ItemInfo asItem() {
            return this;
        }

        protected abstract String getId();
    }

    protected final class UnknownInfo
    extends MetadataInfo {
        final Metadata metadata;

        UnknownInfo(Metadata metadata) {
            this.metadata = metadata;
        }

        public String toString() {
            return "UnknownInfo [" + this.getPath() + "] : " + this.metadata.toString();
        }

        @Override
        protected FileInfo asFile() {
            throw new IllegalArgumentException("Unknown is not a file: " + this.getPath());
        }

        @Override
        protected FolderInfo asFolder() {
            throw new IllegalArgumentException("Unknown is not a folder: " + this.getPath());
        }

        @Override
        protected ItemInfo asItem() {
            throw new IllegalArgumentException("Unknown is not an item: " + this.getPath());
        }

        @Override
        protected boolean isFolder() {
            return false;
        }

        @Override
        protected boolean isFile() {
            return false;
        }

        @Override
        protected boolean isItem() {
            return false;
        }

        @Override
        protected boolean isDeleted() {
            return false;
        }

        @Override
        protected String getTitle() {
            return this.metadata.getName();
        }

        @Override
        protected String getPath() {
            return this.metadata.getPathLower();
        }

        @Override
        protected String getPathDisplay() {
            return this.metadata.getPathDisplay();
        }
    }

    protected abstract class MetadataInfo {
        String[] pathDisplay;
        String[] path;
        int index = -1;
        DropboxDrive.LocalItem localItem = null;
        String localId = null;
        MetadataInfo prevDeleted = null;

        protected MetadataInfo() {
        }

        protected String[] splitPath(String path) {
            String name;
            String parentPath;
            if (DropboxAPI.ROOT_PATH_V2.equals(path) || path.length() == 1 && path.charAt(0) == '/') {
                parentPath = null;
                name = DropboxAPI.ROOT_PATH_V2;
            } else {
                int endIndex;
                int parentEndIndex = path.lastIndexOf(47);
                if (parentEndIndex > 0 && parentEndIndex == path.length() - 1) {
                    endIndex = parentEndIndex;
                    parentEndIndex = path.lastIndexOf(47, endIndex - 1);
                } else {
                    endIndex = path.length();
                }
                if (parentEndIndex > 0) {
                    parentPath = path.substring(0, parentEndIndex);
                    int nameIndex = parentEndIndex + 1;
                    name = nameIndex < endIndex ? path.substring(nameIndex, endIndex) : null;
                } else if (parentEndIndex == 0) {
                    parentPath = DropboxAPI.ROOT_PATH_V2;
                    name = path.substring(parentEndIndex + 1, endIndex);
                } else {
                    parentPath = DropboxAPI.ROOT_PATH_V2;
                    name = path;
                }
            }
            return new String[]{parentPath, name};
        }

        protected final String getParentPathDisplay() {
            if (this.pathDisplay == null) {
                this.pathDisplay = this.splitPath(this.getPathDisplay());
            }
            return this.pathDisplay[0];
        }

        protected final String getParentPath() {
            if (this.path == null) {
                this.path = this.splitPath(this.getPath());
            }
            return this.path[0];
        }

        protected final String getName() {
            if (this.path == null) {
                this.path = this.splitPath(this.getPath());
            }
            return this.path[1];
        }

        protected ParentInfo parent() {
            return new ParentInfo(this.getParentPath(), this.getParentPathDisplay());
        }

        protected abstract FileInfo asFile();

        protected abstract FolderInfo asFolder();

        protected abstract ItemInfo asItem();

        protected final boolean isRoot() {
            return DropboxAPI.ROOT_PATH_V2.equals(this.getPath());
        }

        protected abstract boolean isFolder();

        protected abstract boolean isFile();

        protected abstract boolean isItem();

        protected abstract boolean isDeleted();

        protected abstract String getTitle();

        protected abstract String getPath();

        protected abstract String getPathDisplay();

        protected final class ParentInfo
        extends FolderInfo {
            final String itemPath;
            final String itemPathDisplay;

            protected ParentInfo(String itemPath, String itemPathDisplay) {
                super(null);
                this.itemPath = itemPath;
                this.itemPathDisplay = itemPathDisplay;
            }

            @Override
            public String toString() {
                return "ParentInfo [" + this.getPath() + ']';
            }

            @Override
            protected FileInfo asFile() {
                throw new IllegalArgumentException("Parent folder is not a file: " + this.getPath());
            }

            @Override
            protected String getId() {
                throw new IllegalArgumentException("ParentInfo has not ID");
            }

            @Override
            protected String getTitle() {
                if (this.pathDisplay == null) {
                    this.pathDisplay = this.splitPath(this.getPathDisplay());
                }
                return this.pathDisplay[1];
            }

            @Override
            protected String getPath() {
                return this.itemPath;
            }

            @Override
            protected String getPathDisplay() {
                return this.itemPathDisplay;
            }
        }
    }

    public class DropboxState
    extends JCRLocalCloudDrive.DriveState {
        final String cursor;
        final String url;
        final int timeout;

        protected DropboxState(String cursor) {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.cursor = cursor;
            this.timeout = 60;
            this.url = "https://notify.dropboxapi.com/2/files/list_folder/longpoll";
        }

        public String getCursor() {
            return this.cursor;
        }

        public String getUrl() {
            return this.url;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    protected class EventsSync
    extends JCRLocalCloudDrive.SyncCommand
    implements Changes {
        protected final DropboxAPI api;

        protected EventsSync() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        /*
         * Unable to fully structure code
         */
        protected void syncFiles() throws CloudDriveException, RepositoryException {
            block28: {
                block29: {
                    try {
                        doSync = this.driveNode.getProperty("dropbox:version").getLong() >= 2L;
                    }
                    catch (PathNotFoundException e) {
                        doSync = false;
                    }
                    if (!doSync) break block29;
                    changeId = System.currentTimeMillis();
                    cursor = this.driveNode.getProperty("dropbox:cursor").getString();
                    try {
                        ls = this.api.listFolderContinued(DropboxAPI.ROOT_PATH_V2, cursor);
                        this.iterators.add(ls);
                        localDrive = new DropboxDrive(this.api, this.driveNode);
                        changes = new LinkedList<MetadataInfo>();
                        deletedPathTree = new TreeMap<String, MetadataInfo>();
                        deletedIdMap = new LinkedHashMap<String, MetadataInfo>();
                        appliedIndex = -1;
                        while (ls.hasNext() && !Thread.currentThread().isInterrupted()) {
                            change = JCRLocalDropboxDrive.this.itemInfo((Metadata)ls.next());
                            if (!change.isDeleted()) ** GOTO lbl46
                            deletedPath = change.getPath();
                            change.localItem = localDrive.getItem(deletedPath);
                            node = change.localItem.getNode();
                            change.index = changes.size();
                            if (node != null) {
                                change.localId = JCRLocalDropboxDrive.access$2900(JCRLocalDropboxDrive.this).getId(node);
                                prevDeleted = deletedIdMap.put(change.localId, change);
                                if (prevDeleted != null && JCRLocalDropboxDrive.access$3000().isDebugEnabled()) {
                                    JCRLocalDropboxDrive.access$3100().debug((Object)("Previous deleted found for deleted: " + change + " ID: " + change.localId));
                                }
                                deletedSubtree = deletedPathTree.tailMap(deletedPath, false);
                                diter = deletedSubtree.entrySet().iterator();
                                while (diter.hasNext() && ((String)(ce = diter.next()).getKey()).startsWith(deletedPath)) {
                                    c = (MetadataInfo)ce.getValue();
                                    c.index = -1;
                                    deletedIdMap.remove(c.localId);
                                    diter.remove();
                                }
                                prevChange = deletedPathTree.put(deletedPath, change);
                                if (prevChange != null && JCRLocalDropboxDrive.access$3200().isDebugEnabled()) {
                                    JCRLocalDropboxDrive.access$3300().debug((Object)("Path updated in deleted tree: " + change.getPath() + " " + prevChange.index + " -> " + change.index));
                                }
                            } else {
                                if (!JCRLocalDropboxDrive.access$3400().isDebugEnabled()) continue;
                                JCRLocalDropboxDrive.access$3500().debug((Object)("Item not found locally to delete: " + change));
                                continue;
lbl46:
                                // 1 sources

                                if (change.isItem()) {
                                    change.index = changes.size();
                                    change.localItem = localDrive.getItem(change.getPath());
                                    item = change.asItem();
                                    prevDeleted = (MetadataInfo)deletedIdMap.get(item.getId());
                                    if (prevDeleted != null) {
                                        prevDeleted.index = -1;
                                        change.prevDeleted = prevDeleted;
                                    }
                                } else {
                                    JCRLocalDropboxDrive.access$3600().warn((Object)("Unknown update type: " + change));
                                    continue;
                                }
                            }
                            if (JCRLocalDropboxDrive.access$3700().isDebugEnabled()) {
                                JCRLocalDropboxDrive.access$3800().debug((Object)("Change: " + change + " " + (change.localItem.exists() != false ? "[found]" : "") + (change.localId != null ? " ID: " + change.localId : "")));
                            }
                            changes.add(change);
                            if (!change.isItem() && ls.hasNext()) continue;
                            i = appliedIndex + 1;
                            while (i < changes.size() && !Thread.currentThread().isInterrupted()) {
                                c = (MetadataInfo)changes.get(i);
                                if (c.index >= 0) {
                                    if (c.isItem()) {
                                        item = c.asItem();
                                        if (item.prevDeleted != null) {
                                            if (JCRLocalDropboxDrive.access$3900().isDebugEnabled()) {
                                                JCRLocalDropboxDrive.access$4000().debug((Object)("Move: " + item.prevDeleted.getPath() + " -> " + item));
                                            }
                                            item.prevDeleted.localItem.move(item, this);
                                            this.save();
                                        } else {
                                            if (JCRLocalDropboxDrive.access$4100().isDebugEnabled()) {
                                                JCRLocalDropboxDrive.access$4200().debug((Object)("Update: " + item));
                                            }
                                            item.localItem.update(item, this);
                                        }
                                    } else {
                                        if (JCRLocalDropboxDrive.access$4300().isDebugEnabled()) {
                                            JCRLocalDropboxDrive.access$4400().debug((Object)("Delete: " + c));
                                        }
                                        if ((jcrPath = c.localItem.removeNode()) != null) {
                                            this.addRemoved(jcrPath);
                                        }
                                    }
                                    deletedPathTree.clear();
                                    deletedIdMap.clear();
                                }
                                appliedIndex = i++;
                            }
                        }
                        changes.clear();
                        if (!Thread.currentThread().isInterrupted()) {
                            JCRLocalDropboxDrive.access$4500(JCRLocalDropboxDrive.this, changeId);
                            cursorProp = this.driveNode.setProperty("dropbox:cursor", ls.getCursor());
                            cursorProp.save();
                            JCRLocalDropboxDrive.this.updateState(ls.getCursor());
                            if (JCRLocalDropboxDrive.access$4600().isDebugEnabled()) {
                                JCRLocalDropboxDrive.access$4700().debug((Object)("<< syncFiles: " + this.driveNode.getPath() + "\n\r" + cursor + " --> " + ls.getCursor()));
                            }
                        }
                        break block28;
                    }
                    catch (ResetCursorException e) {
                        if (JCRLocalDropboxDrive.access$4800().isDebugEnabled()) {
                            JCRLocalDropboxDrive.access$4900().debug((Object)("<< syncFiles CURSOR RESET: " + this.driveNode.getPath() + "\n\r" + cursor), (Throwable)e);
                        }
                        JCRLocalDropboxDrive.access$5000().warn((Object)("Dropbox cursor was reset, need full sync for '" + JCRLocalDropboxDrive.this.getTitle() + "'. " + e.getMessage()));
                        doSync = false;
                    }
                    break block28;
                }
                JCRLocalDropboxDrive.access$5100().warn((Object)("Dropbox drive connected by older API, need full sync for '" + JCRLocalDropboxDrive.this.getTitle() + "'."));
            }
            if (!doSync) {
                new Connect().execLocal();
            }
        }

        @Override
        public void apply(JCRLocalCloudFile local) throws RepositoryException, CloudDriveException {
            this.removeRemoved(local.getPath());
            this.addChanged((CloudFile)local);
        }

        @Override
        public void undo(JCRLocalCloudFile local) throws RepositoryException, CloudDriveException {
            if (local.isChanged()) {
                this.removeChanged((CloudFile)local);
                this.addRemoved(local.getPath());
            }
        }

        @Override
        public boolean removed(String path) throws RepositoryException, CloudDriveException {
            return this.addRemoved(path);
        }

        @Override
        public boolean canApply(String parentId, String fileId) {
            return true;
        }

        protected void preSaveChunk() throws CloudDriveException, RepositoryException {
        }
    }

    protected class FileAPI
    extends JCRLocalCloudDrive.AbstractFileAPI {
        protected final DropboxAPI api;

        FileAPI() {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        public CloudFile createFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            JCRLocalDropboxDrive.this.normalizeName(fileNode);
            return this.uploadFile(fileNode, created, modified, mimeType, content, false);
        }

        public CloudFile createFolder(Node folderNode, Calendar created) throws CloudDriveException, RepositoryException {
            FolderInfo folder;
            JCRLocalDropboxDrive.this.normalizeName(folderNode);
            String dbxParentPath = JCRLocalDropboxDrive.this.getDropboxPath(folderNode.getParent());
            String title = this.getTitle(folderNode);
            try {
                folder = JCRLocalDropboxDrive.this.itemInfo((Metadata)this.api.createFolder(dbxParentPath, title)).asFolder();
            }
            catch (ConflictException e) {
                String cpath = this.api.filePath(dbxParentPath, title);
                MetadataInfo existing = JCRLocalDropboxDrive.this.itemInfo(this.api.get(cpath));
                if (existing.isFolder()) {
                    folder = existing.asFolder();
                }
                throw e;
            }
            JCRLocalCloudFile localFile = JCRLocalDropboxDrive.this.updateItem(this.api, folder, null, folderNode);
            return localFile;
        }

        public CloudFile updateFile(Node fileNode, Calendar modified) throws CloudDriveException, RepositoryException {
            MetadataInfo item = this.move(fileNode);
            if (item != null) {
                return JCRLocalDropboxDrive.this.updateItem(this.api, item, null, fileNode);
            }
            return JCRLocalDropboxDrive.this.readFile(fileNode);
        }

        public CloudFile updateFolder(Node folderNode, Calendar modified) throws CloudDriveException, RepositoryException {
            MetadataInfo item = this.move(folderNode);
            if (item != null) {
                return JCRLocalDropboxDrive.this.updateItem(this.api, item, null, folderNode);
            }
            return JCRLocalDropboxDrive.this.readFile(folderNode);
        }

        public CloudFile updateFileContent(Node fileNode, Calendar modified, String mimeType, InputStream content) throws CloudDriveException, RepositoryException {
            return this.uploadFile(fileNode, null, modified, mimeType, content, true);
        }

        public CloudFile copyFile(Node srcFileNode, Node destFileNode) throws CloudDriveException, RepositoryException {
            MetadataInfo item = this.copy(srcFileNode, destFileNode);
            return JCRLocalDropboxDrive.this.updateItem(this.api, item, null, destFileNode);
        }

        public CloudFile copyFolder(Node srcFolderNode, Node destFolderNode) throws CloudDriveException, RepositoryException {
            MetadataInfo item = this.copy(srcFolderNode, destFolderNode);
            JCRLocalCloudFile localFile = JCRLocalDropboxDrive.this.updateItem(this.api, item, null, destFolderNode);
            if (localFile.isFolder()) {
                this.updateSubtree(localFile.getNode());
            }
            return localFile;
        }

        public boolean removeFile(String id) throws CloudDriveException, RepositoryException {
            MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo(this.api.delete(id));
            return item.isDeleted();
        }

        public boolean removeFolder(String id) throws CloudDriveException, RepositoryException {
            MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo(this.api.delete(id));
            return item.isDeleted();
        }

        public boolean trashFile(String id) throws CloudDriveException, RepositoryException {
            return this.removeFile(id);
        }

        public boolean trashFolder(String id) throws CloudDriveException, RepositoryException {
            return this.removeFolder(id);
        }

        public CloudFile untrashFile(Node fileNode) throws CloudDriveException, RepositoryException {
            String dbxPath = JCRLocalDropboxDrive.this.getDropboxPath(fileNode);
            String rev = this.getRev(fileNode);
            MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo((Metadata)this.api.restoreFile(dbxPath, rev));
            return JCRLocalDropboxDrive.this.updateItem(this.api, item, null, fileNode);
        }

        public CloudFile untrashFolder(Node folderNode) throws CloudDriveException, RepositoryException {
            JCRLocalCloudFile localFile;
            String id = this.getId(folderNode);
            MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo(this.api.get(id, true));
            if (item.isDeleted()) {
                item = JCRLocalDropboxDrive.this.itemInfo((Metadata)this.api.createFolder(item.getParentPath(), this.getTitle(folderNode)));
                localFile = JCRLocalDropboxDrive.this.updateItem(this.api, item.asItem(), null, folderNode);
            } else if (item.isFolder()) {
                localFile = JCRLocalDropboxDrive.this.updateItem(this.api, item.asItem(), null, folderNode);
            } else if (item.isFile()) {
                LOG.warn((Object)("Found file with an ID of untrahsed folder: " + id + " path: " + item.getPath()));
                localFile = JCRLocalDropboxDrive.this.updateItem(this.api, item.asFile(), null, folderNode);
            } else {
                LOG.warn((Object)("Found unrecognized item type with ID of untrahsed folder: " + id + " path: " + item.getPath() + " item: " + item));
                throw new NotFoundException("Unrecognized item with ID of untrahsed folder");
            }
            if (localFile != null && localFile.isFolder()) {
                NodeIterator children = folderNode.getNodes();
                while (children.hasNext()) {
                    Node childNode = children.nextNode();
                    if (this.isFolder(childNode)) {
                        this.untrashFolder(childNode);
                        continue;
                    }
                    if (this.isFile(childNode)) {
                        this.untrashFile(childNode);
                        continue;
                    }
                    JCRLocalDropboxDrive.this.removeNode(childNode);
                }
            }
            return localFile;
        }

        public boolean isTrashSupported() {
            return true;
        }

        public CloudFile restore(String id, String nodePath) throws CloudDriveException, RepositoryException {
            Node node;
            if (DropboxAPI.ROOT_PATH_V2.equals(id)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cannot restore root folder - ignore it: " + id + " node: " + nodePath));
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(">> restore(" + id + ", " + nodePath + ")"));
            }
            JCRLocalCloudFile restored = null;
            Session session = JCRLocalDropboxDrive.this.session();
            try {
                Item jcrItem = session.getItem(nodePath);
                if (!jcrItem.isNode()) {
                    throw new CloudDriveException("Cannot restore cloud file with not Node path: " + nodePath);
                }
                node = (Node)Node.class.cast(jcrItem);
            }
            catch (PathNotFoundException e) {
                node = null;
            }
            DropboxDrive localDrive = new DropboxDrive(this.api, JCRLocalDropboxDrive.this.rootNode());
            if (node != null) {
                if ((node = localDrive.restore(node)) != null) {
                    restored = JCRLocalDropboxDrive.this.readFile(node);
                }
            } else {
                String assumedDbxPath;
                DropboxDrive.LocalItem localNode;
                Collection nodes = JCRLocalDropboxDrive.this.findNodes(Arrays.asList(id));
                for (Node n : nodes) {
                    if (restored == null) {
                        if ((n = localDrive.restore(n)) == null) continue;
                        restored = JCRLocalDropboxDrive.this.readFile(n);
                        continue;
                    }
                    JCRLocalDropboxDrive.this.removeNode(n);
                }
                if (restored == null && (node = (localNode = localDrive.getItem(assumedDbxPath = localDrive.getRemotePath(nodePath))).fetch(new Changes(){})) != null) {
                    restored = JCRLocalDropboxDrive.this.readFile(node);
                }
            }
            return restored;
        }

        protected String getRev(Node fileNode) throws RepositoryException {
            return fileNode.getProperty("dropbox:rev").getString();
        }

        protected CloudFile uploadFile(Node fileNode, Calendar created, Calendar modified, String mimeType, InputStream content, boolean update) throws CloudDriveException, RepositoryException {
            FileInfo file;
            String parentId = this.getParentId(fileNode);
            String title = this.getTitle(fileNode);
            String rev = update ? this.getRev(fileNode) : null;
            try {
                file = JCRLocalDropboxDrive.this.itemInfo((Metadata)this.api.uploadFile(parentId, title, content, rev)).asFile();
            }
            catch (ConflictException e) {
                MetadataInfo item = JCRLocalDropboxDrive.this.itemInfo(this.api.get(this.api.filePath(parentId, title)));
                if (item.isFile()) {
                    file = item.asFile();
                    if (fileNode.hasNode("jcr:content")) {
                        fileNode.getNode("jcr:content").setProperty("jcr:data", JCRLocalCloudDrive.DUMMY_DATA);
                    }
                }
                throw e;
            }
            JCRLocalCloudFile localFile = JCRLocalDropboxDrive.this.updateItem(this.api, file, null, fileNode);
            return localFile;
        }

        protected MetadataInfo move(Node node) throws RepositoryException, DropboxException, RefreshAccessException, ConflictException, NotFoundException, NotAcceptableException, RetryLaterException {
            node.getSession().refresh(true);
            String id = this.getId(node);
            JCRLocalDropboxDrive.this.normalizeName(node);
            String srcPath = JCRLocalDropboxDrive.this.getDropboxPath(node);
            String srcParentPath = JCRLocalDropboxDrive.this.parentPath(srcPath);
            Node parent = node.getParent();
            String parentId = this.getId(parent);
            String destParentPath = JCRLocalDropboxDrive.this.getDropboxPath(parent);
            String destTitle = this.getTitle(node);
            String destName = this.api.lowerCase(destTitle);
            boolean isMove = !srcParentPath.equals(destParentPath) ? true : !srcPath.endsWith(destName);
            if (isMove) {
                MetadataInfo item;
                String destPath = this.api.filePath(parentId, destTitle);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Move remote: " + srcPath + " [" + id + "] -> " + destPath));
                }
                if ((item = JCRLocalDropboxDrive.this.itemInfo(this.api.move(id, destPath))).isFolder()) {
                    this.updateSubtree(node);
                }
                return item;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update not moved remote: " + srcPath + " [" + id + "]"));
            }
            return null;
        }

        protected void updateSubtree(Node folderNode) throws RepositoryException {
            NodeIterator niter = folderNode.getNodes();
            while (niter.hasNext()) {
                Node node = niter.nextNode();
                if (!this.isFile(node)) continue;
                this.resetSharing(node);
                if (!this.isFolder(node)) continue;
                this.updateSubtree(node);
            }
        }

        protected void resetSharing(Node fileNode) throws RepositoryException {
            fileNode.setProperty("dropbox:directLink", (String)null);
            fileNode.setProperty("dropbox:sharedLinkExpires", (String)null);
        }

        protected MetadataInfo copy(Node sourceNode, Node destNode) throws RepositoryException, DropboxException, RefreshAccessException, ConflictException, NotFoundException, RetryLaterException, NotAcceptableException {
            String sourceId = this.getId(sourceNode);
            String destParentId = this.getParentId(destNode);
            String title = this.getTitle(destNode);
            JCRLocalDropboxDrive.this.normalizeName(destNode);
            String destPath = this.api.filePath(destParentId, title);
            MetadataInfo f = JCRLocalDropboxDrive.this.itemInfo(this.api.copy(sourceId, destPath));
            return f;
        }
    }

    protected class MovedFile {
        protected final String jcrPath;
        protected final long expirationTime;

        protected MovedFile(String jcrPath) {
            this.jcrPath = jcrPath;
            this.expirationTime = System.currentTimeMillis() + 10000L;
        }

        protected boolean isNotOutdated() {
            return this.expirationTime >= System.currentTimeMillis();
        }

        protected boolean isOutdated() {
            return this.expirationTime < System.currentTimeMillis();
        }
    }

    protected class Connect
    extends JCRLocalCloudDrive.ConnectCommand
    implements Changes {
        protected final DropboxAPI api;

        protected Connect() throws RepositoryException, DriveRemovedException {
            super((JCRLocalCloudDrive)JCRLocalDropboxDrive.this);
            this.api = JCRLocalDropboxDrive.this.getUser().api();
        }

        protected void fetchFiles() throws CloudDriveException, RepositoryException {
            long changeId = System.currentTimeMillis();
            String driveCursor = this.api.getLatestCursor(DropboxAPI.ROOT_PATH_V2, true);
            DropboxAPI.ListFolder ls = JCRLocalDropboxDrive.this.fetchSubtree(this.api, DropboxAPI.ROOT_PATH_V2, this.driveNode, this.iterators, this);
            this.iterators.add(ls);
            if (!Thread.currentThread().isInterrupted()) {
                JCRLocalDropboxDrive.this.setChangeId(changeId);
                this.driveNode.setProperty("dropbox:cursor", driveCursor);
                this.driveNode.setProperty("dropbox:version", 2L);
                JCRLocalDropboxDrive.this.updateState(ls.getCursor());
            }
        }

        protected void execLocal() throws CloudDriveException, RepositoryException {
            JCRLocalDropboxDrive.this.commandEnv.configure((CloudDrive.Command)this);
            super.exec();
            JCRLocalDropboxDrive.this.fileHistory.clear();
            try {
                JCRLocalDropboxDrive.this.jcrListener.disable();
                String empty = "".intern();
                this.driveNode.setProperty("ecd:localHistory", empty);
                this.driveNode.setProperty("ecd:localChanges", empty);
                this.driveNode.save();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error cleaning local history in " + JCRLocalDropboxDrive.this.title()), e);
            }
            finally {
                JCRLocalDropboxDrive.this.jcrListener.enable();
            }
        }

        @Override
        public void apply(JCRLocalCloudFile local) throws RepositoryException, CloudDriveException {
            if (local.isChanged()) {
                String parentIdPath = JCRLocalDropboxDrive.this.fileAPI.getParentId(local.getNode());
                this.addConnected(parentIdPath, (CloudFile)local);
            }
        }

        @Override
        public void undo(JCRLocalCloudFile local) throws RepositoryException, CloudDriveException {
            if (local.isChanged()) {
                this.removeChanged((CloudFile)local);
            }
        }

        @Override
        public boolean canApply(String parentId, String fileId) {
            return !this.isConnected(parentId, fileId);
        }
    }

    protected static interface Changes {
        default public void apply(JCRLocalCloudFile changedFile) throws RepositoryException, CloudDriveException {
        }

        default public void undo(JCRLocalCloudFile changedFile) throws RepositoryException, CloudDriveException {
        }

        default public boolean removed(String path) throws RepositoryException, CloudDriveException {
            return false;
        }

        default public boolean canApply(String parentId, String fileId) {
            return true;
        }
    }
}

