/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.TimeRange;
import com.dropbox.core.v2.teamlog.EventCategory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class GetTeamEventsArg {
    protected final long limit;
    protected final String accountId;
    protected final TimeRange time;
    protected final EventCategory category;

    public GetTeamEventsArg(long limit, String accountId, TimeRange time, EventCategory category) {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 1000L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
        }
        this.limit = limit;
        if (accountId != null) {
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
        }
        this.accountId = accountId;
        this.time = time;
        this.category = category;
    }

    public GetTeamEventsArg() {
        this(1000L, null, null, null);
    }

    public long getLimit() {
        return this.limit;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public TimeRange getTime() {
        return this.time;
    }

    public EventCategory getCategory() {
        return this.category;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.limit, this.accountId, this.time, this.category});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetTeamEventsArg other = (GetTeamEventsArg)obj;
            return this.limit == other.limit && (this.accountId == other.accountId || this.accountId != null && this.accountId.equals(other.accountId)) && (this.time == other.time || this.time != null && this.time.equals(other.time)) && (this.category == other.category || this.category != null && this.category.equals((Object)other.category));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetTeamEventsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetTeamEventsArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("limit");
            StoneSerializers.uInt32().serialize((Long)value.limit, g);
            if (value.accountId != null) {
                g.writeFieldName("account_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.accountId, g);
            }
            if (value.time != null) {
                g.writeFieldName("time");
                StoneSerializers.nullableStruct(TimeRange.Serializer.INSTANCE).serialize(value.time, g);
            }
            if (value.category != null) {
                g.writeFieldName("category");
                StoneSerializers.nullable(EventCategory.Serializer.INSTANCE).serialize(value.category, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GetTeamEventsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            EventCategory f_category;
            TimeRange f_time;
            String f_accountId;
            Long f_limit;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_limit = 1000L;
                f_accountId = null;
                f_time = null;
                f_category = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    if ("account_id".equals(field)) {
                        f_accountId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("time".equals(field)) {
                        f_time = StoneSerializers.nullableStruct(TimeRange.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("category".equals(field)) {
                        f_category = StoneSerializers.nullable(EventCategory.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetTeamEventsArg value = new GetTeamEventsArg(f_limit, f_accountId, f_time, f_category);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected long limit = 1000L;
        protected String accountId = null;
        protected TimeRange time = null;
        protected EventCategory category = null;

        protected Builder() {
        }

        public Builder withLimit(Long limit) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 1000L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 1000L");
            }
            this.limit = limit != null ? limit : 1000L;
            return this;
        }

        public Builder withAccountId(String accountId) {
            if (accountId != null) {
                if (accountId.length() < 40) {
                    throw new IllegalArgumentException("String 'accountId' is shorter than 40");
                }
                if (accountId.length() > 40) {
                    throw new IllegalArgumentException("String 'accountId' is longer than 40");
                }
            }
            this.accountId = accountId;
            return this;
        }

        public Builder withTime(TimeRange time) {
            this.time = time;
            return this;
        }

        public Builder withCategory(EventCategory category) {
            this.category = category;
            return this;
        }

        public GetTeamEventsArg build() {
            return new GetTeamEventsArg(this.limit, this.accountId, this.time, this.category);
        }
    }
}

