/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.fileproperties.PropertyGroup;
import com.dropbox.core.v2.files.WriteMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class CommitInfo {
    protected final String path;
    protected final WriteMode mode;
    protected final boolean autorename;
    protected final Date clientModified;
    protected final boolean mute;
    protected final List<PropertyGroup> propertyGroups;

    public CommitInfo(String path, WriteMode mode, boolean autorename, Date clientModified, boolean mute, List<PropertyGroup> propertyGroups) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
        this.autorename = autorename;
        this.clientModified = LangUtil.truncateMillis(clientModified);
        this.mute = mute;
        if (propertyGroups != null) {
            for (PropertyGroup x : propertyGroups) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
            }
        }
        this.propertyGroups = propertyGroups;
    }

    public CommitInfo(String path) {
        this(path, WriteMode.ADD, false, null, false, null);
    }

    public String getPath() {
        return this.path;
    }

    public WriteMode getMode() {
        return this.mode;
    }

    public boolean getAutorename() {
        return this.autorename;
    }

    public Date getClientModified() {
        return this.clientModified;
    }

    public boolean getMute() {
        return this.mute;
    }

    public List<PropertyGroup> getPropertyGroups() {
        return this.propertyGroups;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.mode, this.autorename, this.clientModified, this.mute, this.propertyGroups});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CommitInfo other = (CommitInfo)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.mode != other.mode && !this.mode.equals(other.mode) || this.autorename != other.autorename || this.clientModified != other.clientModified && (this.clientModified == null || !this.clientModified.equals(other.clientModified)) || this.mute != other.mute || this.propertyGroups != other.propertyGroups && (this.propertyGroups == null || !this.propertyGroups.equals(other.propertyGroups)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<CommitInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CommitInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g);
            g.writeFieldName("mode");
            WriteMode.Serializer.INSTANCE.serialize(value.mode, g);
            g.writeFieldName("autorename");
            StoneSerializers.boolean_().serialize((Boolean)value.autorename, g);
            if (value.clientModified != null) {
                g.writeFieldName("client_modified");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.clientModified, g);
            }
            g.writeFieldName("mute");
            StoneSerializers.boolean_().serialize((Boolean)value.mute, g);
            if (value.propertyGroups != null) {
                g.writeFieldName("property_groups");
                StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).serialize(value.propertyGroups, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public CommitInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyGroup> f_propertyGroups;
            Boolean f_mute;
            Date f_clientModified;
            Boolean f_autorename;
            WriteMode f_mode;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_mode = WriteMode.ADD;
                f_autorename = false;
                f_clientModified = null;
                f_mute = false;
                f_propertyGroups = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = WriteMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("autorename".equals(field)) {
                        f_autorename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("client_modified".equals(field)) {
                        f_clientModified = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("mute".equals(field)) {
                        f_mute = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("property_groups".equals(field)) {
                        f_propertyGroups = StoneSerializers.nullable(StoneSerializers.list(PropertyGroup.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            CommitInfo value = new CommitInfo(f_path, f_mode, f_autorename, f_clientModified, f_mute, f_propertyGroups);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected WriteMode mode;
        protected boolean autorename;
        protected Date clientModified;
        protected boolean mute;
        protected List<PropertyGroup> propertyGroups;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)|(id:.*)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.mode = WriteMode.ADD;
            this.autorename = false;
            this.clientModified = null;
            this.mute = false;
            this.propertyGroups = null;
        }

        public Builder withMode(WriteMode mode) {
            this.mode = mode != null ? mode : WriteMode.ADD;
            return this;
        }

        public Builder withAutorename(Boolean autorename) {
            this.autorename = autorename != null ? autorename : false;
            return this;
        }

        public Builder withClientModified(Date clientModified) {
            this.clientModified = LangUtil.truncateMillis(clientModified);
            return this;
        }

        public Builder withMute(Boolean mute) {
            this.mute = mute != null ? mute : false;
            return this;
        }

        public Builder withPropertyGroups(List<PropertyGroup> propertyGroups) {
            if (propertyGroups != null) {
                for (PropertyGroup x : propertyGroups) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'propertyGroups' is null");
                }
            }
            this.propertyGroups = propertyGroups;
            return this;
        }

        public CommitInfo build() {
            return new CommitInfo(this.path, this.mode, this.autorename, this.clientModified, this.mute, this.propertyGroups);
        }
    }
}

