/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.FileLogInfo;
import com.dropbox.core.v2.teamlog.FolderLogInfo;
import com.dropbox.core.v2.teamlog.PaperDocumentLogInfo;
import com.dropbox.core.v2.teamlog.PaperFolderLogInfo;
import com.dropbox.core.v2.teamlog.ShowcaseDocumentLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class AssetLogInfo {
    public static final AssetLogInfo OTHER = new AssetLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private FileLogInfo fileValue;
    private FolderLogInfo folderValue;
    private PaperDocumentLogInfo paperDocumentValue;
    private PaperFolderLogInfo paperFolderValue;
    private ShowcaseDocumentLogInfo showcaseDocumentValue;

    private AssetLogInfo() {
    }

    private AssetLogInfo withTag(Tag _tag) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        return result;
    }

    private AssetLogInfo withTagAndFile(Tag _tag, FileLogInfo fileValue) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        result.fileValue = fileValue;
        return result;
    }

    private AssetLogInfo withTagAndFolder(Tag _tag, FolderLogInfo folderValue) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        result.folderValue = folderValue;
        return result;
    }

    private AssetLogInfo withTagAndPaperDocument(Tag _tag, PaperDocumentLogInfo paperDocumentValue) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        result.paperDocumentValue = paperDocumentValue;
        return result;
    }

    private AssetLogInfo withTagAndPaperFolder(Tag _tag, PaperFolderLogInfo paperFolderValue) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        result.paperFolderValue = paperFolderValue;
        return result;
    }

    private AssetLogInfo withTagAndShowcaseDocument(Tag _tag, ShowcaseDocumentLogInfo showcaseDocumentValue) {
        AssetLogInfo result = new AssetLogInfo();
        result._tag = _tag;
        result.showcaseDocumentValue = showcaseDocumentValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isFile() {
        return this._tag == Tag.FILE;
    }

    public static AssetLogInfo file(FileLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AssetLogInfo().withTagAndFile(Tag.FILE, value);
    }

    public FileLogInfo getFileValue() {
        if (this._tag != Tag.FILE) {
            throw new IllegalStateException("Invalid tag: required Tag.FILE, but was Tag." + this._tag.name());
        }
        return this.fileValue;
    }

    public boolean isFolder() {
        return this._tag == Tag.FOLDER;
    }

    public static AssetLogInfo folder(FolderLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AssetLogInfo().withTagAndFolder(Tag.FOLDER, value);
    }

    public FolderLogInfo getFolderValue() {
        if (this._tag != Tag.FOLDER) {
            throw new IllegalStateException("Invalid tag: required Tag.FOLDER, but was Tag." + this._tag.name());
        }
        return this.folderValue;
    }

    public boolean isPaperDocument() {
        return this._tag == Tag.PAPER_DOCUMENT;
    }

    public static AssetLogInfo paperDocument(PaperDocumentLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AssetLogInfo().withTagAndPaperDocument(Tag.PAPER_DOCUMENT, value);
    }

    public PaperDocumentLogInfo getPaperDocumentValue() {
        if (this._tag != Tag.PAPER_DOCUMENT) {
            throw new IllegalStateException("Invalid tag: required Tag.PAPER_DOCUMENT, but was Tag." + this._tag.name());
        }
        return this.paperDocumentValue;
    }

    public boolean isPaperFolder() {
        return this._tag == Tag.PAPER_FOLDER;
    }

    public static AssetLogInfo paperFolder(PaperFolderLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AssetLogInfo().withTagAndPaperFolder(Tag.PAPER_FOLDER, value);
    }

    public PaperFolderLogInfo getPaperFolderValue() {
        if (this._tag != Tag.PAPER_FOLDER) {
            throw new IllegalStateException("Invalid tag: required Tag.PAPER_FOLDER, but was Tag." + this._tag.name());
        }
        return this.paperFolderValue;
    }

    public boolean isShowcaseDocument() {
        return this._tag == Tag.SHOWCASE_DOCUMENT;
    }

    public static AssetLogInfo showcaseDocument(ShowcaseDocumentLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AssetLogInfo().withTagAndShowcaseDocument(Tag.SHOWCASE_DOCUMENT, value);
    }

    public ShowcaseDocumentLogInfo getShowcaseDocumentValue() {
        if (this._tag != Tag.SHOWCASE_DOCUMENT) {
            throw new IllegalStateException("Invalid tag: required Tag.SHOWCASE_DOCUMENT, but was Tag." + this._tag.name());
        }
        return this.showcaseDocumentValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.fileValue, this.folderValue, this.paperDocumentValue, this.paperFolderValue, this.showcaseDocumentValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AssetLogInfo) {
            AssetLogInfo other = (AssetLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case FILE: {
                    return this.fileValue == other.fileValue || this.fileValue.equals(other.fileValue);
                }
                case FOLDER: {
                    return this.folderValue == other.folderValue || this.folderValue.equals(other.folderValue);
                }
                case PAPER_DOCUMENT: {
                    return this.paperDocumentValue == other.paperDocumentValue || this.paperDocumentValue.equals(other.paperDocumentValue);
                }
                case PAPER_FOLDER: {
                    return this.paperFolderValue == other.paperFolderValue || this.paperFolderValue.equals(other.paperFolderValue);
                }
                case SHOWCASE_DOCUMENT: {
                    return this.showcaseDocumentValue == other.showcaseDocumentValue || this.showcaseDocumentValue.equals(other.showcaseDocumentValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<AssetLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AssetLogInfo value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case FILE: {
                    g.writeStartObject();
                    this.writeTag("file", g);
                    FileLogInfo.Serializer.INSTANCE.serialize(value.fileValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case FOLDER: {
                    g.writeStartObject();
                    this.writeTag("folder", g);
                    FolderLogInfo.Serializer.INSTANCE.serialize(value.folderValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case PAPER_DOCUMENT: {
                    g.writeStartObject();
                    this.writeTag("paper_document", g);
                    PaperDocumentLogInfo.Serializer.INSTANCE.serialize(value.paperDocumentValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case PAPER_FOLDER: {
                    g.writeStartObject();
                    this.writeTag("paper_folder", g);
                    PaperFolderLogInfo.Serializer.INSTANCE.serialize(value.paperFolderValue, g, true);
                    g.writeEndObject();
                    break;
                }
                case SHOWCASE_DOCUMENT: {
                    g.writeStartObject();
                    this.writeTag("showcase_document", g);
                    ShowcaseDocumentLogInfo.Serializer.INSTANCE.serialize(value.showcaseDocumentValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public AssetLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            AssetLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("file".equals(tag)) {
                FileLogInfo fieldValue = null;
                fieldValue = FileLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AssetLogInfo.file(fieldValue);
            } else if ("folder".equals(tag)) {
                FolderLogInfo fieldValue = null;
                fieldValue = FolderLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AssetLogInfo.folder(fieldValue);
            } else if ("paper_document".equals(tag)) {
                PaperDocumentLogInfo fieldValue = null;
                fieldValue = PaperDocumentLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AssetLogInfo.paperDocument(fieldValue);
            } else if ("paper_folder".equals(tag)) {
                PaperFolderLogInfo fieldValue = null;
                fieldValue = PaperFolderLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AssetLogInfo.paperFolder(fieldValue);
            } else if ("showcase_document".equals(tag)) {
                ShowcaseDocumentLogInfo fieldValue = null;
                fieldValue = ShowcaseDocumentLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = AssetLogInfo.showcaseDocument(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        FILE,
        FOLDER,
        PAPER_DOCUMENT,
        PAPER_FOLDER,
        SHOWCASE_DOCUMENT,
        OTHER;

    }
}

