/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.auth.oauth;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import org.exoplatform.shaded.google.api.client.auth.oauth.OAuthSigner;
import org.exoplatform.shaded.google.api.client.util.Base64;
import org.exoplatform.shaded.google.api.client.util.Beta;
import org.exoplatform.shaded.google.api.client.util.SecurityUtils;
import org.exoplatform.shaded.google.api.client.util.StringUtils;

@Beta
public final class OAuthRsaSigner
implements OAuthSigner {
    public PrivateKey privateKey;

    public String getSignatureMethod() {
        return "RSA-SHA1";
    }

    public String computeSignature(String signatureBaseString) throws GeneralSecurityException {
        Signature signer = SecurityUtils.getSha1WithRsaSignatureAlgorithm();
        byte[] data = StringUtils.getBytesUtf8(signatureBaseString);
        return Base64.encodeBase64String(SecurityUtils.sign(signer, this.privateKey, data));
    }
}

