/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.shaded.google.api.client.googleapis.batch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.shaded.google.api.client.googleapis.batch.BatchCallback;
import org.exoplatform.shaded.google.api.client.googleapis.batch.BatchUnparsedResponse;
import org.exoplatform.shaded.google.api.client.googleapis.batch.HttpRequestContent;
import org.exoplatform.shaded.google.api.client.http.BackOffPolicy;
import org.exoplatform.shaded.google.api.client.http.GenericUrl;
import org.exoplatform.shaded.google.api.client.http.HttpExecuteInterceptor;
import org.exoplatform.shaded.google.api.client.http.HttpHeaders;
import org.exoplatform.shaded.google.api.client.http.HttpRequest;
import org.exoplatform.shaded.google.api.client.http.HttpRequestFactory;
import org.exoplatform.shaded.google.api.client.http.HttpRequestInitializer;
import org.exoplatform.shaded.google.api.client.http.HttpResponse;
import org.exoplatform.shaded.google.api.client.http.HttpTransport;
import org.exoplatform.shaded.google.api.client.http.MultipartContent;
import org.exoplatform.shaded.google.api.client.util.Preconditions;
import org.exoplatform.shaded.google.api.client.util.Sleeper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BatchRequest {
    private GenericUrl batchUrl = new GenericUrl("https://www.googleapis.com/batch");
    private final HttpRequestFactory requestFactory;
    List<RequestInfo<?, ?>> requestInfos = new ArrayList();
    private Sleeper sleeper = Sleeper.DEFAULT;

    public BatchRequest(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this.requestFactory = httpRequestInitializer == null ? transport.createRequestFactory() : transport.createRequestFactory(httpRequestInitializer);
    }

    public BatchRequest setBatchUrl(GenericUrl batchUrl) {
        this.batchUrl = batchUrl;
        return this;
    }

    public GenericUrl getBatchUrl() {
        return this.batchUrl;
    }

    public Sleeper getSleeper() {
        return this.sleeper;
    }

    public BatchRequest setSleeper(Sleeper sleeper) {
        this.sleeper = Preconditions.checkNotNull(sleeper);
        return this;
    }

    public <T, E> BatchRequest queue(HttpRequest httpRequest, Class<T> dataClass, Class<E> errorClass, BatchCallback<T, E> callback) throws IOException {
        Preconditions.checkNotNull(httpRequest);
        Preconditions.checkNotNull(callback);
        Preconditions.checkNotNull(dataClass);
        Preconditions.checkNotNull(errorClass);
        this.requestInfos.add(new RequestInfo<T, E>(callback, dataClass, errorClass, httpRequest));
        return this;
    }

    public int size() {
        return this.requestInfos.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        boolean retryAllowed;
        Preconditions.checkState(!this.requestInfos.isEmpty());
        HttpRequest batchRequest = this.requestFactory.buildPostRequest(this.batchUrl, null);
        HttpExecuteInterceptor originalInterceptor = batchRequest.getInterceptor();
        batchRequest.setInterceptor(new BatchInterceptor(originalInterceptor));
        int retriesRemaining = batchRequest.getNumberOfRetries();
        BackOffPolicy backOffPolicy = batchRequest.getBackOffPolicy();
        if (backOffPolicy != null) {
            backOffPolicy.reset();
        }
        do {
            long backOffTime;
            BatchUnparsedResponse batchResponse;
            retryAllowed = retriesRemaining > 0;
            MultipartContent batchContent = new MultipartContent();
            batchContent.getMediaType().setSubType("mixed");
            int contentId = 1;
            for (RequestInfo<?, ?> requestInfo : this.requestInfos) {
                batchContent.addPart(new MultipartContent.Part(new HttpHeaders().setAcceptEncoding(null).set("Content-ID", contentId++), new HttpRequestContent(requestInfo.request)));
            }
            batchRequest.setContent(batchContent);
            HttpResponse response = batchRequest.execute();
            try {
                String string = String.valueOf(response.getMediaType().getParameter("boundary"));
                String boundary = string.length() != 0 ? "--".concat(string) : new String("--");
                InputStream contentStream = response.getContent();
                batchResponse = new BatchUnparsedResponse(contentStream, boundary, this.requestInfos, retryAllowed);
                while (batchResponse.hasNext) {
                    batchResponse.parseNextResponse();
                }
            }
            finally {
                response.disconnect();
            }
            List<RequestInfo<?, ?>> unsuccessfulRequestInfos = batchResponse.unsuccessfulRequestInfos;
            if (unsuccessfulRequestInfos.isEmpty()) break;
            this.requestInfos = unsuccessfulRequestInfos;
            if (batchResponse.backOffRequired && backOffPolicy != null && (backOffTime = backOffPolicy.getNextBackOffMillis()) != -1L) {
                try {
                    this.sleeper.sleep(backOffTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            --retriesRemaining;
        } while (retryAllowed);
        this.requestInfos.clear();
    }

    class BatchInterceptor
    implements HttpExecuteInterceptor {
        private HttpExecuteInterceptor originalInterceptor;

        BatchInterceptor(HttpExecuteInterceptor originalInterceptor) {
            this.originalInterceptor = originalInterceptor;
        }

        public void intercept(HttpRequest batchRequest) throws IOException {
            if (this.originalInterceptor != null) {
                this.originalInterceptor.intercept(batchRequest);
            }
            for (RequestInfo<?, ?> requestInfo : BatchRequest.this.requestInfos) {
                HttpExecuteInterceptor interceptor = requestInfo.request.getInterceptor();
                if (interceptor == null) continue;
                interceptor.intercept(requestInfo.request);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RequestInfo<T, E> {
        final BatchCallback<T, E> callback;
        final Class<T> dataClass;
        final Class<E> errorClass;
        final HttpRequest request;

        RequestInfo(BatchCallback<T, E> callback, Class<T> dataClass, Class<E> errorClass, HttpRequest request) {
            this.callback = callback;
            this.dataClass = dataClass;
            this.errorClass = errorClass;
            this.request = request;
        }
    }
}

