/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.viewer;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.ecms.BaseCloudDriveManagerComponent;
import org.exoplatform.clouddrive.ecms.viewer.CloudFileViewer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public abstract class AbstractFileViewer
extends BaseCloudDriveManagerComponent
implements CloudFileViewer {
    protected CloudDrive drive;
    protected CloudFile file;
    protected final long viewableMaxSize;

    protected AbstractFileViewer(long viewableMaxSize) {
        this.viewableMaxSize = viewableMaxSize;
    }

    protected AbstractFileViewer() {
        this(Long.MAX_VALUE);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.initContext();
        Object obj = context.getAttribute(CloudDrive.class);
        if (obj != null) {
            CloudDrive drive = (CloudDrive)obj;
            obj = context.getAttribute(CloudFile.class);
            if (obj != null) {
                this.initFile(drive, (CloudFile)obj);
            }
        }
        super.processRender(context);
    }

    @Override
    public void initFile(CloudDrive drive, CloudFile file) {
        this.drive = drive;
        this.file = file;
    }

    public CloudDrive getDrive() {
        return this.drive;
    }

    public CloudFile getFile() {
        return this.file;
    }

    public boolean isViewable() {
        String mimeType = this.file.getType();
        return this.file.getSize() <= this.viewableMaxSize && !mimeType.startsWith("application/octet-stream");
    }

    public String appRes(String key) {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(new String[]{"locale.clouddrive.CloudDrive", "locale.ecm.views"}, locale, this.getClass().getClassLoader());
        return resourceBundle.getString(key);
    }
}

