/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.json.parser;

public class JSONParseException
extends Exception {
    private static final long serialVersionUID = -7880698968187728548L;
    public static final int ERROR_UNEXPECTED_CHAR = 0;
    public static final int ERROR_UNEXPECTED_TOKEN = 1;
    public static final int ERROR_UNEXPECTED_EXCEPTION = 2;
    public static final int ERROR_STRING_TOO_LONG = 3;
    public static final int ERROR_JSON_TOO_BIG = 4;
    private int errorType;
    private Object unexpectedObject;
    private int position;

    public JSONParseException(int errorType) {
        this(-1, errorType, null);
    }

    public JSONParseException(int errorType, Object unexpectedObject) {
        this(-1, errorType, unexpectedObject);
    }

    public JSONParseException(int position, int errorType, Object unexpectedObject) {
        this.position = position;
        this.errorType = errorType;
        this.unexpectedObject = unexpectedObject;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder(128);
        switch (this.errorType) {
            case 0: {
                sb.append("Unexpected character (").append(this.unexpectedObject).append(") at position ").append(this.position).append('.');
                break;
            }
            case 1: {
                sb.append("Unexpected token ").append(this.unexpectedObject).append(" at position ").append(this.position).append('.');
                break;
            }
            case 2: {
                sb.append("Unexpected exception at position ").append(this.position).append(": ").append(this.unexpectedObject);
                break;
            }
            case 3: {
                sb.append("String too long");
                break;
            }
            case 4: {
                sb.append("JSON too big");
                break;
            }
            default: {
                sb.append("Unkown error at position ").append(this.position).append('.');
            }
        }
        return sb.toString();
    }

    public int getErrorType() {
        return this.errorType;
    }

    public void setErrorType(int errorType) {
        this.errorType = errorType;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Object getUnexpectedObject() {
        return this.unexpectedObject;
    }

    public void setUnexpectedObject(Object unexpectedObject) {
        this.unexpectedObject = unexpectedObject;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

