/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.action;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.ecms.CloudDriveContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.wcm.ext.component.activity.FileUIActivity;
import org.exoplatform.wcm.ext.component.activity.SharedFileUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/social-integration/UISharedFile.gtmpl", events={@EventConfig(listeners={FileUIActivity.ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})}), @ComponentConfig(type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={SharedFileUIActivity.CloseActionListener.class}, name="ClosePopup")})})
public class SharedCloudFileUIActivity
extends SharedFileUIActivity {
    public static final String ACTIVITY_CSS_CLASS = "uiCloudFileActivity";
    protected static final Log LOG = ExoLogger.getLogger(SharedCloudFileUIActivity.class);
    protected final CloudDriveService cloudDrives = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);

    protected String getSize(Node node) {
        CloudFile file = this.cloudFile(node);
        return file != null ? (file.getSize() > 0L ? FileUtils.byteCountToDisplaySize((long)file.getSize()) : "") : super.getSize(node);
    }

    protected double getFileSize(Node node) {
        CloudFile file = this.cloudFile(node);
        return file != null ? (double)(file.getSize() > 0L ? file.getSize() : 1L) : super.getFileSize(node);
    }

    public String getWebdavURL() throws Exception {
        CloudFile file = this.cloudFile(this.getContentNode());
        if (file != null) {
            return file.getLink();
        }
        return super.getWebdavURL();
    }

    protected String getCssClassIconFile(String fileName, String fileType) {
        try {
            Node node = this.getContentNode();
            if (node != null) {
                String path = node.getPath();
                String workspace = node.getSession().getWorkspace().getName();
                CloudDriveContext.init(WebuiRequestContext.getCurrentInstance(), workspace, path);
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("Error initializing current node for shared cloud file link: " + fileName), e);
        }
        return super.getCssClassIconFile(fileName, fileType) + ' ' + ACTIVITY_CSS_CLASS;
    }

    public String getDownloadLink() {
        CloudFile file = this.cloudFile(this.getContentNode());
        if (file != null) {
            return file.getLink();
        }
        return super.getDownloadLink();
    }

    public boolean isFileSupportPreview(Node data) throws Exception {
        if (data != null) {
            UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
            List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(Node.class.getName(), data);
            context.put("mimeType", data.getNode("jcr:content").getProperty("jcr:mimeType").getString());
            for (UIExtension extension : extensions) {
                if (!manager.accept("org.exoplatform.ecm.dms.FileViewer", extension.getName(), context) || "Text".equals(extension.getName())) continue;
                return true;
            }
        }
        return super.isFileSupportPreview(data);
    }

    protected String getDocAuthor(Node node) {
        CloudFile file = this.cloudFile(node);
        return file != null ? this.getUserFullName(file.getAuthor()) : super.getDocAuthor(node);
    }

    protected String getDocUpdateDate(Node node) {
        CloudFile file = this.cloudFile(node);
        if (file != null) {
            Calendar modified = file.getModifiedDate();
            TimeZone tz = modified.getTimeZone();
            ZoneId zid = tz == null ? ZoneId.systemDefault() : tz.toZoneId();
            LocalDateTime parsedDate = LocalDateTime.ofInstant(modified.toInstant(), zid);
            return parsedDate.format(this.getDateTimeFormatter());
        }
        return super.getDocUpdateDate(node);
    }

    protected CloudFile cloudFile(Node node) {
        block10: {
            if (node != null) {
                try {
                    String workspace = node.getSession().getWorkspace().getName();
                    String path = node.getPath();
                    CloudDrive drive = this.cloudDrives.findDrive(workspace, path);
                    if (drive == null) break block10;
                    try {
                        return drive.getFile(path);
                    }
                    catch (NotYetCloudFileException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Not yet cloud file " + workspace + ":" + path), (Throwable)e);
                        }
                    }
                    catch (NotCloudFileException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Not cloud file " + workspace + ":" + path), (Throwable)e);
                        }
                    }
                    catch (DriveRemovedException e) {
                        LOG.warn((Object)("Cloud drive removed " + workspace + ":" + path), (Throwable)e);
                    }
                    catch (NotCloudDriveException e) {
                        LOG.warn((Object)("Not cloud drive " + workspace + ":" + path), (Throwable)e);
                    }
                }
                catch (RepositoryException e) {
                    LOG.error((Object)("Error getting cloud file node " + node), (Throwable)e);
                }
            }
        }
        return null;
    }

    public String getUserFullName(String userName) {
        if (userName.indexOf(32) == -1 && userName.indexOf(64) == -1) {
            String fullName = super.getUserFullName(userName);
            if (fullName == null || fullName.length() == 0) {
                fullName = userName;
            }
            return fullName;
        }
        return userName;
    }
}

