/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.apache.chemistry.opencmis.client.SessionParameterMap;
import org.apache.chemistry.opencmis.client.api.CmisEndpointDocumentReader;
import org.apache.chemistry.opencmis.commons.endpoints.CmisAuthentication;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpoint;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointsDocumentHelper;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;

public class CmisEndpointDocumentReaderImpl
implements CmisEndpointDocumentReader {
    public CmisEndpointsDocument read(URL url) throws IOException {
        try {
            return CmisEndpointsDocumentHelper.read((URL)url);
        }
        catch (JSONParseException e) {
            throw new IllegalArgumentException("Not a CMIS Endpoint Document!", e);
        }
    }

    public CmisEndpointsDocument read(File file) throws IOException {
        try {
            return CmisEndpointsDocumentHelper.read((File)file);
        }
        catch (JSONParseException e) {
            throw new IllegalArgumentException("Not a CMIS Endpoint Document!", e);
        }
    }

    public CmisEndpointsDocument read(InputStream in) throws IOException {
        try {
            return CmisEndpointsDocumentHelper.read((InputStream)in);
        }
        catch (JSONParseException e) {
            throw new IllegalArgumentException("Not a CMIS Endpoint Document!", e);
        }
    }

    public CmisEndpointsDocument read(Reader in) throws IOException {
        try {
            return CmisEndpointsDocumentHelper.read((Reader)in);
        }
        catch (JSONParseException e) {
            throw new IllegalArgumentException("Not a CMIS Endpoint Document!", e);
        }
    }

    public CmisEndpointsDocument read(String in) {
        try {
            return CmisEndpointsDocumentHelper.read((String)in);
        }
        catch (JSONParseException e) {
            throw new IllegalArgumentException("Not a CMIS Endpoint Document!", e);
        }
    }

    public Map<String, String> pepareSessionParameters(CmisAuthentication authentication) {
        if (authentication == null) {
            throw new IllegalArgumentException("Authentication object must be provided!");
        }
        if (authentication.getEndpoint() == null) {
            throw new IllegalArgumentException("Authentication object has no endpoint information!");
        }
        SessionParameterMap result = new SessionParameterMap();
        CmisEndpoint endpoint = authentication.getEndpoint();
        String binding = endpoint.getBinding();
        if ("atompub".equals(binding)) {
            result.setAtomPubBindingUrl(endpoint.getUrl());
        } else if ("browser".equals(binding)) {
            result.setBrowserBindingUrl(endpoint.getUrl());
        } else if ("webservices".equals(binding)) {
            if (endpoint.getUrl() != null) {
                result.setWebServicesBindingUrl(endpoint.getUrl());
            } else {
                result.put((Object)"org.apache.chemistry.opencmis.binding.spi.type", (Object)BindingType.WEBSERVICES.value());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.RepositoryService", (Object)endpoint.getRepositoryServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.NavigationService", (Object)endpoint.getNavigationServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.ObjectService", (Object)endpoint.getObjectServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.VersioningService", (Object)endpoint.getVersioningServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", (Object)endpoint.getDiscoveryServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", (Object)endpoint.getMultifilingServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.RelationshipService", (Object)endpoint.getRelationshipServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.ACLService", (Object)endpoint.getAclServiceWdsl());
                result.put((Object)"org.apache.chemistry.opencmis.binding.webservices.PolicyService", (Object)endpoint.getPolicyServiceWdsl());
            }
        }
        if ("none".equals(authentication.getType())) {
            result.setNoAuthentication();
        } else if ("basic".equals(authentication.getType())) {
            result.setBasicAuthentication();
        } else if ("usernameToken".equals(authentication.getType())) {
            result.setUsernameTokenAuthentication(false);
        } else if ("oauth".equals(authentication.getType())) {
            result.setOAuthAuthentication();
        } else if ("ntlm".equals(authentication.getType())) {
            result.setNtlmAuthentication();
        }
        result.setCookies(authentication.requiresCookies() || !"optional".equals(endpoint.getCookies()));
        result.setCompression("server".equals(endpoint.getCompression()) || "both".equals(endpoint.getCompression()));
        result.setClientCompression("client".equals(endpoint.getCompression()) || "both".equals(endpoint.getCompression()));
        result.setCsrfHeader(endpoint.getCsrfHeader());
        return result;
    }
}

