/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class Cursor {
    protected final String value;
    protected final Date expiration;

    public Cursor(String value, Date expiration) {
        if (value == null) {
            throw new IllegalArgumentException("Required value for 'value' is null");
        }
        this.value = value;
        this.expiration = LangUtil.truncateMillis(expiration);
    }

    public Cursor(String value) {
        this(value, null);
    }

    public String getValue() {
        return this.value;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.value, this.expiration});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            Cursor other = (Cursor)obj;
            return (this.value == other.value || this.value.equals(other.value)) && (this.expiration == other.expiration || this.expiration != null && this.expiration.equals(other.expiration));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<Cursor> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(Cursor value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("value");
            StoneSerializers.string().serialize(value.value, g);
            if (value.expiration != null) {
                g.writeFieldName("expiration");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expiration, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public Cursor deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_expiration;
            String f_value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_value = null;
                f_expiration = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("value".equals(field)) {
                        f_value = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("expiration".equals(field)) {
                        f_expiration = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_value == null) {
                    throw new JsonParseException(p, "Required field \"value\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            Cursor value = new Cursor(f_value, f_expiration);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

