/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudDriveContext {
    protected static final String JAVASCRIPT = "CloudDriveContext_Javascript".intern();
    protected static final String JAVASCRIPT_NODES = "CloudDriveContext_JavascriptNodes".intern();

    public static boolean init(RequestContext requestContext, String workspace, String nodePath) {
        Object script = requestContext.getAttribute(JAVASCRIPT);
        if (script == null) {
            JavascriptManager js = ((WebuiRequestContext)requestContext).getJavascriptManager();
            js.require("SHARED/cloudDrive", "cloudDrive").addScripts("\ncloudDrive.init('" + workspace + "','" + nodePath + "');\n");
            requestContext.setAttribute(JAVASCRIPT, (Object)JAVASCRIPT);
            return true;
        }
        return false;
    }

    public static boolean initNodes(RequestContext requestContext, Node parent) throws RepositoryException {
        NodeIterator childs;
        Object script = requestContext.getAttribute(JAVASCRIPT_NODES);
        if (script == null && (childs = parent.getNodes()).hasNext()) {
            CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
            StringBuilder map = new StringBuilder();
            map.append('{');
            do {
                Node child;
                CloudDrive drive;
                if ((drive = driveService.findDrive(child = childs.nextNode())) == null) continue;
                map.append('\"');
                map.append(child.getName());
                map.append("\":\"");
                map.append(drive.getUser().getProvider().getId());
                map.append("\",");
            } while (childs.hasNext());
            if (map.length() > 1) {
                map.deleteCharAt(map.length() - 1);
                map.append('}');
                JavascriptManager js = ((WebuiRequestContext)requestContext).getJavascriptManager();
                js.require("SHARED/cloudDrive", "cloudDrive").addScripts("\ncloudDrive.initNodes(" + map.toString() + ");\n");
                requestContext.setAttribute(JAVASCRIPT_NODES, (Object)JAVASCRIPT_NODES);
                return true;
            }
        }
        return false;
    }
}

