/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.ecms.CloudDriveUIExtension;
import org.exoplatform.clouddrive.ecms.CloudDriveUIMenuAction;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.picocontainer.Startable;

public class CloudDriveUIService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CloudDriveUIService.class);
    protected static final String DMS_SYSTEM_WORKSPACE = "dms-system";
    protected static final String EXO_BUTTONS = "exo:buttons";
    protected static final String ECD_USER_BUTTONS = "ecd:userButtons";
    protected static final String ECD_BUTTONS = "ecd:buttons";
    public static final String CONNECT_CLOUD_DRIVE_ACTION = "add.connect.clouddrive.action";
    protected final RepositoryService jcrService;
    protected final ManageViewService manageView;
    protected final CloudDriveService driveService;
    protected final UIExtensionManager uiExtensions;
    protected final Set<String> defaultMenuActions = new HashSet<String>();
    protected final List<String> VIEWS = Arrays.asList("List/List", "Admin/Admin", "Web/Authoring", "Icons/Icons", "Categories/Collaboration");

    public CloudDriveUIService(RepositoryService repoService, CloudDriveService driveService, UIExtensionManager uiExtensions, ManageViewService manageView) {
        this.jcrService = repoService;
        this.manageView = manageView;
        this.driveService = driveService;
        this.uiExtensions = uiExtensions;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CloudDriveUIExtension) {
            CloudDriveUIExtension ext = (CloudDriveUIExtension)plugin;
            this.defaultMenuActions.addAll(ext.getDefaultActions());
        } else {
            LOG.warn((Object)("Cannot recognize component plugin for " + plugin.getName() + ": type " + plugin.getClass() + " not supported"));
        }
    }

    protected List<String> getDefaultActions() throws Exception {
        ArrayList<String> cdActions = new ArrayList<String>();
        for (UIExtension ext : this.uiExtensions.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar")) {
            String menuAction = ext.getName();
            if (!this.defaultMenuActions.contains(menuAction)) continue;
            cdActions.add(menuAction);
        }
        return cdActions;
    }

    protected List<String> getAllActions() throws Exception {
        ArrayList<String> cdActions = new ArrayList<String>();
        for (UIExtension ext : this.uiExtensions.getUIExtensions("org.exoplatform.ecm.dms.UIActionBar")) {
            Class extComp = ext.getComponent();
            if (!CloudDriveUIMenuAction.class.isAssignableFrom(extComp)) continue;
            cdActions.add(ext.getName());
        }
        return cdActions;
    }

    protected void readViewActions(Node node, String buttons, StringBuilder actionsStr) throws RepositoryException {
        if (node.hasProperty(buttons)) {
            String[] actions = node.getProperty(buttons).getString().split(";");
            for (int i = 0; i < actions.length; ++i) {
                String a = actions[i].trim();
                if (actionsStr.indexOf(a) >= 0) continue;
                if (actionsStr.length() > 0) {
                    actionsStr.append(';');
                    actionsStr.append(' ');
                }
                actionsStr.append(a);
            }
        }
    }

    protected void splitViewActions(Node node, String buttons, StringBuilder cdActions, StringBuilder otherActions) throws RepositoryException {
        if (node.hasProperty(buttons)) {
            String[] actions = node.getProperty(buttons).getString().split(";");
            for (int i = 0; i < actions.length; ++i) {
                String a = actions[i].trim();
                String aname = this.capitalize(a);
                UIExtension ae = this.uiExtensions.getUIExtension("org.exoplatform.ecm.dms.UIActionBar", aname);
                if (ae != null) {
                    if (CloudDriveUIMenuAction.class.isAssignableFrom(ae.getComponent())) {
                        if (cdActions.indexOf(a) >= 0) continue;
                        if (cdActions.length() > 0) {
                            cdActions.append(';');
                            cdActions.append(' ');
                        }
                        cdActions.append(a);
                        continue;
                    }
                    if (otherActions.indexOf(a) >= 0) continue;
                    if (otherActions.length() > 0) {
                        otherActions.append(';');
                        otherActions.append(' ');
                    }
                    otherActions.append(a);
                    continue;
                }
                LOG.warn((Object)("Cannot find UIExtension for action " + aname));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareViews() throws Exception {
        SessionProvider jcrSessions = SessionProvider.createSystemProvider();
        try {
            Session session = jcrSessions.getSession(DMS_SYSTEM_WORKSPACE, this.jcrService.getCurrentRepository());
            for (String view : this.VIEWS) {
                Node viewNode = this.manageView.getViewByName(view, jcrSessions);
                StringBuilder newActions = new StringBuilder();
                this.readViewActions(viewNode, EXO_BUTTONS, newActions);
                int menuLength = newActions.length();
                this.readViewActions(viewNode, ECD_BUTTONS, newActions);
                if (newActions.length() == menuLength) {
                    StringBuilder cdActions = new StringBuilder();
                    cdActions.append(' ');
                    for (String cda : this.getDefaultActions()) {
                        String acs = this.uncapitalize(cda);
                        if (newActions.indexOf(acs) < 0) {
                            newActions.append(';');
                            newActions.append(' ');
                            newActions.append(acs);
                        }
                        if (cdActions.indexOf(acs) >= 0) continue;
                        cdActions.append(acs);
                        cdActions.append(';');
                    }
                    if (!viewNode.isNodeType(ECD_USER_BUTTONS)) {
                        viewNode.addMixin(ECD_USER_BUTTONS);
                    }
                    viewNode.setProperty(ECD_BUTTONS, cdActions.toString().trim());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("New buttons: " + newActions.toString()));
                }
                viewNode.setProperty(EXO_BUTTONS, newActions.toString());
            }
            session.save();
        }
        finally {
            jcrSessions.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreViews() throws Exception {
        SessionProvider jcrSessions = SessionProvider.createSystemProvider();
        try {
            Session session = jcrSessions.getSession(DMS_SYSTEM_WORKSPACE, this.jcrService.getCurrentRepository());
            for (String view : this.VIEWS) {
                Node viewNode = this.manageView.getViewByName(view, jcrSessions);
                StringBuilder newActions = new StringBuilder();
                StringBuilder cdActions = new StringBuilder();
                this.splitViewActions(viewNode, EXO_BUTTONS, cdActions, newActions);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Stored user buttons: " + cdActions.toString()));
                }
                viewNode.setProperty(EXO_BUTTONS, newActions.toString());
                viewNode.setProperty(ECD_BUTTONS, cdActions.toString());
            }
            session.save();
        }
        finally {
            jcrSessions.close();
        }
    }

    protected String capitalize(String text) {
        char[] tc = text.toCharArray();
        if (tc.length > 0) {
            tc[0] = Character.toUpperCase(tc[0]);
        }
        return new String(tc);
    }

    protected String uncapitalize(String text) {
        char[] tc = text.toCharArray();
        if (tc.length > 0) {
            tc[0] = Character.toLowerCase(tc[0]);
        }
        return new String(tc);
    }

    public void start() {
        try {
            this.prepareViews();
            List repoContainers = ExoContainerContext.getCurrentContainer().getComponentInstancesOfType(RepositoryContainer.class);
            for (Object rco : repoContainers) {
                RepositoryContainer rc = (RepositoryContainer)rco;
                WorkspaceContainer wc = rc.getWorkspaceContainer(DMS_SYSTEM_WORKSPACE);
                if (wc == null) continue;
                wc.registerComponentInstance((Object)new ViewRestorer());
            }
            LOG.info((Object)"Cloud Drive actions successfully enabled");
        }
        catch (Exception e) {
            LOG.error((Object)("Error enabling Cloud Drive actions: " + e.getMessage()), (Throwable)e);
        }
    }

    public void stop() {
    }

    class ViewRestorer
    implements Suspendable {
        boolean suspended = false;

        ViewRestorer() {
        }

        public void suspend() throws SuspendException {
            try {
                CloudDriveUIService.this.restoreViews();
                LOG.info((Object)"Cloud Drive actions successfully disabled");
            }
            catch (Exception e) {
                LOG.error((Object)("Error disabling Cloud Drive actions: " + e.getMessage()), (Throwable)e);
            }
            this.suspended = true;
        }

        public void resume() throws ResumeException {
            this.suspended = true;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    }
}

