/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.CloudFile;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.ecms.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;

public class CloudFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(CloudFileFilter.class);

    public CloudFileFilter() {
    }

    public CloudFileFilter(List<String> providers) {
        super(providers);
    }

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService;
        CloudDrive drive;
        if (node != null && (drive = (driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)).findDrive(node)) != null) {
            try {
                if (this.acceptProvider(drive.getUser().getProvider())) {
                    CloudFile file = drive.getFile(node.getPath());
                    WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    rcontext.setAttribute(CloudDrive.class, (Object)drive);
                    rcontext.setAttribute(CloudFile.class, (Object)file);
                    return true;
                }
            }
            catch (DriveRemovedException e) {
            }
            catch (NotYetCloudFileException e) {
            }
            catch (NotCloudFileException e) {
            }
            catch (NotCloudDriveException e) {
                // empty catch block
            }
        }
        return false;
    }
}

